/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.diff.DeleteBaselinesCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.List;

public final class DeleteBaselineCommandAdapter
extends CompositeCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_BASELINES;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (!elements.isEmpty()) {
            for (Element nextElement : elements) {
                if (nextElement instanceof Baseline) continue;
                return null;
            }
            Baseline baseline = (Baseline)elements.get(0);
            if (elements.size() == 1) {
                return new CompositeCommandAdapter.Applicable(baseline.getPresentationKind() + " [" + baseline.getIdentifyingPath() + "]", baseline.getPresentationKind());
            }
            return new CompositeCommandAdapter.Applicable(baseline.getPresentationKind() + "s");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        final List baselines = CommandHandler.getMultipleSelection(Baseline.class, elements);
        DeleteBaselinesCommand.IDeleteInteraction interaction = new DeleteBaselinesCommand.IDeleteInteraction(){

            public boolean collect(DeleteBaselinesCommand.InteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                for (Baseline next : baselines) {
                    data.addBaseline(next);
                }
                return true;
            }

            public void processResult(OperationResult result) {
                UserInterfaceAdapter.getInstance().process(result);
            }

            public boolean confirmDeletion(String info) {
                if (!($assertionsDisabled || info != null && info.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'info' of method 'confirmDeletion' must not be empty");
                }
                return UserInterfaceAdapter.getInstance().question(info, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }
        };
        DeleteBaselinesCommand cmd = new DeleteBaselinesCommand(provider, interaction);
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }
}

