/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.dependenciesview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CreateBalancedDependencyRepresentationCommand;
import com.hello2morrow.sonargraph.core.command.system.ExpandBalancedDependencyCommand;
import com.hello2morrow.sonargraph.core.command.system.RemoveRepresentationFromModelCommand;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationRemovedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.programming.DependencyType;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependency;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependencyRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.CreateRepresentationMode;
import com.hello2morrow.sonargraph.core.model.representation.ElementGroupForDependencies;
import com.hello2morrow.sonargraph.core.model.representation.IBalancedDependencyRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElementGroup;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.DependenciesContentProvider;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.DependenciesViewSorter;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.DependencyColumnId;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.IncomingDependenciesColumnLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.InternalDependenciesColumnLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.dependenciesview.OutgoingDependenciesColumnLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.RepresentationViewDeadStateInfoProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.TreeBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependenciesView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
ITreeViewerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependenciesView.class);
    private static final RepresentationViewDeadStateInfoProvider DEAD_STATE_INFO_PROVIDER = new RepresentationViewDeadStateInfoProvider();
    private static final String INCOMING_DEPENDENCIES = "Incoming dependencies";
    private static final String INTERNAL_DEPENDENCIES = "Internal dependencies";
    private static final String OUTGOING_DEPENDENCIES = "Outgoing dependencies";
    private static final String INCOMING_FIRST_COLUMN_NAME = "Incoming - To";
    private static final String INTERNAL_FIRST_COLUMN_NAME = "Internal - From";
    private static final String OUTGOING_FIRST_COLUMN_NAME = "Outgoing - From";
    private final DependenciesViewSorter m_incomingViewSorter = new DependenciesViewSorter();
    private final DependenciesViewSorter m_internalViewSorter = new DependenciesViewSorter();
    private final DependenciesViewSorter m_outgoingViewSorter = new DependenciesViewSorter();
    private final Map<Pair<NamedElement, NamedElement>, BalancedDependency> m_endpointsToSymmetricDependency = new HashMap<Pair<NamedElement, NamedElement>, BalancedDependency>();
    private TreeViewer m_incomingDependenciesViewer;
    private TreeViewer m_internalDependenciesViewer;
    private TreeViewer m_outgoingDependenciesViewer;
    private final DependenciesContentProvider m_incomingContentProvider = new DependenciesContentProvider();
    private final DependenciesContentProvider m_internalContentProvider = new DependenciesContentProvider();
    private final DependenciesContentProvider m_outgoingContentProvider = new DependenciesContentProvider();
    private BalancedDependencyRepresentation m_balancedDependencyRepresentation;
    private List<Element> m_elementsForView;
    private SelectedComponent m_selectedComponent = SelectedComponent.INCOMING;
    private TreeBasedTextSearchHandler m_incomingTextSearchHandler;
    private TreeBasedTextSearchHandler m_internalTextSearchHandler;
    private TreeBasedTextSearchHandler m_outgoingTextSearchHandler;
    private boolean m_isViewReady = false;

    public boolean isReady() {
        return this.m_isViewReady;
    }

    protected boolean supportsSleep() {
        return false;
    }

    public IViewId getViewId() {
        return ViewId.DEPENDENCIES_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    public StructureMode getStructureMode() {
        return StructureMode.NON_RECURSIVE;
    }

    private TreeViewerColumn createColumn(final TreeViewer treeViewer, String title, int width, final DependencyColumnId columnId, int style) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'createColumn' must not be null";
        assert (columnId != null) : "Parameter 'columnId' of method 'createColumn' must not be null";
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, style);
        final TreeColumn column = viewerColumn.getColumn();
        column.setWidth(width);
        if (title != null) {
            column.setText(title);
        }
        if (treeViewer == this.m_incomingDependenciesViewer) {
            viewerColumn.setLabelProvider((CellLabelProvider)new IncomingDependenciesColumnLabelProvider(columnId));
        } else if (treeViewer == this.m_internalDependenciesViewer) {
            viewerColumn.setLabelProvider((CellLabelProvider)new InternalDependenciesColumnLabelProvider(columnId));
        } else if (treeViewer == this.m_outgoingDependenciesViewer) {
            viewerColumn.setLabelProvider((CellLabelProvider)new OutgoingDependenciesColumnLabelProvider(columnId));
        } else assert (false) : "Unexpected viewer for 'parent' " + String.valueOf(treeViewer);
        final Tree tree = treeViewer.getTree();
        ViewerComparator comparator = treeViewer.getComparator();
        assert (comparator instanceof DependenciesViewSorter) : "Unexpected class " + comparator.getClass().getCanonicalName();
        final DependenciesViewSorter sorter = (DependenciesViewSorter)comparator;
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setColumn(columnId);
                int dir = sorter.getDirection();
                tree.setSortDirection(dir);
                tree.setSortColumn(column);
                treeViewer.refresh();
            }
        });
        return viewerColumn;
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.m_incomingDependenciesViewer = new TreeViewer((Composite)sashForm, 65536);
        this.m_incomingDependenciesViewer.setContentProvider((IContentProvider)this.m_incomingContentProvider);
        this.m_incomingDependenciesViewer.setComparator((ViewerComparator)this.m_incomingViewSorter);
        this.createColumn(this.m_incomingDependenciesViewer, INCOMING_FIRST_COLUMN_NAME, 250, DependencyColumnId.TO, 0);
        this.createColumn(this.m_incomingDependenciesViewer, null, 20, DependencyColumnId.ICON, 0);
        this.createColumn(this.m_incomingDependenciesViewer, "Dependency Type", 150, DependencyColumnId.DEPENDENCY_TYPE, 0);
        this.createColumn(this.m_incomingDependenciesViewer, "From", 250, DependencyColumnId.FROM, 0);
        this.createColumn(this.m_incomingDependenciesViewer, "From scope", 150, DependencyColumnId.FROM_SCOPE, 0);
        this.createColumn(this.m_incomingDependenciesViewer, "Number of dependencies", 150, DependencyColumnId.NUMBER_OF_DEPENDENCIES, 131072);
        this.m_incomingDependenciesViewer.getTree().setHeaderVisible(true);
        this.m_internalDependenciesViewer = new TreeViewer((Composite)sashForm, 65536);
        this.m_internalDependenciesViewer.setContentProvider((IContentProvider)this.m_internalContentProvider);
        this.m_internalDependenciesViewer.setComparator((ViewerComparator)this.m_internalViewSorter);
        this.createColumn(this.m_internalDependenciesViewer, INTERNAL_FIRST_COLUMN_NAME, 250, DependencyColumnId.FROM, 0);
        this.createColumn(this.m_internalDependenciesViewer, null, 20, DependencyColumnId.ICON, 0);
        this.createColumn(this.m_internalDependenciesViewer, "Dependency Type", 150, DependencyColumnId.DEPENDENCY_TYPE, 0);
        this.createColumn(this.m_internalDependenciesViewer, "To", 250, DependencyColumnId.TO, 0);
        this.createColumn(this.m_internalDependenciesViewer, "Number of dependencies", 150, DependencyColumnId.NUMBER_OF_DEPENDENCIES, 131072);
        this.m_internalDependenciesViewer.getTree().setHeaderVisible(true);
        this.m_outgoingDependenciesViewer = new TreeViewer((Composite)sashForm, 65536);
        this.m_outgoingDependenciesViewer.setContentProvider((IContentProvider)this.m_outgoingContentProvider);
        this.m_outgoingDependenciesViewer.setComparator((ViewerComparator)this.m_outgoingViewSorter);
        this.createColumn(this.m_outgoingDependenciesViewer, OUTGOING_FIRST_COLUMN_NAME, 250, DependencyColumnId.FROM, 0);
        this.createColumn(this.m_outgoingDependenciesViewer, null, 20, DependencyColumnId.ICON, 0);
        this.createColumn(this.m_outgoingDependenciesViewer, "Dependency Type", 150, DependencyColumnId.DEPENDENCY_TYPE, 0);
        this.createColumn(this.m_outgoingDependenciesViewer, "To", 250, DependencyColumnId.TO, 0);
        this.createColumn(this.m_outgoingDependenciesViewer, "To scope", 150, DependencyColumnId.TO_SCOPE, 0);
        this.createColumn(this.m_outgoingDependenciesViewer, "Number of dependencies", 150, DependencyColumnId.NUMBER_OF_DEPENDENCIES, 131072);
        this.m_outgoingDependenciesViewer.getTree().setHeaderVisible(true);
        this.m_incomingTextSearchHandler = new TreeBasedTextSearchHandler(this.m_incomingDependenciesViewer, this.getViewId().getPresentationName());
        this.m_internalTextSearchHandler = new TreeBasedTextSearchHandler(this.m_internalDependenciesViewer, this.getViewId().getPresentationName());
        this.m_outgoingTextSearchHandler = new TreeBasedTextSearchHandler(this.m_outgoingDependenciesViewer, this.getViewId().getPresentationName());
        EventManager.getInstance().attach((EventHandler)new EventHandler<RepresentationModifiedEvent>(RepresentationModifiedEvent.class, (Object)this){

            public void handleEvent(RepresentationModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (DependenciesView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && DependenciesView.this.m_isViewReady) {
                    Representation representation = event.getRepresentation();
                    if (DependenciesView.this.m_balancedDependencyRepresentation != null && DependenciesView.this.m_balancedDependencyRepresentation.getName().equals(representation.getName())) {
                        if (!$assertionsDisabled && !(representation instanceof BalancedDependencyRepresentation)) {
                            throw new AssertionError((Object)("Unexpected class in method 'handleEvent': " + String.valueOf(representation)));
                        }
                        NavigationState navigationState = ViewNavigationManager.getInstance().getCurrentViewNavigationState(DependenciesView.this.getViewId(), DependenciesView.this.getSecondaryId());
                        if (navigationState == null) {
                            LOGGER.warn("No 'current' navigation state found for: " + String.valueOf(DependenciesView.this.getViewId()));
                        }
                        if (event.modelRecreated()) {
                            DependenciesView.this.removeListeners();
                            DependenciesView.this.setRedraw(false);
                            DependenciesView.this.m_balancedDependencyRepresentation = (BalancedDependencyRepresentation)representation;
                            DependenciesView.this.m_incomingContentProvider.setRepresentation(DependenciesView.this.m_balancedDependencyRepresentation);
                            DependenciesView.this.m_internalContentProvider.setRepresentation(DependenciesView.this.m_balancedDependencyRepresentation);
                            DependenciesView.this.m_outgoingContentProvider.setRepresentation(DependenciesView.this.m_balancedDependencyRepresentation);
                            DependenciesView.this.setInputAndNumberOfElements(DependenciesView.this.m_incomingDependenciesViewer, DependenciesView.this.m_balancedDependencyRepresentation.getIncomingDependencies(), DependenciesView.INCOMING_FIRST_COLUMN_NAME);
                            DependenciesView.this.setInputAndNumberOfElements(DependenciesView.this.m_internalDependenciesViewer, DependenciesView.this.m_balancedDependencyRepresentation.getInternalDependencies(), DependenciesView.INTERNAL_FIRST_COLUMN_NAME);
                            DependenciesView.this.setInputAndNumberOfElements(DependenciesView.this.m_outgoingDependenciesViewer, DependenciesView.this.m_balancedDependencyRepresentation.getOutgoingDependencies(), DependenciesView.OUTGOING_FIRST_COLUMN_NAME);
                            DependenciesView.this.saveDependenciesForNavigation(DependenciesView.this.m_balancedDependencyRepresentation);
                            if (navigationState != null) {
                                DependenciesView.this.applyNavigationState((BalancedDependencyRepresentation)representation, navigationState, CreateRepresentationMode.UPDATE);
                            }
                            DependenciesView.this.setRedraw(true);
                            DependenciesView.this.addListeners();
                            DependenciesView.this.m_isViewReady = true;
                        } else {
                            DependenciesView.this.setRedraw(false);
                            DependenciesView.this.removeListeners();
                            DependenciesView.this.m_incomingDependenciesViewer.refresh();
                            DependenciesView.this.m_internalDependenciesViewer.refresh();
                            DependenciesView.this.m_outgoingDependenciesViewer.refresh();
                            if (navigationState != null) {
                                DependenciesView.this.applyNavigationState((BalancedDependencyRepresentation)representation, navigationState, CreateRepresentationMode.UPDATE);
                            }
                            DependenciesView.this.addListeners();
                            DependenciesView.this.setRedraw(true);
                        }
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<RepresentationRemovedEvent>(RepresentationRemovedEvent.class, (Object)this){

            public void handleEvent(RepresentationRemovedEvent event) {
                if (DependenciesView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    Representation removedRepresentation = event.getRepresentation();
                    if (DependenciesView.this.m_balancedDependencyRepresentation != null && DependenciesView.this.m_balancedDependencyRepresentation.getName().equals(removedRepresentation.getName())) {
                        DependenciesView.this.hideView();
                    }
                }
            }
        });
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (this.m_incomingDependenciesViewer.getControl() == component) {
            this.m_selectedComponent = SelectedComponent.INCOMING;
            this.m_incomingDependenciesViewer.getTree().setFocus();
        } else if (this.m_internalDependenciesViewer.getControl() == component) {
            this.m_selectedComponent = SelectedComponent.INTERNAL;
            this.m_internalDependenciesViewer.getTree().setFocus();
        } else if (this.m_outgoingDependenciesViewer.getControl() == component) {
            this.m_selectedComponent = SelectedComponent.OUTGOING;
            this.m_outgoingDependenciesViewer.getTree().setFocus();
        } else assert (false) : "Unhandled compoment: " + String.valueOf(component);
    }

    public Control getSelectedViewComponent() {
        switch (this.m_selectedComponent) {
            case INCOMING: {
                return this.m_incomingDependenciesViewer.getTree();
            }
            case INTERNAL: {
                return this.m_internalDependenciesViewer.getTree();
            }
            case OUTGOING: {
                return this.m_outgoingDependenciesViewer.getTree();
            }
        }
        assert (false) : "Unexpected value for 'm_selectedComponent': " + String.valueOf((Object)this.m_selectedComponent);
        return null;
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control == this.m_incomingDependenciesViewer.getTree()) {
            this.m_incomingDependenciesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_internalDependenciesViewer.getTree()) {
            this.m_internalDependenciesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_outgoingDependenciesViewer.getTree()) {
            this.m_outgoingDependenciesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_incomingDependenciesViewer.getControl(), this.m_internalDependenciesViewer.getControl(), this.m_outgoingDependenciesViewer.getControl());
    }

    public List<Control> getViewComponents() {
        return this.getControlsForInteraction();
    }

    public Search supportsSearch() {
        return this.isReady() ? Search.FIND_TEXT : Search.NONE;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        switch (this.m_selectedComponent) {
            case INCOMING: {
                return this.m_incomingTextSearchHandler;
            }
            case INTERNAL: {
                return this.m_internalTextSearchHandler;
            }
            case OUTGOING: {
                return this.m_outgoingTextSearchHandler;
            }
        }
        assert (false) : "Unexpected value for 'm_selectedComponent': " + String.valueOf((Object)this.m_selectedComponent);
        return null;
    }

    private void setRedraw(boolean redraw) {
        this.m_incomingDependenciesViewer.getControl().setRedraw(redraw);
        this.m_internalDependenciesViewer.getControl().setRedraw(redraw);
        this.m_outgoingDependenciesViewer.getControl().setRedraw(redraw);
    }

    private void removeListeners() {
        this.m_incomingDependenciesViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_internalDependenciesViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_outgoingDependenciesViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_incomingDependenciesViewer.removeTreeListener((ITreeViewerListener)this);
        this.m_internalDependenciesViewer.removeTreeListener((ITreeViewerListener)this);
        this.m_outgoingDependenciesViewer.removeTreeListener((ITreeViewerListener)this);
    }

    private void addListeners() {
        this.m_incomingDependenciesViewer.addTreeListener((ITreeViewerListener)this);
        this.m_internalDependenciesViewer.addTreeListener((ITreeViewerListener)this);
        this.m_outgoingDependenciesViewer.addTreeListener((ITreeViewerListener)this);
        this.m_incomingDependenciesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_internalDependenciesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_outgoingDependenciesViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void setInputAndNumberOfElements(TreeViewer viewer, Collection<?> input, String originalColumnName) {
        assert (viewer != null) : "Parameter 'viewer' of method 'setInputAndNumberOfElements' must not be null";
        viewer.setInput(input);
        TreeColumn column = viewer.getTree().getColumn(0);
        assert (column != null) : "Parameter 'column' of method 'setInputAndNumberOfElements' must not be null";
        if (input == null) {
            column.setText(originalColumnName);
        } else {
            column.setText(originalColumnName + " [" + NumberUtility.format((Number)input.size()) + " elements]");
        }
    }

    private void clear() {
        this.m_incomingDependenciesViewer.setInput(null);
        this.m_internalDependenciesViewer.setInput(null);
        this.m_outgoingDependenciesViewer.setInput(null);
        this.m_endpointsToSymmetricDependency.clear();
        this.m_balancedDependencyRepresentation = null;
        this.setInputAndNumberOfElements(this.m_incomingDependenciesViewer, null, INCOMING_FIRST_COLUMN_NAME);
        this.setInputAndNumberOfElements(this.m_internalDependenciesViewer, null, INTERNAL_FIRST_COLUMN_NAME);
        this.setInputAndNumberOfElements(this.m_outgoingDependenciesViewer, null, OUTGOING_FIRST_COLUMN_NAME);
    }

    private void clearAndCloseView() {
        this.removeListeners();
        this.hideView();
    }

    private void saveDependenciesForNavigation(BalancedDependencyRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'saveDependenciesForNavigation' must not be null";
        this.m_endpointsToSymmetricDependency.putAll(((IBalancedDependencyRepresentationProvider)this.getSoftwareSystem().getExtension(IBalancedDependencyRepresentationProvider.class)).getEndpointsForAllDependencies(representation));
    }

    private void applyNavigationState(BalancedDependencyRepresentation representation, NavigationState state, CreateRepresentationMode mode) {
        assert (representation != null) : "Parameter 'representation' of method 'applyNavigationState' must not be null";
        assert (state != null) : "Parameter 'state' of method 'applyNavigationState' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'applyNavigationState' must not be null";
        String viewSection = state.getString((IStateData)ViewData.TAB);
        Set incomingSelectedEndpoints = state.getDependenciesEndpoints((IElementGroup)ElementGroupForDependencies.INCOMING_SELECTION, this.getElementResolver());
        Set internalSelectedEndpoints = state.getDependenciesEndpoints((IElementGroup)ElementGroupForDependencies.INTERNAL_SELECTION, this.getElementResolver());
        Set outgoingSelectedEndpoints = state.getDependenciesEndpoints((IElementGroup)ElementGroupForDependencies.OUTGOING_SELECTION, this.getElementResolver());
        Set incomingExpandedEndpoints = mode == CreateRepresentationMode.NAVIGATION ? state.getDependenciesEndpoints((IElementGroup)ElementGroupForDependencies.INCOMING_EXPANSION, this.getElementResolver()) : representation.getExpandedDependenciesAsEndpoints(DependencyType.INCOMING);
        Set internalExpandedEndpoints = mode == CreateRepresentationMode.NAVIGATION ? state.getDependenciesEndpoints((IElementGroup)ElementGroupForDependencies.INTERNAL_EXPANSION, this.getElementResolver()) : representation.getExpandedDependenciesAsEndpoints(DependencyType.INTERNAL);
        Set outgoingExpandedEndpoints = mode == CreateRepresentationMode.NAVIGATION ? state.getDependenciesEndpoints((IElementGroup)ElementGroupForDependencies.OUTGOING_EXPANSION, this.getElementResolver()) : representation.getExpandedDependenciesAsEndpoints(DependencyType.OUTGOING);
        Collection<BalancedDependency> incomingDependenciesSelection = this.getDependencyFromEndpoints(incomingSelectedEndpoints);
        Collection<BalancedDependency> internalDependenciesSelection = this.getDependencyFromEndpoints(internalSelectedEndpoints);
        Collection<BalancedDependency> outgoingDependenciesSelection = this.getDependencyFromEndpoints(outgoingSelectedEndpoints);
        StructuredSelection incomingSelection = new StructuredSelection(incomingDependenciesSelection.toArray());
        StructuredSelection internalSelection = new StructuredSelection(internalDependenciesSelection.toArray());
        StructuredSelection outgoingSelection = new StructuredSelection(outgoingDependenciesSelection.toArray());
        Collection<BalancedDependency> incomingDependenciesExpansion = this.getDependencyFromEndpoints(incomingExpandedEndpoints);
        Collection<BalancedDependency> internalDependenciesExpansion = this.getDependencyFromEndpoints(internalExpandedEndpoints);
        Collection<BalancedDependency> outgoingDependenciesExpansion = this.getDependencyFromEndpoints(outgoingExpandedEndpoints);
        Object[] incomingCurrentlyExpanded = this.m_incomingDependenciesViewer.getExpandedElements();
        Object[] internalCurrentlyExpanded = this.m_internalDependenciesViewer.getExpandedElements();
        Object[] outgoingCurrentlyExpanded = this.m_outgoingDependenciesViewer.getExpandedElements();
        if (!Arrays.equals(incomingDependenciesExpansion.toArray(), incomingCurrentlyExpanded)) {
            this.m_incomingDependenciesViewer.collapseAll();
        }
        if (!Arrays.equals(internalDependenciesExpansion.toArray(), internalCurrentlyExpanded)) {
            this.m_internalDependenciesViewer.collapseAll();
        }
        if (!Arrays.equals(outgoingDependenciesExpansion.toArray(), outgoingCurrentlyExpanded)) {
            this.m_outgoingDependenciesViewer.collapseAll();
        }
        this.m_incomingDependenciesViewer.setSelection((ISelection)incomingSelection);
        this.m_internalDependenciesViewer.setSelection((ISelection)internalSelection);
        this.m_outgoingDependenciesViewer.setSelection((ISelection)outgoingSelection);
        if (viewSection.equals(INCOMING_DEPENDENCIES)) {
            this.m_incomingDependenciesViewer.getControl().setFocus();
        } else if (viewSection.equals(INTERNAL_DEPENDENCIES)) {
            this.m_internalDependenciesViewer.getControl().setFocus();
        } else if (viewSection.equals(OUTGOING_DEPENDENCIES)) {
            this.m_outgoingDependenciesViewer.getControl().setFocus();
        }
        this.m_incomingDependenciesViewer.setExpandedElements(incomingDependenciesExpansion.toArray());
        this.m_internalDependenciesViewer.setExpandedElements(internalDependenciesExpansion.toArray());
        this.m_outgoingDependenciesViewer.setExpandedElements(outgoingDependenciesExpansion.toArray());
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, final boolean secondaryIdReused) {
        assert (elements != null && elements.size() == 1) : "Parameter 'elements' of method 'showInView' must contain exactly 1 element";
        ViewNavigationManager.getInstance().clear(this.getViewId(), this.getSecondaryId());
        if (secondaryIdReused) {
            assert (this.m_balancedDependencyRepresentation != null) : "Parameter 'm_balancedDependencyRepresentation' of method 'showInView' must not be null";
            this.m_balancedDependencyRepresentation.remove();
        }
        assert (elements.get(0) instanceof NamedElement) : "Unexpected class in method 'showInView': " + String.valueOf(elements.get(0));
        final NamedElement element = (NamedElement)elements.get(0);
        this.setRedraw(false);
        this.clear();
        this.setRedraw(true);
        this.m_incomingTextSearchHandler.requestNewFindInfo();
        this.m_internalTextSearchHandler.requestNewFindInfo();
        this.m_outgoingTextSearchHandler.requestNewFindInfo();
        this.m_elementsForView = elements;
        this.setPartName(element.getPresentationName(true));
        final CreateBalancedDependencyRepresentationCommand cmd = new CreateBalancedDependencyRepresentationCommand(this.getSoftwareSystemProvider(), element);
        this.m_isViewReady = false;
        if (cmd.isEnabled().isSuccess()) {
            UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    BalancedDependencyRepresentation representation = cmd.getRepresentation();
                    if (exception == null && element.isValid() && DependenciesView.this.m_incomingDependenciesViewer != null && DependenciesView.this.m_internalDependenciesViewer != null && DependenciesView.this.m_outgoingDependenciesViewer != null && !DependenciesView.this.m_incomingDependenciesViewer.getTree().isDisposed() && !DependenciesView.this.m_internalDependenciesViewer.getTree().isDisposed() && !DependenciesView.this.m_outgoingDependenciesViewer.getTree().isDisposed()) {
                        if (!$assertionsDisabled && representation == null) {
                            throw new AssertionError((Object)"'representation' of method 'consume' must not be null");
                        }
                        DependenciesView.this.removeListeners();
                        DependenciesView.this.setRedraw(false);
                        DependenciesView.this.m_balancedDependencyRepresentation = representation;
                        DependenciesView.this.m_incomingContentProvider.setRepresentation(DependenciesView.this.m_balancedDependencyRepresentation);
                        DependenciesView.this.m_internalContentProvider.setRepresentation(DependenciesView.this.m_balancedDependencyRepresentation);
                        DependenciesView.this.m_outgoingContentProvider.setRepresentation(DependenciesView.this.m_balancedDependencyRepresentation);
                        DependenciesView.this.setInputAndNumberOfElements(DependenciesView.this.m_incomingDependenciesViewer, DependenciesView.this.m_balancedDependencyRepresentation.getIncomingDependencies(), DependenciesView.INCOMING_FIRST_COLUMN_NAME);
                        DependenciesView.this.setInputAndNumberOfElements(DependenciesView.this.m_internalDependenciesViewer, DependenciesView.this.m_balancedDependencyRepresentation.getInternalDependencies(), DependenciesView.INTERNAL_FIRST_COLUMN_NAME);
                        DependenciesView.this.setInputAndNumberOfElements(DependenciesView.this.m_outgoingDependenciesViewer, DependenciesView.this.m_balancedDependencyRepresentation.getOutgoingDependencies(), DependenciesView.OUTGOING_FIRST_COLUMN_NAME);
                        DependenciesView.this.saveDependenciesForNavigation(DependenciesView.this.m_balancedDependencyRepresentation);
                        DependenciesView.this.setRedraw(true);
                        DependenciesView.this.addListeners();
                        DependenciesView.this.m_isViewReady = true;
                        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)DependenciesView.this);
                        if (secondaryIdReused) {
                            NavigationState state = ViewNavigationManager.getInstance().createNavigationState(DependenciesView.this.getViewId(), DependenciesView.this.getSecondaryId(), NavigationState.Type.CONTENT_VIEW_INSTANCE_REUSED);
                            DependenciesView.this.completeNavigationState(state, true);
                            ViewNavigationManager.getInstance().addNavigationState(state);
                        }
                    } else {
                        if (representation != null) {
                            DependenciesView.this.removeRepresentationFromModel(representation, false);
                        }
                        DependenciesView.this.hideView();
                    }
                }
            });
        }
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.clearAndCloseView();
        this.m_isViewReady = false;
    }

    public List<Element> getSelectedElements() {
        if (!this.isReady()) {
            return Collections.emptyList();
        }
        IStructuredSelection selection = null;
        switch (this.m_selectedComponent) {
            case INCOMING: {
                selection = (IStructuredSelection)this.m_incomingDependenciesViewer.getSelection();
                break;
            }
            case INTERNAL: {
                selection = (IStructuredSelection)this.m_internalDependenciesViewer.getSelection();
                break;
            }
            case OUTGOING: {
                selection = (IStructuredSelection)this.m_outgoingDependenciesViewer.getSelection();
                break;
            }
            default: {
                assert (false) : "Unhandled component: " + String.valueOf((Object)this.m_selectedComponent);
                break;
            }
        }
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        List selectionAsList = selection.toList();
        ArrayList<Element> selected = new ArrayList<Element>(selectionAsList.size());
        for (Object next : selection.toList()) {
            assert (next instanceof BalancedDependency) : "Unexpected class: " + String.valueOf(next);
            selected.add((Element)((BalancedDependency)next));
        }
        return selected;
    }

    private Collection<RepresentationDependency> getSelectionForViewer(TreeViewer viewer) {
        assert (viewer != null) : "Parameter 'viewer' of method 'getSelectionForViewer' must not be null";
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        ArrayList<RepresentationDependency> selected = new ArrayList<RepresentationDependency>(selection.size());
        for (Object next : selection.toList()) {
            assert (next != null && next instanceof BalancedDependency) : "Unexpected class in method 'getSelectionForViewer': " + String.valueOf(next);
            selected.add((RepresentationDependency)((BalancedDependency)next));
        }
        return selected;
    }

    private Collection<RepresentationDependency> getExpansionForViewer(TreeViewer viewer) {
        assert (viewer != null) : "Parameter 'viewer' of method 'getExpansionForViewer' must not be null";
        Object[] expandedObjects = viewer.getExpandedElements();
        ArrayList<RepresentationDependency> expanded = new ArrayList<RepresentationDependency>(expandedObjects.length);
        Object[] objectArray = expandedObjects;
        int n = expandedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            assert (next != null && next instanceof BalancedDependency) : "Unexpected class in method 'getExpansionForViewer': " + String.valueOf(next);
            expanded.add((RepresentationDependency)((BalancedDependency)next));
            ++n2;
        }
        return expanded;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        Object source = event.getSource();
        if (source == this.m_incomingDependenciesViewer) {
            this.m_selectedComponent = SelectedComponent.INCOMING;
        } else if (source == this.m_internalDependenciesViewer) {
            this.m_selectedComponent = SelectedComponent.INTERNAL;
        } else if (source == this.m_outgoingDependenciesViewer) {
            this.m_selectedComponent = SelectedComponent.OUTGOING;
        } else assert (false) : "Unexpected viewer selected";
        this.initializeTextSearchData();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.completeNavigationState(state, true);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'treeCollapsed' must not be null";
        Object object = event.getElement();
        assert (object != null && object instanceof BalancedDependency) : "Unexpected class in method 'treeCollapsed': " + String.valueOf(object);
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_COLLAPSED);
        this.completeNavigationState(state, true);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    public void treeExpanded(TreeExpansionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'treeExpanded' must not be null";
        Object object = event.getElement();
        assert (object != null && object instanceof BalancedDependency) : "Unexpected class in method 'treeCollapsed': " + String.valueOf(object);
        final BalancedDependency dependency = (BalancedDependency)object;
        if (!dependency.hasChildren()) {
            ExpandBalancedDependencyCommand cmd = new ExpandBalancedDependencyCommand(WorkbenchRegistry.getInstance().getProvider(), this.m_balancedDependencyRepresentation, dependency);
            final TreeViewer expandedViewer = (TreeViewer)event.getSource();
            final Object[] expanded = expandedViewer.getExpandedElements();
            this.m_isViewReady = false;
            if (cmd.isEnabled().isSuccess()) {
                UserInterfaceAdapter.getInstance().run((Command)cmd, new CommandResultConsumer(){

                    public void consume(CommandException exception) {
                        super.consume(exception);
                        if (exception == null && dependency.isValid() && DependenciesView.this.m_incomingDependenciesViewer != null && DependenciesView.this.m_internalDependenciesViewer != null && DependenciesView.this.m_outgoingDependenciesViewer != null && !DependenciesView.this.m_incomingDependenciesViewer.getTree().isDisposed() && !DependenciesView.this.m_internalDependenciesViewer.getTree().isDisposed() && !DependenciesView.this.m_outgoingDependenciesViewer.getTree().isDisposed()) {
                            for (BalancedDependency child : dependency.getChildren()) {
                                Pair endpoint = new Pair((Object)child.getFromEndPoint(), (Object)child.getToEndPoint());
                                if (DependenciesView.this.m_endpointsToSymmetricDependency.containsKey(endpoint)) continue;
                                DependenciesView.this.m_endpointsToSymmetricDependency.put((Pair<NamedElement, NamedElement>)endpoint, child);
                            }
                            ArrayList<Object> completeExpanded = new ArrayList<Object>(Arrays.asList(expanded));
                            completeExpanded.add(dependency);
                            expandedViewer.getTree().setRedraw(false);
                            expandedViewer.setExpandedElements(completeExpanded.toArray(new Object[completeExpanded.size()]));
                            expandedViewer.refresh();
                            expandedViewer.getTree().setRedraw(true);
                            NavigationState state = ViewNavigationManager.getInstance().createNavigationState(DependenciesView.this.getViewId(), DependenciesView.this.getSecondaryId(), NavigationState.Type.CONTENT_EXPANDED);
                            DependenciesView.this.completeNavigationState(state, true);
                            ViewNavigationManager.getInstance().addNavigationState(state);
                            DependenciesView.this.m_isViewReady = true;
                        }
                    }
                });
            }
        } else {
            NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_EXPANDED);
            this.completeNavigationState(state, true);
            ViewNavigationManager.getInstance().addNavigationState(state);
        }
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreNavigationState' must not be null";
        if (state.isInvolvedInUndoRedoOperation()) {
            return;
        }
        this.removeListeners();
        this.setRedraw(false);
        this.applyNavigationState(this.m_balancedDependencyRepresentation, state, CreateRepresentationMode.NAVIGATION);
        this.setRedraw(true);
        this.addListeners();
    }

    private Collection<BalancedDependency> getDependencyFromEndpoints(Collection<Pair<NamedElement, NamedElement>> endPoints) {
        assert (endPoints != null) : "Parameter 'endPoints' of method 'getDependencyFromEndpoints' must not be null";
        ArrayList<BalancedDependency> dependencies = new ArrayList<BalancedDependency>(endPoints.size());
        for (Pair<NamedElement, NamedElement> endpoint : endPoints) {
            BalancedDependency dependency = this.m_endpointsToSymmetricDependency.get(endpoint);
            if (dependency == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private void completeNavigationState(NavigationState state, boolean full) {
        assert (state != null) : "Parameter 'state' of method 'completeNavigationState' must not be null";
        switch (this.m_selectedComponent) {
            case INCOMING: {
                state.addString((IStateData)ViewData.TAB, INCOMING_DEPENDENCIES);
                break;
            }
            case INTERNAL: {
                state.addString((IStateData)ViewData.TAB, INTERNAL_DEPENDENCIES);
                break;
            }
            case OUTGOING: {
                state.addString((IStateData)ViewData.TAB, OUTGOING_DEPENDENCIES);
                break;
            }
            default: {
                assert (false) : "Unhandled component: " + String.valueOf((Object)this.m_selectedComponent);
                break;
            }
        }
        if (full) {
            state.addElementsInformation((IElementGroup)RepresentationElementGroup.REPRESENTATION, NavigationState.getDescriptors(Arrays.asList(this.m_balancedDependencyRepresentation), (IElementResolver)this.getElementResolver()));
            state.addElementsInformation((IElementGroup)RepresentationElementGroup.ORIGINAL_INPUT, NavigationState.getDescriptors(this.m_elementsForView, (IElementResolver)this.getElementResolver()));
            state.addDependenciesInformation((IElementGroup)ElementGroupForDependencies.INCOMING_SELECTION, RepresentationDependency.getDescriptors(this.getSelectionForViewer(this.m_incomingDependenciesViewer), (IElementResolver)this.getElementResolver()));
            state.addDependenciesInformation((IElementGroup)ElementGroupForDependencies.INTERNAL_SELECTION, RepresentationDependency.getDescriptors(this.getSelectionForViewer(this.m_internalDependenciesViewer), (IElementResolver)this.getElementResolver()));
            state.addDependenciesInformation((IElementGroup)ElementGroupForDependencies.OUTGOING_SELECTION, RepresentationDependency.getDescriptors(this.getSelectionForViewer(this.m_outgoingDependenciesViewer), (IElementResolver)this.getElementResolver()));
            state.addDependenciesInformation((IElementGroup)ElementGroupForDependencies.INCOMING_EXPANSION, RepresentationDependency.getDescriptors(this.getExpansionForViewer(this.m_incomingDependenciesViewer), (IElementResolver)this.getElementResolver()));
            state.addDependenciesInformation((IElementGroup)ElementGroupForDependencies.INTERNAL_EXPANSION, RepresentationDependency.getDescriptors(this.getExpansionForViewer(this.m_internalDependenciesViewer), (IElementResolver)this.getElementResolver()));
            state.addDependenciesInformation((IElementGroup)ElementGroupForDependencies.OUTGOING_EXPANSION, RepresentationDependency.getDescriptors(this.getExpansionForViewer(this.m_outgoingDependenciesViewer), (IElementResolver)this.getElementResolver()));
        }
        state.setDeadStateInfoProvider((NavigationState.IDeadStateInfoProvider)DEAD_STATE_INFO_PROVIDER);
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationStateForFocusGained' must not be null";
        this.completeNavigationState(state, this.isReady());
    }

    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof BalancedDependency) {
            BalancedDependency balancedDependency = (BalancedDependency)element;
            switch (balancedDependency.getDependencyType()) {
                case INCOMING: {
                    return balancedDependency.getFromEndPoint();
                }
                case OUTGOING: 
                case INTERNAL: {
                    return balancedDependency.getFromEndPoint();
                }
            }
            assert (false) : "Unexpected dependency type " + String.valueOf(balancedDependency.getDependencyType());
        }
        return null;
    }

    protected final void removeRepresentationFromModel(BalancedDependencyRepresentation representation, boolean fireRepresentationRemovedEvent) {
        assert (representation != null) : "Parameter 'representation' of method 'removeRepresentationFromModel' must not be null";
        if (representation.isValid()) {
            RemoveRepresentationFromModelCommand cmd = new RemoveRepresentationFromModelCommand(this.getSoftwareSystemProvider(), (Representation)representation, fireRepresentationRemovedEvent, false);
            UserInterfaceAdapter.getInstance().run((Command)cmd);
        }
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzerResultStateChangedEvent.class, (Object)this);
        EventManager.getInstance().detach(RepresentationModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(RepresentationRemovedEvent.class, (Object)this);
        this.m_selectedComponent = null;
        if (this.m_balancedDependencyRepresentation != null && this.m_balancedDependencyRepresentation.isValid()) {
            this.removeRepresentationFromModel(this.m_balancedDependencyRepresentation, true);
        }
        this.removeListeners();
        this.clear();
        super.destroyViewContent();
    }

    private static enum SelectedComponent {
        INCOMING,
        INTERNAL,
        OUTGOING;

    }

    private static enum ViewData implements IStateData
    {
        TAB;

    }
}

