/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.debugview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramCreatedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramDeletedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramModifiedEvent;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewSplitEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.InstallationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.NotificationAddedEvent;
import com.hello2morrow.sonargraph.core.model.event.NotificationsRemovedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.RepresentationRemovedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.ProgrammingElementDelta;
import com.hello2morrow.sonargraph.core.model.representation.ProgrammingElementDeltaManager;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PhysicalInfo;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.model.system.StructureItemRegistryNode;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.FocusableToolTip;
import com.hello2morrow.sonargraph.ui.standalone.debugview.DebugViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.debugview.ElementBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.debugview.NamedElementBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.debugview.NavigationStateBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.debugview.NodeAndEdgeRepresentationContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.debugview.ProgrammingElementDeltaBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.debugview.StructureItemRegistryNodeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebugView
extends WorkbenchView
implements ISelectionChangedListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(DebugView.class);
    private final ProgrammingElementDeltaBeanAdapter m_programmingElementCollectionStatesBeanAdapter = new ProgrammingElementDeltaBeanAdapter();
    @Inject
    private IEventBroker m_eventBroker;
    private org.osgi.service.event.EventHandler m_eventBrokerHandler;
    private final List<FocusableToolTip> m_focusableToolTips = new ArrayList<FocusableToolTip>();
    private TreeViewer m_treeViewer;
    private PropertyTableViewer<Element> m_receivedSelection;
    private PropertyTableViewer<Element> m_selectionServiceSelection;
    private PropertyTableViewer<NavigationState> m_navigationStates;
    private PropertyTableViewer<NavigationState> m_initalViewNavigationStates;
    private PropertyTableViewer<NavigationState> m_currentViewNavigationStates;
    private PropertyTableViewer<Map.Entry<Integer, ProgrammingElementDelta>> m_programmingElementCollectionStates;
    private PropertyTableViewer<NamedElement> m_mainNodesViewer;
    private PropertyTableViewer<NamedElement> m_additionalNodesViewer;
    private TreeViewer m_representationTreeViewer;
    private TreeViewer m_structureItemRegistryViewer;
    private Text m_debugInfo;
    private Text m_workbenchRegistryInfo;
    private List<Root> m_roots;
    private Element m_currentlyDisplayed;
    private StructureItemRegistryNode m_structureItemRegistryRootNode;

    protected boolean supportsSleep() {
        return false;
    }

    public boolean supportsNavigation() {
        return false;
    }

    public IViewId getViewId() {
        return ViewId.DEBUG_VIEW;
    }

    private void show() {
        ArrayList<Root> roots = new ArrayList<Root>(2);
        roots.add((Root)this.getSoftwareSystemProvider().getInstallation());
        if (this.getSoftwareSystemProvider().hasSoftwareSystem()) {
            roots.add((Root)this.getSoftwareSystemProvider().getSoftwareSystem());
            this.m_structureItemRegistryRootNode = ((IRepresentationProvider)this.getSoftwareSystemProvider().getSoftwareSystem().getExtension(IRepresentationProvider.class)).getRootNodeForStructure();
        }
        this.m_treeViewer.getControl().setRedraw(false);
        if (roots.equals(this.m_roots)) {
            this.m_treeViewer.refresh();
        } else {
            this.m_roots = roots;
            this.m_treeViewer.setInput((Object)this.m_roots.toArray(new Root[this.m_roots.size()]));
        }
        this.m_treeViewer.getControl().setRedraw(true);
        if (this.m_currentlyDisplayed != null && this.m_currentlyDisplayed.isValid()) {
            this.showDebugInfo(this.m_currentlyDisplayed);
        } else {
            this.m_currentlyDisplayed = null;
            this.showDebugInfo(null);
        }
        StringBuilder builder = new StringBuilder();
        IWorkbenchView view = WorkbenchRegistry.getInstance().getCurrentlySelectedView();
        if (view == null) {
            builder.append("[Workbench Registry] No view selected");
        } else {
            builder.append("[Workbench Registry] Selected view: ").append(view.getViewId()).append("/").append(view.getSecondaryId());
            builder.append("\n");
            builder.append("[Workbench Registry] Selected component: ");
            Control currentlySelectedViewComponent = WorkbenchRegistry.getInstance().getCurrentlySelectedViewComponent();
            if (currentlySelectedViewComponent != null) {
                builder.append(currentlySelectedViewComponent).append(" [").append(Integer.toHexString(currentlySelectedViewComponent.hashCode())).append("]");
            } else {
                builder.append("<None>");
            }
        }
        this.m_workbenchRegistryInfo.setText(builder.toString());
        this.m_navigationStates.getTable().setRedraw(false);
        this.m_navigationStates.showData((Collection)ViewNavigationManager.getInstance().getNavigationStates());
        NavigationState state = ViewNavigationManager.getInstance().getCurrentNavigationState();
        if (state != null) {
            this.m_navigationStates.getTableViewer().reveal((Object)state);
        }
        this.m_navigationStates.getTable().setRedraw(true);
        this.m_initalViewNavigationStates.getTable().setRedraw(false);
        this.m_initalViewNavigationStates.showData((Collection)ViewNavigationManager.getInstance().getInitialViewNavigationStates());
        this.m_initalViewNavigationStates.getTable().setRedraw(true);
        this.m_currentViewNavigationStates.getTable().setRedraw(false);
        this.m_currentViewNavigationStates.showData((Collection)ViewNavigationManager.getInstance().getCurrentViewNavigationStates());
        this.m_currentViewNavigationStates.getTable().setRedraw(true);
        List representations = Collections.emptyList();
        this.m_representationTreeViewer.getTree().setRedraw(false);
        if (this.getSoftwareSystemProvider().hasSoftwareSystem()) {
            if (this.m_representationTreeViewer.getInput() == null) {
                representations = this.getSoftwareSystem().getChildren(Representations.class);
                this.m_representationTreeViewer.setInput((Object)representations.toArray(new Representations[0]));
            } else {
                this.m_representationTreeViewer.refresh();
            }
        } else {
            this.m_representationTreeViewer.setInput(null);
        }
        this.m_representationTreeViewer.getTree().setRedraw(true);
        if (this.m_structureItemRegistryRootNode != null) {
            this.m_structureItemRegistryViewer.getTree().setRedraw(false);
            this.m_structureItemRegistryViewer.setInput(Collections.singletonList(this.m_structureItemRegistryRootNode));
            this.m_structureItemRegistryViewer.getTree().setRedraw(true);
        } else {
            this.m_structureItemRegistryViewer.getTree().setRedraw(false);
            this.m_structureItemRegistryViewer.setInput(null);
            this.m_structureItemRegistryViewer.getTree().setRedraw(true);
        }
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm rootSashForm = new SashForm(viewContentArea, 512);
        CTabFolder tabFolder = SwtUtility.createTabFolder((Composite)rootSashForm);
        CTabItem modelTabItem = new CTabItem(tabFolder, 0);
        modelTabItem.setText("Model");
        modelTabItem.setImage(UiResourceManager.getInstance().getImage("Model"));
        SashForm modelSashForm = new SashForm((Composite)tabFolder, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)modelSashForm);
        this.m_treeViewer = new TreeViewer((Composite)modelSashForm, 66306);
        DebugViewContentAndLabelProvider contentAndLabelProvider = new DebugViewContentAndLabelProvider();
        this.m_treeViewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        this.m_treeViewer.setUseHashlookup(true);
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_debugInfo = new Text((Composite)modelSashForm, 584);
        this.m_debugInfo.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        SashForm selectionSashForm = new SashForm((Composite)modelSashForm, 256);
        SwtUtility.applySashSeparatorStyle((SashForm)selectionSashForm);
        this.m_receivedSelection = new PropertyTableViewer((Composite)selectionSashForm, (BeanPropertyReader.BeanAdapter)new ElementBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_receivedSelection.addColumn("Selection Propagated", "name", "name", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_selectionServiceSelection = new PropertyTableViewer((Composite)selectionSashForm, (BeanPropertyReader.BeanAdapter)new ElementBeanAdapter(), "name", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_selectionServiceSelection.addColumn("Selection Service", "name", "name", "image", 100, PropertyTableViewer.ColumnType.TEXT);
        modelTabItem.setControl((Control)modelSashForm);
        modelSashForm.setWeights(new int[]{50, 25, 25});
        CTabItem navigationTabItem = new CTabItem(tabFolder, 0);
        navigationTabItem.setText("Navigation");
        navigationTabItem.setImage(UiResourceManager.getInstance().getImage("Navigation"));
        SashForm navigationSashForm = new SashForm((Composite)tabFolder, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)navigationSashForm);
        this.m_navigationStates = new PropertyTableViewer((Composite)navigationSashForm, (BeanPropertyReader.BeanAdapter)new NavigationStateBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_navigationStates.addColumn("Id", "id", null, null, 5, PropertyTableViewer.ColumnType.TEXT);
        this.m_navigationStates.addColumn("Navigation State", "navigationState", null, null, 45, PropertyTableViewer.ColumnType.TEXT);
        this.m_navigationStates.addColumn("Info", "info", null, null, 15, PropertyTableViewer.ColumnType.TEXT);
        this.m_navigationStates.addColumn("Type", "type", null, null, 35, PropertyTableViewer.ColumnType.TEXT);
        this.m_focusableToolTips.add(new FocusableToolTip((Control)this.m_navigationStates.getTable(), new FocusableToolTip.IToolTipProvider(){

            @Override
            public String getToolTipText(Point location) {
                Object data;
                TableItem tableItem = DebugView.this.m_navigationStates.getTable().getItem(location);
                if (tableItem != null && (data = tableItem.getData()) instanceof NavigationState) {
                    return data.toString();
                }
                return null;
            }
        }));
        this.m_initalViewNavigationStates = new PropertyTableViewer((Composite)navigationSashForm, (BeanPropertyReader.BeanAdapter)new NavigationStateBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_initalViewNavigationStates.addColumn("Initial View Navigation State", "navigationState", null, null, 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_initalViewNavigationStates.addColumn("Type", "type", null, null, 40, PropertyTableViewer.ColumnType.TEXT);
        this.m_currentViewNavigationStates = new PropertyTableViewer((Composite)navigationSashForm, (BeanPropertyReader.BeanAdapter)new NavigationStateBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_currentViewNavigationStates.addColumn("Current View Navigation State", "navigationState", null, null, 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_currentViewNavigationStates.addColumn("Type", "type", null, null, 40, PropertyTableViewer.ColumnType.TEXT);
        navigationTabItem.setControl((Control)navigationSashForm);
        navigationSashForm.setWeights(new int[]{50, 25, 25});
        this.m_workbenchRegistryInfo = new Text((Composite)rootSashForm, 584);
        this.m_workbenchRegistryInfo.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        rootSashForm.setWeights(new int[]{90, 10});
        CTabItem nodeAndEdgeRepresentationTabItem = new CTabItem(tabFolder, 0);
        nodeAndEdgeRepresentationTabItem.setText("Representations");
        nodeAndEdgeRepresentationTabItem.setImage(UiResourceManager.getInstance().getImage("Representations"));
        SashForm nodeAndEdgeRepresentationSashForm = new SashForm((Composite)tabFolder, 512);
        this.m_representationTreeViewer = new TreeViewer((Composite)nodeAndEdgeRepresentationSashForm, 770);
        NodeAndEdgeRepresentationContentAndLabelProvider nodeAndEdgeRepresentationContentAndLabelProvider = new NodeAndEdgeRepresentationContentAndLabelProvider();
        this.m_representationTreeViewer.setContentProvider((IContentProvider)nodeAndEdgeRepresentationContentAndLabelProvider);
        this.m_representationTreeViewer.setLabelProvider((IBaseLabelProvider)nodeAndEdgeRepresentationContentAndLabelProvider);
        this.m_representationTreeViewer.setUseHashlookup(true);
        this.m_representationTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_programmingElementCollectionStates = new PropertyTableViewer((Composite)nodeAndEdgeRepresentationSashForm, (BeanPropertyReader.BeanAdapter)this.m_programmingElementCollectionStatesBeanAdapter, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_programmingElementCollectionStates.addColumn("Id", "id", null, null, 5, PropertyTableViewer.ColumnType.TEXT);
        this.m_programmingElementCollectionStates.addColumn("State", "state", null, null, 45, PropertyTableViewer.ColumnType.TEXT);
        SashForm mainAndAdditionalNodesSashForm = new SashForm((Composite)nodeAndEdgeRepresentationSashForm, 256);
        this.m_mainNodesViewer = new PropertyTableViewer((Composite)mainAndAdditionalNodesSashForm, (BeanPropertyReader.BeanAdapter)new NamedElementBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_mainNodesViewer.addColumn("Main node", "fullName", null, "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_additionalNodesViewer = new PropertyTableViewer((Composite)mainAndAdditionalNodesSashForm, (BeanPropertyReader.BeanAdapter)new NamedElementBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_additionalNodesViewer.addColumn("AdditionalNode", "fullName", null, "image", 100, PropertyTableViewer.ColumnType.TEXT);
        mainAndAdditionalNodesSashForm.setWeights(new int[]{50, 50});
        nodeAndEdgeRepresentationTabItem.setControl((Control)nodeAndEdgeRepresentationSashForm);
        nodeAndEdgeRepresentationSashForm.setWeights(new int[]{33, 34, 33});
        CTabItem structureItemRegistryTabItem = new CTabItem(tabFolder, 0);
        structureItemRegistryTabItem.setText("Structure Item Regristry");
        structureItemRegistryTabItem.setImage(UiResourceManager.getInstance().getImage("ProgrammingLanguages"));
        this.m_structureItemRegistryViewer = new TreeViewer((Composite)tabFolder, 770);
        StructureItemRegistryNodeContentAndLabelProvider structureItemRegistryContentAndLabelProvider = new StructureItemRegistryNodeContentAndLabelProvider();
        this.m_structureItemRegistryViewer.setContentProvider((IContentProvider)structureItemRegistryContentAndLabelProvider);
        this.m_structureItemRegistryViewer.setLabelProvider((IBaseLabelProvider)structureItemRegistryContentAndLabelProvider);
        this.m_structureItemRegistryViewer.setUseHashlookup(true);
        this.m_structureItemRegistryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        structureItemRegistryTabItem.setControl(this.m_structureItemRegistryViewer.getControl());
        tabFolder.setSelection(0);
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileCreatedEvent>(ModifiableFileCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileCreatedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathCreatedEvent>(ModifiableDirectoryPathCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathCreatedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathModifiedEvent>(ModifiableDirectoryPathModifiedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathModifiedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathDeletedEvent>(ModifiableDirectoryPathDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathDeletedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultStateChangedEvent>(AnalyzerResultStateChangedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultStateChangedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<NotificationAddedEvent>(NotificationAddedEvent.class, (Object)this){

            public void handleEvent(NotificationAddedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<NotificationsRemovedEvent>(NotificationsRemovedEvent.class, (Object)this){

            public void handleEvent(NotificationsRemovedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<RepresentationModifiedEvent>(RepresentationModifiedEvent.class, (Object)this){

            public void handleEvent(RepresentationModifiedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<RepresentationRemovedEvent>(RepresentationRemovedEvent.class, (Object)this){

            public void handleEvent(RepresentationRemovedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<InstallationModifiedEvent>(InstallationModifiedEvent.class, (Object)this){

            public void handleEvent(InstallationModifiedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewLoadedEvent>(ArchitecturalViewLoadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewLoadedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewModifiedEvent>(ArchitecturalViewModifiedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewModifiedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewSplitEvent>(ArchitecturalViewSplitEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewSplitEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitecturalViewUnloadedEvent>(ArchitecturalViewUnloadedEvent.class, (Object)this){

            public void handleEvent(ArchitecturalViewUnloadedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitectureDiagramCreatedEvent>(ArchitectureDiagramCreatedEvent.class, (Object)this){

            public void handleEvent(ArchitectureDiagramCreatedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitectureDiagramDeletedEvent>(ArchitectureDiagramDeletedEvent.class, (Object)this){

            public void handleEvent(ArchitectureDiagramDeletedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitectureDiagramModifiedEvent>(ArchitectureDiagramModifiedEvent.class, (Object)this){

            public void handleEvent(ArchitectureDiagramModifiedEvent event) {
                if (DebugView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    DebugView.this.show();
                }
            }
        });
        assert (this.m_eventBroker != null) : "'m_eventBroker' of method 'createViewContent' must not be null";
        this.m_eventBrokerHandler = new org.osgi.service.event.EventHandler(){

            public void handleEvent(Event event) {
                DebugView.this.show();
            }
        };
        this.m_eventBroker.subscribe("org/eclipse/e4/ui/renderer/requestEnablementUpdate", this.m_eventBrokerHandler);
        this.show();
        this.showSelection(this.getSelectionProviderAdapter().getSelectionService().getSelection());
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultStateChangedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(NotificationAddedEvent.class, (Object)this);
        EventManager.getInstance().detach(NotificationsRemovedEvent.class, (Object)this);
        EventManager.getInstance().detach(RepresentationModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(RepresentationRemovedEvent.class, (Object)this);
        EventManager.getInstance().detach(InstallationModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewLoadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewSplitEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitecturalViewUnloadedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitectureDiagramCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitectureDiagramDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitectureDiagramModifiedEvent.class, (Object)this);
        this.m_eventBroker.unsubscribe(this.m_eventBrokerHandler);
        for (FocusableToolTip next : this.m_focusableToolTips) {
            next.closeTooltip();
        }
        this.m_focusableToolTips.clear();
        super.destroyViewContent();
    }

    private void showDebugInfo(Element element) {
        boolean resolve = this.m_currentlyDisplayed != element;
        this.m_currentlyDisplayed = element;
        if (element != null) {
            if (element.isValid()) {
                PhysicalInfo physicalInfo;
                ILanguageProvider languageProvider;
                NamedElement namedElement;
                Language language;
                ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                String descriptor = provider.getElementResolver().getDescriptor(element);
                StringBuilder builder = new StringBuilder();
                builder.append("Descriptor: ");
                builder.append(descriptor != null ? descriptor : "n/a");
                if (element instanceof NamedElement && (language = (namedElement = (NamedElement)element).getLanguage()) != null && (languageProvider = provider.getLanguageProvider(language)) != null && (physicalInfo = languageProvider.getPhysicalInfo(namedElement)) != null) {
                    builder.append("\n");
                    builder.append("Physical root directory: ").append(physicalInfo.getRootDirectoryPath().getName());
                    builder.append("\n");
                    builder.append("Physical relative path: ").append(physicalInfo.getRelativePath());
                    builder.append("\n");
                    builder.append("Physical short name: ").append(physicalInfo.getShortName());
                }
                builder.append("\n");
                builder.append(element.getDebugInfo());
                this.m_debugInfo.setText(builder.toString());
                if (descriptor != null && resolve) {
                    Element resolved = provider.getElementResolver().resolve(descriptor);
                    if (element.equals(resolved)) {
                        LOGGER.debug("Successfully resolved: " + descriptor);
                    } else {
                        LOGGER.debug("Unable to resolve descriptor: " + descriptor);
                    }
                }
            } else {
                this.m_currentlyDisplayed = null;
                this.m_debugInfo.setText("Element not valid: " + element.getName());
            }
        } else {
            this.m_debugInfo.setText("");
        }
    }

    protected void installationModified() {
        this.show();
        super.installationModified();
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.show();
        super.softwareSystemShow(mode);
    }

    protected void performViewSelected(IWorkbenchView view) {
        this.show();
        super.performViewSelected(view);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        this.show();
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        this.show();
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.show();
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }

    public void refreshNodeAndEdgeRepresentationInfo() {
        ITreeSelection selection = this.m_representationTreeViewer.getStructuredSelection();
        if (!selection.isEmpty()) {
            Object firstSelectedObject = selection.getFirstElement();
            if (firstSelectedObject instanceof NodeAndEdgeRepresentation) {
                ProgrammingElementDeltaManager manager = ((NodeAndEdgeRepresentation)firstSelectedObject).getProgrammingElementDeltaManager();
                if (manager != null) {
                    this.m_programmingElementCollectionStatesBeanAdapter.setManager(manager);
                    this.m_programmingElementCollectionStates.showData((Collection)manager.getDeltasAsEntrySet());
                } else {
                    this.m_programmingElementCollectionStatesBeanAdapter.setManager(null);
                    this.m_programmingElementCollectionStates.showData(null);
                }
                this.m_mainNodesViewer.showData((Collection)((NodeAndEdgeRepresentation)firstSelectedObject).getMainNodes());
                this.m_additionalNodesViewer.showData((Collection)((NodeAndEdgeRepresentation)firstSelectedObject).getAdditionalNodes());
            } else {
                this.m_programmingElementCollectionStates.showData(null);
                this.m_programmingElementCollectionStatesBeanAdapter.setManager(null);
                this.m_mainNodesViewer.showData(null);
                this.m_additionalNodesViewer.showData(null);
            }
        } else {
            this.m_programmingElementCollectionStates.showData(null);
            this.m_programmingElementCollectionStatesBeanAdapter.setManager(null);
            this.m_mainNodesViewer.showData(null);
            this.m_additionalNodesViewer.showData(null);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        if (event.getSource() == this.m_representationTreeViewer) {
            this.refreshNodeAndEdgeRepresentationInfo();
        } else {
            Element firstSelectedElement = null;
            Object firstSelectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (firstSelectedObject instanceof Element) {
                firstSelectedElement = (Element)firstSelectedObject;
            }
            this.showDebugInfo(firstSelectedElement);
        }
    }

    private void showSelection(Object object) {
        this.m_selectionServiceSelection.setAdditionalFirstColumnInfo(null);
        if (object == null) {
            this.m_selectionServiceSelection.showData(Collections.emptyList());
            this.m_selectionServiceSelection.setAdditionalFirstColumnInfo("No View");
        } else if (object instanceof List) {
            List list = (List)object;
            ArrayList<Element> elements = new ArrayList<Element>(list.size());
            for (Object next : list) {
                if (next instanceof Element) {
                    elements.add((Element)next);
                    continue;
                }
                LOGGER.warn("Unexpected object in selection: " + next.getClass().getName());
            }
            this.m_selectionServiceSelection.showData(elements);
            this.m_selectionServiceSelection.setAdditionalFirstColumnInfo("No View");
        } else if (object instanceof Element) {
            this.m_selectionServiceSelection.showData(Collections.singletonList((Element)object));
            this.m_selectionServiceSelection.setAdditionalFirstColumnInfo("No View");
        } else if (object instanceof WorkbenchViewSelection) {
            this.m_selectionServiceSelection.setAdditionalFirstColumnInfo(((WorkbenchViewSelection)object).getWorkbenchView().getViewId().getPresentationName() + " View");
            this.m_selectionServiceSelection.showData((Collection)((WorkbenchViewSelection)object).getElements());
        } else {
            LOGGER.warn("Unexpected object in selection: " + object.getClass().getName());
            this.m_selectionServiceSelection.showData(Collections.emptyList());
            this.m_selectionServiceSelection.setAdditionalFirstColumnInfo("No View");
        }
    }

    @Inject
    public void setSelection(@Named(value="org.eclipse.ui.selection") @Optional Object object) {
        if (this.isActive()) {
            this.showSelection(object);
        }
    }

    protected void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        if (elements.size() == 1) {
            this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection());
            this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.showDebugInfo(elements.get(0));
        } else {
            this.showDebugInfo((Element)this.getSoftwareSystem());
        }
        if (view != null) {
            this.m_receivedSelection.setAdditionalFirstColumnInfo(view.getViewId().getPresentationName() + " View");
        } else {
            this.m_receivedSelection.setAdditionalFirstColumnInfo("<no view>");
        }
        this.m_receivedSelection.showData(elements);
    }

    protected void performViewClosed(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'performViewClosed' must not be null";
        this.show();
        super.performViewClosed(view);
    }
}

