/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.commandhandler;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;

public final class SearchHandler
extends CommandHandler {
    private static final String DOTS = "...";

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> selection) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                return workbenchView.supportsSearch() != Search.NONE && workbenchView.showSearchInContextMenu(selection);
            }

            public String getLabel(IWorkbenchView workbenchView, List<Element> selection, String defaultLabel) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'getLabel' must not be null");
                }
                Search search = workbenchView.supportsSearch();
                if (!$assertionsDisabled && search == Search.NONE) {
                    throw new AssertionError((Object)"Search not enabled");
                }
                return search.getLabel() + SearchHandler.DOTS;
            }

            public IMenuGroup getMenuGroup() {
                return IContextMenuContributor.SpecialMenuGroup.FIRST;
            }
        };
    }

    @CanExecute
    public boolean canExecute(MPart part, @Optional MMenuItem menuItem, @Optional MToolItem toolItem) {
        IWorkbenchView workbenchView;
        assert (part != null) : "Parameter 'part' of method 'canExecute' must not be null";
        if (menuItem != null) {
            menuItem.setLabel(Search.NONE.getLabel() + DOTS);
        }
        if (toolItem != null) {
            toolItem.setLabel(Search.NONE.getLabel() + DOTS);
        }
        if ((workbenchView = RcpUtility.getWorkbenchView((MPart)part, IWorkbenchView.class)) != null && workbenchView.isActive() && workbenchView.isReady()) {
            boolean enable;
            Search search = workbenchView.supportsSearch();
            boolean bl = enable = search != Search.NONE;
            if (enable) {
                String info = search.getLabel() + " In " + workbenchView.getPresentationName() + DOTS;
                if (menuItem != null) {
                    menuItem.setLabel(info);
                }
                if (toolItem != null) {
                    toolItem.setTooltip(info);
                }
            }
            return enable;
        }
        return false;
    }

    @Execute
    public void execute(MPart part) {
        assert (part != null) : "Parameter 'part' of method 'execute' must not be null";
        IWorkbenchView workbenchView = RcpUtility.getWorkbenchView((MPart)part, IWorkbenchView.class);
        if (workbenchView != null && workbenchView.isActive() && workbenchView.isReady()) {
            Search search = workbenchView.supportsSearch();
            assert (search != null) : "Parameter 'search' of method 'execute' must not be null";
            assert (!search.equals((Object)Search.NONE)) : "Search not possible";
            workbenchView.searchRequested(search);
        }
    }
}

