/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.script.BufferedOutputStream;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FileScriptOutputStream;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.MultiTargetScriptOutputStream;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandaloneOutputStreamProvider
extends ScriptOutputStreamProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneOutputStreamProvider.class);
    private static final String AUTOMATED = "[Automated] ";
    private static final String EXECUTION_SEPARATOR = "============================================================================================";
    private static StandaloneOutputStreamProvider s_instance;
    private final Map<String, BufferedOutputStream> m_idToConsoleOutputStream = new TreeMap<String, BufferedOutputStream>();
    private final Map<String, FileScriptOutputStream> m_idToFileOutputStream = new HashMap<String, FileScriptOutputStream>();
    private final List<IOutputStreamLifecycleListener> m_streamLifecycleListeners = new ArrayList<IOutputStreamLifecycleListener>();

    private StandaloneOutputStreamProvider() {
    }

    public static StandaloneOutputStreamProvider getInstance() {
        if (s_instance == null) {
            s_instance = new StandaloneOutputStreamProvider();
        }
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            s_instance = null;
        }
    }

    public void addLifecycleListener(IOutputStreamLifecycleListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'add' must not be null";
        assert (!this.m_streamLifecycleListeners.contains(listener)) : "Already added: " + String.valueOf(listener);
        this.m_streamLifecycleListeners.add(listener);
    }

    public void removeLifecycleListener(IOutputStreamLifecycleListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'remove' must not be null";
        assert (this.m_streamLifecycleListeners != null) : "'m_listeners' of method 'remove' must not be null";
        assert (this.m_streamLifecycleListeners.contains(listener)) : "Not found: " + String.valueOf(listener);
        this.m_streamLifecycleListeners.remove(listener);
    }

    public BufferedOutputStream getBufferedOutputStream(String id) {
        return this.m_idToConsoleOutputStream.get(id);
    }

    public List<BufferedOutputStream> getBufferedOutputStreams() {
        return new ArrayList<BufferedOutputStream>(this.m_idToConsoleOutputStream.values());
    }

    public OperationResultWithOutcome<OutputStream> beforeScriptExecution(String identifyingPath, String runConfigName, final boolean isAutomated, String outputPath) {
        boolean created;
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getOutputStream' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create output stream for script '" + identifyingPath + "'");
        String idToUse = this.createId(identifyingPath, runConfigName, isAutomated);
        ArrayList<Object> outputs = new ArrayList<Object>();
        if (outputPath != null) {
            try {
                FileScriptOutputStream fileOutput = this.createFileOutputStream(outputPath, isAutomated);
                outputs.add(fileOutput);
                this.m_idToFileOutputStream.put(idToUse, fileOutput);
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, "Cannot send output to file '" + outputPath + "'\n" + ExceptionUtility.collectFirstAndLast((Throwable)e), new Object[0]);
            }
        } else {
            this.m_idToFileOutputStream.remove(idToUse);
        }
        BufferedOutputStream requested = this.m_idToConsoleOutputStream.get(idToUse);
        boolean bl = created = requested == null;
        if (requested == null) {
            requested = new BufferedOutputStream(idToUse, isAutomated);
            this.m_idToConsoleOutputStream.put(idToUse, requested);
        }
        final BufferedOutputStream consoleOutputStream = requested;
        outputs.add(consoleOutputStream);
        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

            @Override
            public void run() {
                RcpUtility.createView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.CONSOLE_VIEW);
                if (created) {
                    StandaloneOutputStreamProvider.this.m_streamLifecycleListeners.forEach(l -> l.added(StandaloneOutputStreamProvider.this.getBufferedOutputStreams(), consoleOutputStream, isAutomated));
                }
                if (!isAutomated) {
                    RcpUtility.activateView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.CONSOLE_VIEW);
                }
            }
        });
        if (outputs.size() > 1) {
            result.setOutcome((Object)new MultiTargetScriptOutputStream(outputs));
        } else {
            result.setOutcome((Object)((OutputStream)outputs.get(0)));
        }
        return result;
    }

    private String createId(String identifyingPath, String runConfigName, boolean isAutomated) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'createId' must not be empty";
        assert (runConfigName != null && runConfigName.length() > 0) : "Parameter 'runConfigName' of method 'createId' must not be empty";
        String compositeId = FileUtility.removeExtension((String)identifyingPath) + ", " + runConfigName;
        return isAutomated ? AUTOMATED + compositeId : compositeId;
    }

    private Pair<String, String> getScriptPathAndRunConfigName(String runConfigIdentifyingPath) {
        assert (runConfigIdentifyingPath != null && runConfigIdentifyingPath.length() > 0) : "Parameter 'runConfigIdentifyingPath' of method 'getScriptPathAndRunConfigName' must not be empty";
        int endIndex = runConfigIdentifyingPath.length() - FileUtility.getExtension((String)runConfigIdentifyingPath).length();
        String scriptNameAndConfigName = runConfigIdentifyingPath.substring(0, endIndex);
        int separatorIndex = scriptNameAndConfigName.indexOf("#");
        String scriptPath = scriptNameAndConfigName.substring(0, separatorIndex);
        String runConfigName = scriptNameAndConfigName.substring(separatorIndex + 1);
        return new Pair((Object)scriptPath, (Object)runConfigName);
    }

    public void afterScriptExecution(String identifyingPath, String runConfigName, boolean isAutomated) throws IOException {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'afterScriptExecution' must not be empty";
        String idToUse = this.createId(identifyingPath, runConfigName, isAutomated);
        BufferedOutputStream consoleOutput = this.m_idToConsoleOutputStream.get(idToUse);
        assert (consoleOutput != null) : "No consoleOutput for '" + idToUse + "' present";
        if (this.m_idToFileOutputStream.containsKey(idToUse)) {
            FileScriptOutputStream fileOutput = this.m_idToFileOutputStream.get(idToUse);
            consoleOutput.write(("Script output also written to file: " + fileOutput.getFilePath() + StringUtility.LINE_SEPARATOR).getBytes(StandardCharsets.UTF_8));
            this.m_idToFileOutputStream.remove(idToUse);
        }
        consoleOutput.write((EXECUTION_SEPARATOR + StringUtility.LINE_SEPARATOR).getBytes(StandardCharsets.UTF_8));
    }

    private void releaseOutputStream(List<String> ids) {
        assert (ids != null) : "Parameter 'ids' of method 'releaseOutputStream' must not be null";
        final ArrayList<BufferedOutputStream> removedBufferedOutputStreams = new ArrayList<BufferedOutputStream>(ids.size());
        for (String nextId : ids) {
            String automatedId;
            BufferedOutputStream bufferedAutomated;
            BufferedOutputStream buffered = this.m_idToConsoleOutputStream.remove(nextId);
            if (buffered != null) {
                removedBufferedOutputStreams.add(buffered);
            }
            if ((bufferedAutomated = this.m_idToConsoleOutputStream.remove(automatedId = AUTOMATED + nextId)) == null) continue;
            removedBufferedOutputStreams.add(bufferedAutomated);
        }
        removedBufferedOutputStreams.forEach(b -> this.closeOutputStream((BufferedOutputStream)b));
        if (!removedBufferedOutputStreams.isEmpty()) {
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    StandaloneOutputStreamProvider.this.m_streamLifecycleListeners.forEach(l -> l.removed(StandaloneOutputStreamProvider.this.getBufferedOutputStreams(), removedBufferedOutputStreams.toArray(new BufferedOutputStream[0])));
                }
            });
        }
    }

    public void releaseOutputStreams(List<GroovyScript> deletedScripts, List<FileBasedRunConfiguration> deletedRunConfigs) {
        assert (deletedScripts != null) : "Parameter 'deletedScripts' of method 'releaseOutputStreams' must not be null";
        assert (deletedRunConfigs != null) : "Parameter 'deletedRunConfigs' of method 'releaseOutputStreams' must not be null";
        final ArrayList<BufferedOutputStream> removedBufferedOutputStreams = new ArrayList<BufferedOutputStream>();
        for (GroovyScript groovyScript : deletedScripts) {
            String deletedAutomatedId;
            BufferedOutputStream automated;
            String deletedManualId = this.createId(groovyScript.getIdentifyingPath(), "[Default]", false);
            BufferedOutputStream manual = this.m_idToConsoleOutputStream.remove(deletedManualId);
            if (manual != null) {
                removedBufferedOutputStreams.add(manual);
            }
            if ((automated = this.m_idToConsoleOutputStream.remove(deletedAutomatedId = this.createId(groovyScript.getIdentifyingPath(), "[Default]", true))) == null) continue;
            removedBufferedOutputStreams.add(automated);
        }
        for (FileBasedRunConfiguration fileBasedRunConfiguration : deletedRunConfigs) {
            String deletedAutomatedId;
            BufferedOutputStream automated;
            Pair<String, String> scriptPath = this.getScriptPathAndRunConfigName(fileBasedRunConfiguration.getIdentifyingPath());
            String deletedManualId = this.createId((String)scriptPath.getFirst(), (String)scriptPath.getSecond(), false);
            BufferedOutputStream manual = this.m_idToConsoleOutputStream.remove(deletedManualId);
            if (manual != null) {
                removedBufferedOutputStreams.add(manual);
            }
            if ((automated = this.m_idToConsoleOutputStream.remove(deletedAutomatedId = this.createId((String)scriptPath.getFirst(), (String)scriptPath.getSecond(), true))) == null) continue;
            removedBufferedOutputStreams.add(automated);
        }
        removedBufferedOutputStreams.forEach(out -> this.closeOutputStream((BufferedOutputStream)out));
        if (!removedBufferedOutputStreams.isEmpty()) {
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    StandaloneOutputStreamProvider.this.m_streamLifecycleListeners.forEach(l -> l.removed(StandaloneOutputStreamProvider.this.getBufferedOutputStreams(), removedBufferedOutputStreams.toArray(new BufferedOutputStream[0])));
                }
            });
        }
    }

    public void releaseAllOutputStreams() {
        ArrayList<BufferedOutputStream> removed = new ArrayList<BufferedOutputStream>(this.m_idToConsoleOutputStream.values());
        for (Map.Entry<String, BufferedOutputStream> nextEntry : this.m_idToConsoleOutputStream.entrySet()) {
            BufferedOutputStream nextConsoleOutputStream = nextEntry.getValue();
            this.closeOutputStream(nextConsoleOutputStream);
        }
        this.m_idToConsoleOutputStream.clear();
        final BufferedOutputStream[] removedAsArray = removed.toArray(new BufferedOutputStream[removed.size()]);
        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

            @Override
            public void run() {
                StandaloneOutputStreamProvider.this.m_streamLifecycleListeners.forEach(l -> l.removed(Collections.emptyList(), removedAsArray));
            }
        });
    }

    private void closeOutputStream(BufferedOutputStream outputStream) {
        assert (outputStream != null) : "Parameter 'outputStream' of method 'closeOutputStream' must not be null";
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("Exception caught closing the console output stream: " + outputStream.getId(), (Throwable)e);
        }
    }

    public void automatedScriptsUpdate(List<ScriptRunnerData> scriptRunnerData) {
        assert (scriptRunnerData != null) : "Parameter 'scriptRunnerData' of method 'updateAutomatedScripts' must not be null";
        HashSet<String> consoleIds = new HashSet<String>();
        for (ScriptRunnerData data : scriptRunnerData) {
            consoleIds.add(this.createId(data.getIdentifyingScriptPath(), data.getRunConfigurationName(), true));
        }
        List<String> toBeReleased = this.m_idToConsoleOutputStream.keySet().stream().filter(id -> id.startsWith(AUTOMATED) && !consoleIds.contains(id)).collect(Collectors.toList());
        this.releaseOutputStream(toBeReleased);
    }

    public void clearAllOutputStreams() {
        for (BufferedOutputStream next : this.m_idToConsoleOutputStream.values()) {
            next.reset();
        }
    }

    private void updateStream(Map<BufferedOutputStream, BufferedOutputStream> previousToNewBufferMap, String previousId, String newId, boolean isAutomated) {
        BufferedOutputStream previous = this.m_idToConsoleOutputStream.get(previousId);
        if (previous != null) {
            BufferedOutputStream newBuffer = new BufferedOutputStream(newId, isAutomated);
            previous.copyContentTo(newBuffer);
            this.m_idToConsoleOutputStream.put(newId, newBuffer);
            this.m_idToConsoleOutputStream.remove(previous.getId());
            previousToNewBufferMap.put(previous, newBuffer);
        }
    }

    public void renameOutputStreams(Map<GroovyScript, String> movedScripts, Map<FileBasedRunConfiguration, String> movedRunConfigs) {
        assert (movedScripts != null) : "Parameter 'movedScripts' of method 'renameOutputStreams' must not be null";
        assert (movedRunConfigs != null) : "Parameter 'movedRunConfigs' of method 'renameOutputStreams' must not be null";
        HashMap previousToNewBufferMap = new HashMap();
        movedScripts.entrySet().stream().forEach(scriptEntry -> this.handleScriptRename(previousToNewBufferMap, (GroovyScript)scriptEntry.getKey(), (String)scriptEntry.getValue()));
        movedRunConfigs.entrySet().stream().forEach(runConfigEntry -> this.handleRunConfigRename(previousToNewBufferMap, (FileBasedRunConfiguration)runConfigEntry.getKey(), (String)runConfigEntry.getValue()));
        for (BufferedOutputStream previous : previousToNewBufferMap.keySet()) {
            this.closeOutputStream(previous);
        }
        this.m_streamLifecycleListeners.forEach(l -> l.pathModified(previousToNewBufferMap, new ArrayList<BufferedOutputStream>(this.m_idToConsoleOutputStream.values())));
    }

    private void handleScriptRename(Map<BufferedOutputStream, BufferedOutputStream> previousToNewBufferMap, GroovyScript movedScript, String previousScriptPath) {
        assert (previousToNewBufferMap != null) : "Parameter 'previousToNewBufferMap' of method 'handleScriptRename' must not be null";
        assert (movedScript != null) : "Parameter 'movedScript' of method 'handleScriptRename' must not be null";
        assert (previousScriptPath != null && previousScriptPath.length() > 0) : "Parameter 'previousScriptPath' of method 'handleScriptRename' must not be empty";
        String movedScriptPath = movedScript.getIdentifyingPath();
        boolean isAutomated = false;
        String previousManualId = this.createId(previousScriptPath, "[Default]", isAutomated);
        String newManualId = this.createId(movedScriptPath, "[Default]", isAutomated);
        this.updateStream(previousToNewBufferMap, previousManualId, newManualId, isAutomated);
        isAutomated = true;
        String previousAutomatedId = this.createId(previousScriptPath, "[Default]", isAutomated);
        String newAutomatedId = this.createId(movedScriptPath, "[Default]", isAutomated);
        this.updateStream(previousToNewBufferMap, previousAutomatedId, newAutomatedId, isAutomated);
    }

    private void handleRunConfigRename(Map<BufferedOutputStream, BufferedOutputStream> previousToNewBufferMap, FileBasedRunConfiguration movedRunConfig, String previousRunConfigPath) {
        assert (previousToNewBufferMap != null) : "Parameter 'previousToNewBufferMap' of method 'handleRunConfigRename' must not be null";
        assert (movedRunConfig != null) : "Parameter 'movedRunConfig' of method 'handleRunConfigRename' must not be null";
        assert (previousRunConfigPath != null && previousRunConfigPath.length() > 0) : "Parameter 'previousRunConfigPath' of method 'handleRunConfigRename' must not be empty";
        Pair<String, String> scriptPathAndRunConfigName = this.getScriptPathAndRunConfigName(previousRunConfigPath);
        String previousScriptPath = (String)scriptPathAndRunConfigName.getFirst();
        String previousRunConfigName = (String)scriptPathAndRunConfigName.getSecond();
        Pair<String, String> movedScriptPathAndRunConfigName = this.getScriptPathAndRunConfigName(movedRunConfig.getIdentifyingPath());
        String movedScriptPath = (String)movedScriptPathAndRunConfigName.getFirst();
        String movedRunConfigName = (String)movedScriptPathAndRunConfigName.getSecond();
        boolean isAutomated = false;
        String previousManualId = this.createId(previousScriptPath, previousRunConfigName, isAutomated);
        String newManualId = this.createId(movedScriptPath, movedRunConfigName, isAutomated);
        this.updateStream(previousToNewBufferMap, previousManualId, newManualId, isAutomated);
        isAutomated = true;
        String previousAutomatedId = this.createId(previousScriptPath, previousRunConfigName, isAutomated);
        String newAutomatedId = this.createId(movedScriptPath, movedRunConfigName, isAutomated);
        this.updateStream(previousToNewBufferMap, previousAutomatedId, newAutomatedId, isAutomated);
    }

    public static interface IOutputStreamLifecycleListener {
        public void added(List<BufferedOutputStream> var1, BufferedOutputStream var2, boolean var3);

        public void removed(List<BufferedOutputStream> var1, BufferedOutputStream ... var2);

        public void pathModified(Map<BufferedOutputStream, BufferedOutputStream> var1, List<BufferedOutputStream> var2);
    }
}

