/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.view;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public abstract class PresentationModeBasedViewContentAndLabelProvider
implements ITreeContentProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private PresentationMode m_presentationMode;

    public static final NamedElement getParent(NamedElement child, PresentationMode presentationMode) {
        assert (child != null) : "Parameter 'child' of method 'getParent' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getParent' must not be null";
        if (child.getElement() instanceof Root) {
            return null;
        }
        if (presentationMode == PresentationMode.FLAT && child instanceof IRecursiveElement) {
            NamedElement parent = child.getParent();
            while (parent instanceof IRecursiveElement) {
                parent = parent.getParent();
            }
            return parent;
        }
        if (presentationMode == PresentationMode.MIXED && child instanceof IRecursiveElement) {
            NamedElement parent = child.getParent();
            while (parent instanceof IRecursiveElement) {
                IRecursiveElement parentElement = (IRecursiveElement)parent;
                if (!parentElement.isMixable()) break;
                parent = parent.getParent();
            }
            return parent;
        }
        NamedElement parent = child;
        while ((parent = parent.getParent()) != null && parent.isGhost()) {
        }
        return parent;
    }

    private static void processForMixedMode(IRecursiveElement element, List<NamedElement> result) {
        assert (element != null) : "Parameter 'element' of method 'processForMixedMode' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processForMixedMode' must not be null";
        if (element.isMixable()) {
            List children = element.getNamedElement().getChildren();
            assert (children.size() == 1) : "Only 1 children expected but was: " + children.size();
            PresentationModeBasedViewContentAndLabelProvider.processForMixedMode((IRecursiveElement)children.get(0), result);
        } else {
            result.add(element.getNamedElement());
        }
    }

    private static void processRecursiveElement(IRecursiveElement element, List<NamedElement> result) {
        assert (element != null) : "Parameter 'element' of method 'processRecursiveElement' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processRecursiveElement' must not be null";
        if (!element.isPart()) {
            result.add(element.getNamedElement());
        }
        List children = element.getNamedElement().getChildren(IRecursiveElement.class);
        for (IRecursiveElement nextChild : children) {
            PresentationModeBasedViewContentAndLabelProvider.processRecursiveElement(nextChild, result);
        }
    }

    public static final List<NamedElement> getChildren(NamedElement parent, PresentationMode presentationMode) {
        assert (parent != null) : "Parameter 'parent' of method 'getChildren' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getChildren' must not be null";
        List allChildren = parent.getAllChildren();
        ArrayList<NamedElement> result = new ArrayList<NamedElement>(allChildren.size());
        for (NamedElement nextChild : allChildren) {
            if (presentationMode == PresentationMode.FLAT && nextChild instanceof IRecursiveElement) {
                PresentationModeBasedViewContentAndLabelProvider.processRecursiveElement((IRecursiveElement)nextChild, result);
                continue;
            }
            if (presentationMode == PresentationMode.MIXED && nextChild instanceof IRecursiveElement) {
                PresentationModeBasedViewContentAndLabelProvider.processForMixedMode((IRecursiveElement)nextChild, result);
                continue;
            }
            if (!nextChild.isGhost()) {
                result.add(nextChild);
                continue;
            }
            result.addAll(PresentationModeBasedViewContentAndLabelProvider.getChildren(nextChild, presentationMode));
        }
        return result;
    }

    public final void setPresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setFlatPresentation' must not be null";
        this.m_presentationMode = presentationMode;
    }

    protected final PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    public final Image getImage(Object obj) {
        assert (obj != null && obj instanceof NamedElement) : "Unexpected class in method 'getImage': " + String.valueOf(obj);
        return UiResourceManager.getInstance().getImage((Element)((NamedElement)obj).getElement());
    }

    private static String getPresentationNameForMixedMode(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getPresentationNameForMixedMode' must not be null";
        if (namedElement instanceof IRecursiveElement) {
            String separator;
            String textToCut;
            NamedElement parent = PresentationModeBasedViewContentAndLabelProvider.getParent(namedElement, PresentationMode.MIXED);
            assert (parent != null) : "Parameter 'parent' of method 'getTextForNode' must not be null";
            String textForNode = namedElement.getPresentationName(false);
            if (parent instanceof IRecursiveElement && !(textToCut = parent.getPresentationName(false)).isEmpty() && textForNode.startsWith(textToCut)) {
                textForNode = textForNode.substring(textToCut.length());
            }
            if (!textForNode.startsWith("..") && textForNode.startsWith(separator = ((IRecursiveElement)namedElement).getSeparator())) {
                textForNode = textForNode.substring(separator.length());
            }
            return textForNode;
        }
        return namedElement.getPresentationName(true);
    }

    public static String getPresentationName(NamedElement element, PresentationMode presentationMode) {
        assert (element != null) : "Parameter 'element' of method 'getPresentationName' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'getPresentationName' must not be null";
        if (presentationMode == PresentationMode.FLAT && element instanceof IRecursiveElement) {
            String presentationName = element.getPresentationName(false);
            if (presentationName.startsWith("./")) {
                return presentationName.substring("./".length());
            }
            return presentationName;
        }
        if (presentationMode == PresentationMode.MIXED && element instanceof IRecursiveElement) {
            return PresentationModeBasedViewContentAndLabelProvider.getPresentationNameForMixedMode(element);
        }
        return element.getPresentationName(PresentationModeBasedViewContentAndLabelProvider.getParent(element, presentationMode) != null);
    }

    public StyledString getStyledText(Object obj) {
        assert (obj instanceof NamedElement) : "Not of class named element: " + String.valueOf(obj);
        return new StyledString(PresentationModeBasedViewContentAndLabelProvider.getPresentationName((NamedElement)obj, this.m_presentationMode));
    }

    public final Object getParent(Object child) {
        assert (child instanceof NamedElement) : "Not a named element: " + String.valueOf(child);
        return PresentationModeBasedViewContentAndLabelProvider.getParent((NamedElement)child, this.getPresentationMode());
    }

    protected abstract boolean accept(NamedElement var1);

    public final Object[] getElements(Object obj) {
        assert (obj instanceof NamedElement) : "Not a named element: " + String.valueOf(obj);
        NamedElement root = (NamedElement)obj;
        if (!root.isValid()) {
            return new Object[0];
        }
        List<Object> result = root.getAllChildren().stream().filter(c -> this.accept((NamedElement)c)).collect(Collectors.toList());
        return result.toArray(new Object[result.size()]);
    }

    private boolean hasNonParts(IRecursiveElement element) {
        assert (element != null) : "Parameter 'element' of method 'hasNonParts' must not be null";
        if (!element.isPart()) {
            return true;
        }
        List children = element.getNamedElement().getChildren(IRecursiveElement.class);
        for (IRecursiveElement nextChild : children) {
            if (!this.hasNonParts(nextChild)) continue;
            return true;
        }
        return false;
    }

    public final Object[] getChildren(Object parent) {
        assert (parent instanceof NamedElement) : "Not of class named element: " + String.valueOf(parent);
        List allChildren = ((NamedElement)parent).getAllChildren();
        ArrayList<NamedElement> result = new ArrayList<NamedElement>(allChildren.size());
        PresentationMode presentationMode = this.getPresentationMode();
        for (NamedElement nextChild : allChildren) {
            if (presentationMode == PresentationMode.FLAT && nextChild instanceof IRecursiveElement) {
                if (nextChild instanceof IRecursiveElement) {
                    if (parent instanceof IRecursiveElement) continue;
                    PresentationModeBasedViewContentAndLabelProvider.processRecursiveElement((IRecursiveElement)nextChild, result);
                    continue;
                }
                assert (false) : "Unexpected class: " + nextChild.getClass().getSimpleName();
                continue;
            }
            if (presentationMode == PresentationMode.MIXED && nextChild instanceof IRecursiveElement) {
                if (nextChild instanceof IRecursiveElement) {
                    PresentationModeBasedViewContentAndLabelProvider.processForMixedMode((IRecursiveElement)nextChild, result);
                    continue;
                }
                assert (false) : "Unexpected class in method 'getChildren': " + String.valueOf(nextChild);
                continue;
            }
            if (nextChild.isGhost()) {
                Object[] children;
                Object[] objectArray = children = this.getChildren(nextChild);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object c = objectArray[n2];
                    result.add((NamedElement)c);
                    ++n2;
                }
                continue;
            }
            if (!this.accept(nextChild)) continue;
            result.add(nextChild);
        }
        return result.toArray();
    }

    public final boolean hasChildren(Object parent) {
        assert (parent instanceof NamedElement) : "Not of class named element: " + String.valueOf(parent);
        PresentationMode presentationMode = this.getPresentationMode();
        for (NamedElement nextChild : ((NamedElement)parent).getAllChildren()) {
            if (presentationMode == PresentationMode.FLAT && nextChild instanceof IRecursiveElement) {
                if (nextChild instanceof IRecursiveElement) {
                    if (parent instanceof IRecursiveElement) continue;
                    return this.hasNonParts((IRecursiveElement)nextChild);
                }
                assert (false) : "Unexpected class: " + nextChild.getClass().getSimpleName();
                continue;
            }
            if (presentationMode == PresentationMode.MIXED && nextChild instanceof IRecursiveElement) {
                if (nextChild instanceof IRecursiveElement) {
                    ArrayList<NamedElement> children = new ArrayList<NamedElement>();
                    PresentationModeBasedViewContentAndLabelProvider.processForMixedMode((IRecursiveElement)nextChild, children);
                    return !children.isEmpty();
                }
                assert (false) : "Unexpected class in method 'hasChildren': " + String.valueOf(nextChild);
                continue;
            }
            if (!(nextChild.isGhost() ? this.getChildren(nextChild).length > 0 : this.accept(nextChild))) continue;
            return true;
        }
        return false;
    }

    public final void dispose() {
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public final void addListener(ILabelProviderListener listener) {
    }

    public final boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public final void removeListener(ILabelProviderListener listener) {
    }
}

