/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.LineInformation;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.LineNumberPaintListener;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.Marker;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.MarkerPaintListener;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SyntaxHighlightMode;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.OffsetBasedSelectedTextInfo;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SourceViewWidget
extends Composite
implements ISourceFileRegionVisitor,
SelectionListener,
KeyListener,
MouseMoveListener,
Listener,
MouseListener,
LineStyleListener {
    protected static final String SINGLE_LINE_COMMENT_PREFIX = "//";
    private static final String COMMENT_START = "/*";
    private static final String COMMENT_END = "*/";
    private static final String QUOTATION_MARK = "\"";
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceViewWidget.class);
    private static final int DEFAULT_ZOOM_LEVEL = UiResourceManager.getInstance().getDefaultSystemFontHeight();
    private static final int MIN_ZOOM_LEVEL = 5;
    private static final int SCROLL_OFFSET = 5;
    private final List m_commentsOffsets = new ArrayList();
    private final Map<Integer, List<Marker>> m_lineToMarkers = new THashMap();
    private final Map<Integer, List<StyleRange>> m_styleRanges = new THashMap();
    private final GC m_graphicsContext;
    private final StyledText m_source;
    private final boolean m_isReadOnly;
    private Canvas m_annotations;
    private Canvas m_lineNumbers;
    private DefaultToolTip m_defaultToolTip;
    private SoftwareSystem m_softwareSystem;
    private FilePath m_sourceFile;
    private boolean m_sourceAvailable;
    private boolean m_listenToSourceCodeScrollbars = true;
    private SyntaxHighlightMode m_syntaxHighlightMode = SyntaxHighlightMode.REGULAR;
    private StyleRange m_hyperlinkStyleRange = null;
    private int m_zoomLevel = DEFAULT_ZOOM_LEVEL;
    private LineNumberPaintListener m_paintListener;

    public SourceViewWidget(Composite parent, boolean isReadOnly) {
        super(parent, 0);
        this.m_isReadOnly = isReadOnly;
        this.m_graphicsContext = new GC((Drawable)this.getDisplay());
        this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)3));
        this.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_source = new StyledText((Composite)this, this.m_isReadOnly ? 66312 : 66304);
        this.m_source.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_source.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_source.setTabs(4);
        this.m_source.setDoubleClickEnabled(false);
        this.m_source.setFont(UiResourceManager.getInstance().getDefaultSourceFont(DEFAULT_ZOOM_LEVEL));
        this.m_source.addMouseListener((MouseListener)this);
        this.m_source.addLineStyleListener((LineStyleListener)this);
    }

    public void lineGetStyle(LineStyleEvent event) {
        FilePath filePath = this.getSourceFile();
        if (filePath == null) {
            return;
        }
        StyledText source = this.getSourceWidget();
        boolean isModificationUpdate = this.m_syntaxHighlightMode == SyntaxHighlightMode.ON_MODIFY;
        int lastCommentsOffsetsSize = this.m_commentsOffsets.size();
        int lineNumber = source.getLineAtOffset(event.lineOffset);
        List<StyleRange> styleRanges = this.m_styleRanges.get(lineNumber);
        if (this.m_syntaxHighlightMode == SyntaxHighlightMode.ON_MODIFY) {
            String lines = source.getText();
            this.recalculateMultilineCommentOffsets(source, lines);
            this.clearStyleRanges();
            this.calculateStyleRangesForSyntaxHighlighting(lines, filePath.getFileType());
            this.m_syntaxHighlightMode = SyntaxHighlightMode.REGULAR;
            styleRanges = this.m_styleRanges.get(lineNumber);
        } else if (this.m_syntaxHighlightMode == SyntaxHighlightMode.ON_HYPERLINKING) {
            if (this.m_hyperlinkStyleRange != null) {
                ArrayList<StyleRange> styleRangesWithHyperlink = new ArrayList<StyleRange>();
                if (styleRanges != null) {
                    styleRangesWithHyperlink.addAll(styleRanges);
                }
                styleRangesWithHyperlink.add(this.m_hyperlinkStyleRange);
                event.styles = styleRangesWithHyperlink.toArray(new StyleRange[styleRangesWithHyperlink.size()]);
            }
            this.m_syntaxHighlightMode = SyntaxHighlightMode.REGULAR;
            return;
        }
        boolean commensAffected = false;
        if (lastCommentsOffsetsSize != this.m_commentsOffsets.size()) {
            commensAffected = true;
        }
        if (isModificationUpdate && !commensAffected) {
            for (Object object : this.m_commentsOffsets) {
                int[] commentOffsets = (int[])object;
                int startLine = source.getLineAtOffset(commentOffsets[0]);
                int endLine = source.getLineAtOffset(commentOffsets[1]);
                if (lineNumber < startLine || lineNumber > endLine) continue;
                commensAffected = true;
                break;
            }
        }
        if (styleRanges != null) {
            event.styles = styleRanges.toArray(new StyleRange[styleRanges.size()]);
        }
        if (commensAffected && source.getCharCount() > 0) {
            source.redrawRange(0, source.getCharCount() - 1, false);
        }
    }

    public final void setHyperLinkStyleRange(StyleRange hyperLinkRange) {
        this.m_hyperlinkStyleRange = hyperLinkRange;
    }

    protected void recalculateMultilineCommentOffsets(StyledText styledText, String text) {
        assert (styledText != null) : "Parameter 'styledText' of method 'refreshMultilineComments' must not be null";
        this.m_commentsOffsets.clear();
        int pos = text.indexOf(COMMENT_START);
        while (pos > -1) {
            int lineNumber = styledText.getLineAtOffset(pos);
            String line = styledText.getLine(lineNumber);
            int commentStartPosInLine = line.indexOf(COMMENT_START);
            int singleLineCommentPos = line.indexOf(SINGLE_LINE_COMMENT_PREFIX);
            if (singleLineCommentPos >= 0 && singleLineCommentPos < commentStartPosInLine) {
                pos += COMMENT_START.length() - 1;
            } else {
                int endQuotationMark;
                int startQuotationMark = line.indexOf(QUOTATION_MARK);
                if (startQuotationMark >= 0 && startQuotationMark < commentStartPosInLine && commentStartPosInLine < (endQuotationMark = line.indexOf(QUOTATION_MARK, startQuotationMark + 1))) {
                    pos += COMMENT_START.length() - 1;
                } else {
                    int[] commentOffsets = new int[2];
                    commentOffsets[0] = pos;
                    boolean foundEndComment = false;
                    int endPos = text.indexOf(COMMENT_END, pos);
                    while (endPos > -1) {
                        lineNumber = styledText.getLineAtOffset(endPos);
                        line = styledText.getLine(lineNumber);
                        int commentEndPosInLine = line.indexOf(COMMENT_END);
                        singleLineCommentPos = line.indexOf(SINGLE_LINE_COMMENT_PREFIX);
                        if (singleLineCommentPos >= 0 && singleLineCommentPos < commentEndPosInLine) {
                            endPos += COMMENT_END.length() - 1;
                        } else {
                            int endQuotationMark2;
                            startQuotationMark = line.indexOf(QUOTATION_MARK);
                            if (startQuotationMark >= 0 && startQuotationMark < commentEndPosInLine && commentEndPosInLine < (endQuotationMark2 = line.indexOf(QUOTATION_MARK, startQuotationMark + 1))) {
                                endPos += COMMENT_END.length() - 1;
                            } else {
                                pos = endPos;
                                foundEndComment = true;
                                break;
                            }
                        }
                        endPos = text.indexOf(COMMENT_END, endPos);
                    }
                    if (!foundEndComment) {
                        pos = -1;
                    }
                    commentOffsets[1] = pos == -1 ? text.length() - 1 : pos + COMMENT_END.length() - 1;
                    pos = pos == -1 ? text.length() - 1 : pos + COMMENT_END.length() - 1;
                    this.m_commentsOffsets.add(commentOffsets);
                }
            }
            pos = text.indexOf(COMMENT_START, pos);
        }
    }

    public final boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public final StyledText getSourceWidget() {
        return this.m_source;
    }

    private void createWidgets(int numberOfLines) {
        assert (this.m_annotations == null) : "Parameter 'm_annotations' of method 'createWidgets' must be null";
        assert (this.m_lineNumbers == null) : "Parameter 'm_lineNumbers' of method 'createWidgets' must be null";
        assert (this.m_defaultToolTip == null) : "Parameter 'm_defaultToolTip' of method 'createWidgets' must be null";
        this.m_annotations = new Canvas((Composite)this, 0);
        this.m_annotations.setLayoutData((Object)this.getGridDataForAnnotations());
        this.m_annotations.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_lineNumbers = new Canvas((Composite)this, 0);
        GridData gridDataLineNumbers = this.getGridDataForLineNumbers(numberOfLines);
        this.m_lineNumbers.setLayoutData((Object)gridDataLineNumbers);
        this.m_lineNumbers.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_lineNumbers.setForeground(UiResourceManager.getInstance().getDimmedForegroundColor());
        this.m_lineNumbers.moveAbove((Control)this.m_source);
        this.m_annotations.moveAbove((Control)this.m_lineNumbers);
        this.m_defaultToolTip = new DefaultToolTip((Control)this.m_annotations, 2, false);
        this.m_source.addListener(11, (Listener)this);
        this.m_annotations.addPaintListener((PaintListener)new MarkerPaintListener(this.m_source, this.m_lineToMarkers));
        this.m_paintListener = new LineNumberPaintListener(this.m_source, gridDataLineNumbers.widthHint);
        this.m_lineNumbers.addPaintListener((PaintListener)this.m_paintListener);
        this.layout();
    }

    public void dispose() {
        this.m_graphicsContext.dispose();
        super.dispose();
    }

    protected final void updateAnnotations() {
        if (this.m_annotations != null && !this.m_annotations.isDisposed()) {
            this.m_annotations.setRedraw(false);
            this.m_annotations.redraw();
            this.m_annotations.setRedraw(true);
        }
    }

    protected final void updateLineNumbers() {
        if (this.m_lineNumbers != null && !this.m_lineNumbers.isDisposed()) {
            this.m_lineNumbers.setRedraw(false);
            this.m_lineNumbers.redraw();
            this.m_lineNumbers.setRedraw(true);
        }
    }

    public final void handleEvent(Event event) {
        this.updateAnnotations();
        this.updateLineNumbers();
    }

    public final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    public final FilePath getSourceFile() {
        return this.m_sourceFile;
    }

    public final void clearMarkers() {
        this.m_lineToMarkers.clear();
        this.updateAnnotations();
    }

    public void clear() {
        this.m_source.getVerticalBar().removeSelectionListener((SelectionListener)this);
        this.m_lineToMarkers.clear();
        this.m_softwareSystem = null;
        this.m_sourceFile = null;
        this.m_sourceAvailable = false;
        this.m_source.removeMouseMoveListener((MouseMoveListener)this);
        this.m_source.removeKeyListener((KeyListener)this);
        this.m_source.removeListener(11, (Listener)this);
        this.setRedraw(false);
        this.m_source.setText("");
        if (this.m_annotations != null) {
            assert (this.m_lineNumbers != null) : "'m_lineNumbers' of method 'clear' must not be null";
            this.m_annotations.removeMouseMoveListener((MouseMoveListener)this);
            this.m_annotations.dispose();
            this.m_annotations = null;
            this.m_lineNumbers.dispose();
            this.m_lineNumbers = null;
            this.m_defaultToolTip = null;
        }
        this.setRedraw(true);
    }

    public final boolean isSourceAvailable() {
        return this.m_sourceAvailable;
    }

    protected abstract void calculateStyleRangesForSyntaxHighlighting(String var1, IFileType var2);

    protected final void setSyntaxHighlightMode(SyntaxHighlightMode syntaxHighlightMode) {
        assert (syntaxHighlightMode != null) : "Parameter 'syntaxHighlightMode' of method 'setSyntaxHighlightMode' must not be null";
        this.m_syntaxHighlightMode = syntaxHighlightMode;
    }

    protected void sourceFileShown(FilePath sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'aboutToShowFile' must not be null";
    }

    public final void showSource(FilePath sourceFile, int lineNumber, boolean select, boolean forceRefresh, String content) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'showSourceForElement' must not be null";
        assert (sourceFile.isValid()) : "'sourceFile' not valid: " + String.valueOf(sourceFile);
        if (this.m_sourceFile != sourceFile || forceRefresh) {
            int currentCaretPosition = this.getSourceWidget().getCaretOffset();
            int topIndex = this.m_source.getTopIndex();
            this.clear();
            this.m_softwareSystem = (SoftwareSystem)sourceFile.getParent(SoftwareSystem.class, new Class[0]);
            assert (this.m_softwareSystem != null) : "'m_currentlyShownSoftwareSystem' of method 'showSourceForElement' must not be null";
            boolean widgetsCreated = false;
            if (content != null) {
                this.m_sourceAvailable = true;
            } else if (sourceFile.exists()) {
                try {
                    content = FileUtility.getFileContent((TFile)sourceFile.getFile());
                    this.m_sourceAvailable = true;
                }
                catch (IOException e) {
                    this.createWidgets(0);
                    widgetsCreated = true;
                    this.setRedraw(false);
                    content = "Unable to read file: " + ExceptionUtility.collectAll((Throwable)e);
                    this.m_sourceAvailable = false;
                }
            } else {
                this.createWidgets(0);
                widgetsCreated = true;
                this.setRedraw(false);
                content = "Source file not found: " + sourceFile.getIdentifyingPath();
                this.m_sourceAvailable = false;
            }
            assert (content != null) : "Content must not be null";
            if (!widgetsCreated) {
                int numLines = StringUtility.countLines((String)content);
                this.createWidgets(numLines);
                this.setRedraw(false);
            }
            this.m_source.setText((String)content);
            if (topIndex < this.m_source.getLineCount()) {
                this.m_source.setTopIndex(topIndex);
            } else {
                this.m_source.setTopIndex(this.m_source.getLineCount() - 1);
            }
            this.sourceFileShown(sourceFile);
            this.recalculateMultilineCommentOffsets(this.m_source, this.m_source.getText());
            this.clearStyleRanges();
            this.calculateStyleRangesForSyntaxHighlighting((String)content, sourceFile.getFileType());
            if (this.m_source.getText().length() >= currentCaretPosition) {
                this.setCaretOffset(currentCaretPosition);
            } else {
                this.setCaretOffset(this.m_source.getText().length());
            }
            if (forceRefresh) {
                int charCount = this.m_source.getCharCount();
                this.m_source.redrawRange(0, charCount > 0 ? charCount - 1 : 0, false);
            }
            this.m_source.addMouseMoveListener((MouseMoveListener)this);
            this.m_annotations.addMouseMoveListener((MouseMoveListener)this);
            this.m_source.addKeyListener((KeyListener)this);
            this.m_source.getVerticalBar().addSelectionListener((SelectionListener)this);
        }
        this.m_sourceFile = sourceFile;
        if (this.isSourceAvailable()) {
            if (forceRefresh) {
                lineNumber = this.getFirstVisibleLineNumber();
            }
            this.gotoLine(lineNumber, select);
        }
        this.zoomTo(this.m_zoomLevel);
        this.setRedraw(true);
        this.m_source.redraw();
    }

    public final List<Control> getControls() {
        return Arrays.asList(this.m_lineNumbers, this.m_annotations, this.m_source);
    }

    public final Control getMainControl() {
        return this.m_source;
    }

    private void setStyleRanges(int startOffset, int extent, Color color, boolean bold) {
        assert (color != null) : "Parameter 'color' of method 'setForegroundColor' must not be null";
        StyleRange styleRange = new StyleRange();
        styleRange.start = startOffset;
        styleRange.length = extent;
        styleRange.foreground = color;
        if (bold) {
            styleRange.fontStyle = 1;
        }
        StyledText styledText = this.getSourceWidget();
        int startLineNumber = styledText.getLineAtOffset(startOffset);
        int endLineNumber = styledText.getLineAtOffset(startOffset + extent);
        int i = startLineNumber;
        while (i <= endLineNumber) {
            List<StyleRange> ranges = this.m_styleRanges.get(i);
            if (ranges == null) {
                ranges = new ArrayList<StyleRange>();
                this.m_styleRanges.put(i, ranges);
            }
            ranges.add(styleRange);
            ++i;
        }
    }

    protected final void clearStyleRanges() {
        this.m_styleRanges.clear();
    }

    public final void addMarker(int lineNumber, String provider, String name, String description, String imageResourceName) {
        assert (lineNumber >= -1) : "Unexpected value for parameter 'lineNumber' in method 'addMarker' " + lineNumber;
        assert (provider != null && provider.length() > 0) : "Parameter 'provider' of method 'addMarker' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addMarker' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addMarker' must not be null";
        assert (imageResourceName != null) : "Parameter 'imageResourceName' of method 'addMarker' must not be null";
        int markerLineNumber = lineNumber;
        if (lineNumber == -1) {
            markerLineNumber = 1;
        } else if (lineNumber > this.m_source.getLineCount()) {
            markerLineNumber = this.m_source.getLineCount();
        }
        Marker marker = new Marker(name, description, provider, imageResourceName);
        Integer lineAsInteger = markerLineNumber;
        List<Marker> markers = this.m_lineToMarkers.get(lineAsInteger);
        if (markers == null) {
            markers = new ArrayList<Marker>();
            this.m_lineToMarkers.put(lineAsInteger, markers);
        }
        markers.add(marker);
    }

    public final void keyPressed(KeyEvent event) {
        assert (event != null) : "Parameter 'event' of method 'keyPressed' must not be null";
        if (event.keyCode == 13 || event.keyCode == 127 || event.keyCode == 8) {
            if (!this.m_isReadOnly) {
                this.updateAnnotations();
                this.updateLineNumbers();
            }
        } else if (!(event.keyCode != 65 && event.keyCode != 97 || (event.stateMask & SWT.MOD1) != SWT.MOD1 || this.m_source == null || this.m_source.isDisposed())) {
            this.m_source.selectAll();
        }
    }

    public final void keyReleased(KeyEvent event) {
    }

    public final void visitComment(int start, int extent) {
        this.setStyleRanges(start, extent, UiResourceManager.getInstance().getCommentColor(), false);
    }

    public final void visitKeyword(int start, int extent) {
        this.setStyleRanges(start, extent, UiResourceManager.getInstance().getKeywordColor(), true);
    }

    public final void visitLiteral(int start, int extent) {
        this.setStyleRanges(start, extent, UiResourceManager.getInstance().getLiteralColor(), false);
    }

    public final void visitHash(int pos) {
        this.setStyleRanges(pos, 1, UiResourceManager.getInstance().getHashColor(), true);
    }

    public final void visitAt(int pos) {
        this.setStyleRanges(pos, 1, UiResourceManager.getInstance().getAtColor(), false);
    }

    public final void visitAnnotation(int start, int extent, boolean inComment) {
        if (inComment) {
            this.setStyleRanges(start, extent, UiResourceManager.getInstance().getAnnotationInCommentColor(), false);
        } else {
            this.setStyleRanges(start, extent, UiResourceManager.getInstance().getAnnotationInCommentColor(), false);
        }
    }

    public final void resetRegion(int start, int extent) {
        this.setStyleRanges(start, extent, UiResourceManager.getInstance().getForegroundColor(), false);
    }

    public final void widgetSelected(SelectionEvent event) {
        if (this.m_listenToSourceCodeScrollbars) {
            this.updateAnnotations();
            this.updateLineNumbers();
        }
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseMove' must not be null";
        if (event.getSource() == this.m_annotations) {
            List<Marker> markers = null;
            if (this.isSourceAvailable()) {
                int lineIndex = this.m_source.getLineIndex(event.y);
                markers = this.m_lineToMarkers.get(lineIndex + 1);
            } else {
                int lineIndex;
                int lineHeight = this.m_source.getLineHeight();
                if (lineHeight != 0 && (lineIndex = (event.y - this.m_source.getTopMargin()) / lineHeight) == 0) {
                    markers = this.m_lineToMarkers.get(1);
                }
            }
            if (markers != null) {
                StringBuilder tooltipBuilder = new StringBuilder();
                int i = 1;
                for (Marker nextMarker : markers) {
                    StringBuilder nextMarkerTooltipBuilder = new StringBuilder();
                    nextMarkerTooltipBuilder.append("[").append(i).append("] ").append(nextMarker.getName());
                    String description = nextMarker.getDescription();
                    if (!description.isEmpty()) {
                        nextMarkerTooltipBuilder.append(" - ");
                        nextMarkerTooltipBuilder.append(description);
                    }
                    nextMarkerTooltipBuilder.append(" [");
                    nextMarkerTooltipBuilder.append(nextMarker.getIssueProvider());
                    nextMarkerTooltipBuilder.append("]");
                    String nextWrappedMarkerTooltip = StringUtility.wrap((String)nextMarkerTooltipBuilder.toString(), (int)150, (String)" .,/(");
                    tooltipBuilder.append(nextWrappedMarkerTooltip);
                    tooltipBuilder.append(StringUtility.LINE_SEPARATOR);
                    ++i;
                }
                this.m_defaultToolTip.activate();
                this.m_defaultToolTip.setFont(this.getSourceWidget().getFont());
                this.m_defaultToolTip.setText(tooltipBuilder.substring(0, tooltipBuilder.length() - StringUtility.LINE_SEPARATOR.length()));
                this.m_defaultToolTip.show(new Point(event.x, event.y));
                return;
            }
            this.m_defaultToolTip.hide();
            this.m_defaultToolTip.deactivate();
        }
    }

    public void mouseUp(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseDown' must not be null";
    }

    public final void mouseDown(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseDown' must not be null";
    }

    public final void mouseDoubleClick(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'mouseDoubleClick' must not be null";
        if (event.getSource() == this.m_source) {
            try {
                int offset = this.m_source.getOffsetAtPoint(new Point(event.x, event.y));
                int lineNumber = this.m_source.getLineAtOffset(offset);
                int startOffsetOfLine = this.m_source.getOffsetAtLine(lineNumber);
                int relOffsetInLine = offset - startOffsetOfLine;
                String content = this.m_source.getLine(lineNumber);
                char clickedChar = content.charAt(relOffsetInLine);
                if (Character.isJavaIdentifierPart(clickedChar)) {
                    int fromOffset = -1;
                    int toOffset = -1;
                    int startOffset = relOffsetInLine;
                    while (startOffset >= 0) {
                        char nextChar = content.charAt(startOffset);
                        if (!Character.isJavaIdentifierPart(nextChar)) {
                            fromOffset = startOffset + 1;
                            break;
                        }
                        --startOffset;
                    }
                    if (fromOffset == -1) {
                        fromOffset = 0;
                    }
                    int endOffset = relOffsetInLine;
                    while (endOffset < content.length()) {
                        char nextChar = content.charAt(endOffset);
                        if (!Character.isJavaIdentifierPart(nextChar)) {
                            toOffset = endOffset;
                            break;
                        }
                        ++endOffset;
                    }
                    if (toOffset == -1) {
                        toOffset = content.length();
                    }
                    this.m_source.setSelection(startOffsetOfLine + fromOffset, startOffsetOfLine + toOffset);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final int getFirstVisibleLineNumber() {
        return this.isSourceAvailable() ? this.m_source.getLineIndex(0) + 1 : 1;
    }

    public final OffsetBasedSelectedTextInfo getSelectedTextInfo() {
        String selectedText;
        if (this.isSourceAvailable() && (selectedText = this.m_source.getSelectionText()) != null) {
            Point selectionRange = this.m_source.getSelectionRange();
            if (selectionRange.y != 0) {
                try {
                    char check;
                    int offsetOfSelection = selectionRange.x;
                    int lineNumber = this.m_source.getLineAtOffset(offsetOfSelection);
                    String content = this.m_source.getLine(lineNumber);
                    int offsetOfLine = this.m_source.getOffsetAtLine(lineNumber);
                    int relOffset = offsetOfSelection - offsetOfLine;
                    boolean leftIsWhitespaceOrNonIdentifierPart = false;
                    leftIsWhitespaceOrNonIdentifierPart = relOffset == 0 ? true : StringUtility.isWhitespace((char)(check = content.charAt(relOffset - 1))) || !Character.isJavaIdentifierPart(check);
                    boolean rightIsWhitespaceOrNonIdentifierPart = false;
                    if (leftIsWhitespaceOrNonIdentifierPart) {
                        char check2;
                        rightIsWhitespaceOrNonIdentifierPart = relOffset + selectedText.length() >= content.length() ? true : StringUtility.isWhitespace((char)(check2 = content.charAt(relOffset + selectedText.length()))) || !Character.isJavaIdentifierPart(check2);
                    }
                    boolean containsWhiteSpaceOrNonIdentifier = false;
                    if (leftIsWhitespaceOrNonIdentifierPart && rightIsWhitespaceOrNonIdentifierPart) {
                        int i = 0;
                        while (i < selectedText.length()) {
                            char nextChar = selectedText.charAt(i);
                            if (StringUtility.isWhitespace((char)nextChar) || !Character.isJavaIdentifierPart(nextChar)) {
                                containsWhiteSpaceOrNonIdentifier = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    return new OffsetBasedSelectedTextInfo(selectedText, offsetOfSelection, leftIsWhitespaceOrNonIdentifierPart && rightIsWhitespaceOrNonIdentifierPart && !containsWhiteSpaceOrNonIdentifier, lineNumber);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return OffsetBasedSelectedTextInfo.NO_SELECTION;
    }

    public final Point getOffsetsForSelection() {
        return this.isSourceAvailable() ? this.m_source.getSelection() : new Point(0, 0);
    }

    public final void gotoLine(int lineNumber, boolean select) {
        if (this.isSourceAvailable()) {
            if (lineNumber == 0) {
                LOGGER.warn("Invalid line number: " + lineNumber);
                lineNumber = -1;
            }
            if (lineNumber == -1) {
                this.m_source.setTopIndex(0);
                this.m_source.setCaretOffset(0);
                return;
            }
            int lineNumberInWidget = lineNumber - 1;
            if (lineNumberInWidget >= this.m_source.getLineCount()) {
                LOGGER.warn("Requested line number is greater than available lines");
                lineNumberInWidget = this.m_source.getLineCount() - 1;
            } else if (lineNumberInWidget < 0) {
                LOGGER.warn("Requested line number is smaller than available lines");
                lineNumberInWidget = 0;
            }
            int scrollTarget = lineNumberInWidget > 5 ? lineNumberInWidget - 5 : 0;
            this.m_source.setTopIndex(scrollTarget);
            if (select) {
                try {
                    int offset = this.m_source.getOffsetAtLine(lineNumberInWidget);
                    int nextLine = lineNumberInWidget + 1;
                    int nextOffset = 0;
                    nextOffset = nextLine >= this.m_source.getLineCount() ? offset + this.m_source.getLine(lineNumberInWidget).length() : this.m_source.getOffsetAtLine(nextLine);
                    this.m_source.setSelectionRange(nextOffset, offset - nextOffset);
                }
                catch (Throwable t) {
                    LOGGER.warn("Unable to select - unable to determine offset for line: " + lineNumberInWidget);
                }
            }
            this.m_lineNumbers.redraw();
            this.m_annotations.redraw();
        }
    }

    public final ScrollBar getVerticalScrollBar() {
        return this.m_source.getVerticalBar();
    }

    public final ScrollBar getHorizontalScrollBar() {
        return this.m_source.getHorizontalBar();
    }

    public final Point getSourceWidgetPosition() {
        return new Point(this.m_source.getHorizontalBar().getSelection(), this.m_source.getVerticalBar().getSelection());
    }

    public final Point adaptSourceWidgetLocation(Point delta) {
        int currentLocationX = this.m_source.getHorizontalBar().getSelection();
        int currentLocationY = this.m_source.getVerticalBar().getSelection();
        assert (delta != null) : "Parameter 'delta' of method 'adaptSourceWidgetLocation' must not be null";
        Point newLocationTopLeft = new Point(currentLocationX + delta.x, currentLocationY + delta.y);
        this.m_listenToSourceCodeScrollbars = false;
        this.m_source.setHorizontalPixel(this.m_source.getHorizontalPixel() + delta.x);
        this.m_source.setTopPixel(this.m_source.getTopPixel() + delta.y);
        this.updateAnnotations();
        this.updateLineNumbers();
        this.m_listenToSourceCodeScrollbars = true;
        return new Point(newLocationTopLeft.x, newLocationTopLeft.y);
    }

    public final String getText() {
        return this.m_source.getText();
    }

    public final int getLineCount() {
        return this.m_source.getLineCount();
    }

    public final int getOffsetAtLine(int lineIndex) {
        try {
            return this.m_source.getOffsetAtLine(lineIndex);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private int getValidPositionInText(int offset) {
        assert (offset >= 0) : "Parameter 'offset' of method 'getValidPositionInText' must not be negative";
        try {
            int line = this.m_source.getLineAtOffset(offset);
            int lineOffset = this.m_source.getOffsetAtLine(line);
            int offsetInLine = offset - lineOffset;
            if (offsetInLine > this.m_source.getLine(line).length()) {
                return offset + 1;
            }
        }
        catch (IllegalArgumentException ex) {
            int endOfText = this.m_source.getText().length();
            LOGGER.error("Error getting valid position at:{}, returning endOfText {}", (Object)offset, (Object)endOfText);
            return endOfText;
        }
        return offset;
    }

    public final void setCaretOffset(int offset) {
        int correctedOffset = this.getValidPositionInText(offset);
        this.m_source.setCaretOffset(correctedOffset);
    }

    public final void setSelection(int start, int end) {
        int correctedStart = this.getValidPositionInText(start);
        int correctedEnd = this.getValidPositionInText(end);
        this.m_source.setSelection(correctedStart, correctedEnd);
        this.updateAnnotations();
        this.updateLineNumbers();
    }

    public final LineInformation getLineAtOffset(int offset) {
        try {
            int lineNumber = this.m_source.getLineAtOffset(offset);
            String content = this.m_source.getLine(lineNumber);
            int startOffset = this.m_source.getOffsetAtLine(lineNumber);
            return new LineInformation(content, startOffset, lineNumber);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void zoomTo(int zoomLevel) {
        Font zoomInFont = UiResourceManager.getInstance().getDefaultSourceFont(zoomLevel);
        this.setRedraw(false);
        this.getSourceWidget().setFont(zoomInFont);
        this.m_graphicsContext.setFont(zoomInFont);
        GridData gridDataLineNumbers = this.getGridDataForLineNumbers(this.getSourceWidget().getLineCount());
        this.m_lineNumbers.setLayoutData((Object)gridDataLineNumbers);
        this.m_paintListener.setWidthHint(gridDataLineNumbers.widthHint);
        this.m_annotations.setLayoutData((Object)this.getGridDataForAnnotations());
        this.updateLineNumbers();
        this.updateAnnotations();
        this.setRedraw(true);
    }

    public void zoomIn() {
        this.zoomTo(++this.m_zoomLevel);
    }

    public void zoomOut() {
        if (this.m_zoomLevel > 5) {
            this.zoomTo(--this.m_zoomLevel);
        }
    }

    public int getZoomLevel() {
        return this.m_zoomLevel;
    }

    private GridData getGridDataForAnnotations() {
        GridData gridDataForAnnotations = new GridData(0, 4, false, true);
        gridDataForAnnotations.widthHint = this.getSourceWidget().getLineHeight();
        return gridDataForAnnotations;
    }

    private GridData getGridDataForLineNumbers(int lines) {
        assert (lines >= 0) : "Parameter 'lines' of method 'getGridData' must be >= 0";
        String widest = StringUtility.concat((String)"0", (int)Integer.toString(lines).length());
        int lineNumberWidthHint = this.m_graphicsContext.stringExtent((String)widest).x + 6;
        GridData gridDataLineNumbers = new GridData(0, 4, false, true);
        gridDataLineNumbers.widthHint = lineNumberWidthHint;
        return gridDataLineNumbers;
    }
}

