/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewContentOption;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SourceViewContextOptionsViewer
implements ISelectionChangedListener {
    private final Shell m_shell;
    private final TableViewer m_contextOptionsTableViewer;
    private SourceViewContentOption m_chosenOption;

    public SourceViewContextOptionsViewer(Shell parent) {
        this.m_shell = new Shell(parent, 4);
        this.m_shell.setLayout((Layout)new FillLayout());
        this.m_contextOptionsTableViewer = new TableViewer((Composite)this.m_shell);
        this.m_shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                SourceViewContextOptionsViewer.this.m_shell.setVisible(false);
            }
        });
        this.m_contextOptionsTableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                SourceViewContextOptionsViewer.this.m_shell.setVisible(false);
            }
        });
        this.m_contextOptionsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    public SourceViewContentOption open(Point location, List<SourceViewContentOption> contextOptions) {
        assert (location != null) : "Parameter 'location' of method 'open' must not be null";
        assert (contextOptions != null && !contextOptions.isEmpty()) : "Parameter 'contextOptions' of method 'open' must not be empty";
        this.m_contextOptionsTableViewer.getTable().pack();
        this.m_shell.setBounds(location.x, location.y, 120, 32);
        this.m_shell.open();
        this.m_contextOptionsTableViewer.getTable().setFocus();
        this.m_contextOptionsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_contextOptionsTableViewer.setInput(contextOptions);
        Display display = this.m_shell.getDisplay();
        while (!this.m_shell.isDisposed() && this.m_shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.m_shell.isDisposed()) {
            this.m_chosenOption = null;
        }
        this.m_shell.dispose();
        return this.m_chosenOption;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selected = selection.getFirstElement();
        this.m_chosenOption = (SourceViewContentOption)selected;
    }
}

