/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.preferencepage;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.command.system.plugin.ConfigurePluginCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphFloatPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.ISonargraphPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.JavaFloatValidator;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.JavaIntegerValidator;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.JavaStringValidator;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class PluginPreferencePage
extends PreferencePage
implements ISonargraphPreferencePage,
ValidatingTextOrComboWidget.IConsumer,
SelectionListener {
    private final Set<ValidatingTextOrComboWidget> m_invalidTextWidgets = new THashSet();
    private final Collection<ValidatingTextOrComboWidget> m_validatingTextWidgets = new ArrayList<ValidatingTextOrComboWidget>();
    private final Collection<Button> m_buttons = new ArrayList<Button>();
    private final Collection<Combo> m_combos = new ArrayList<Combo>();
    private final SonargraphPlugin m_plugin;
    private final Map<SonargraphPluginAttribute, Object> m_initialValues;
    private final Map<SonargraphPluginAttribute, Object> m_defaultValues;
    private final String m_isReadOnly;
    private Map<SonargraphPluginAttribute, Object> m_values;
    private Button m_restoreDefaults;

    private static String isReadOnly(SonargraphPlugin plugin, SoftwareSystem softwareSystem) {
        assert (plugin != null) : "Parameter 'plugin' of method 'isReadOnly' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isReadOnly' must not be null";
        if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.CONFIGURE_PLUGIN, (SoftwareSystem)softwareSystem)) {
            return " - Read Only (not licensed)";
        }
        Set supportedLanguages = plugin.getSupportedLanguages();
        if (supportedLanguages != null) {
            if (!softwareSystem.getUsedLanguageStandardNames().stream().anyMatch(supportedLanguages::contains)) {
                return " - Read Only (language not supported)";
            }
        }
        return null;
    }

    PluginPreferencePage(SonargraphPlugin plugin) {
        assert (plugin != null) : "Parameter 'plugin' of method 'PluginPreferencePage' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "No system available";
        this.m_plugin = plugin;
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem();
        assert (softwareSystem != null) : "No system available";
        this.m_isReadOnly = PluginPreferencePage.isReadOnly(plugin, softwareSystem);
        this.m_initialValues = plugin.getConfiguration().getValues();
        this.m_defaultValues = plugin.getConfiguration().getDefaultValues();
        this.m_values = new THashMap(this.m_initialValues);
        if (this.m_isReadOnly != null) {
            this.setTitle(this.m_plugin.getPresentationName() + this.m_isReadOnly);
        } else {
            this.setTitle(this.m_plugin.getPresentationName());
        }
        this.noDefaultAndApplyButton();
    }

    public String getPluginId() {
        return this.m_plugin.getId();
    }

    public String getId() {
        return this.m_plugin.getId();
    }

    private Composite getOrCreateSection(Composite parent, Composite currentSection) {
        assert (parent != null) : "Parameter 'parent' of method 'getOrCreateSection' must not be null";
        if (currentSection != null) {
            return currentSection;
        }
        Composite section = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 4;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        section.setLayout((Layout)gridLayout);
        section.setLayoutData((Object)new GridData(4, 1, true, false));
        return section;
    }

    private ITextValidator getValidator(SonargraphPluginAttribute attribute) {
        assert (attribute != null) : "Parameter 'attribute' of method 'getValidator' must not be null";
        if (attribute instanceof SonargraphStringPluginAttribute) {
            return JavaStringValidator.INSTANCE;
        }
        if (attribute instanceof SonargraphIntPluginAttribute) {
            return JavaIntegerValidator.INSTANCE;
        }
        if (attribute instanceof SonargraphFloatPluginAttribute) {
            return JavaFloatValidator.INSTANCE;
        }
        assert (false) : "Unexpected class: " + attribute.getClass().getName();
        return null;
    }

    protected Control createContents(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createContents' must not be null";
        Composite body = new Composite(parent, 0);
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        body.setLayout((Layout)gridLayout);
        String currentGroup = "Header";
        Composite currentSection = this.getOrCreateSection(body, null);
        Label languagesLabel = new Label(currentSection, 0);
        languagesLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        languagesLabel.setText("Languages:");
        Text languages = new Text(currentSection, 64);
        languages.setLayoutData((Object)new GridData(4, 4, true, false));
        languages.setText(this.m_plugin.getAvailableForLanguages());
        Label descriptionLabel = new Label(currentSection, 0);
        descriptionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        descriptionLabel.setText("Description:");
        Text description = new Text(currentSection, 64);
        description.setLayoutData((Object)new GridData(4, 4, true, false));
        description.setText(this.m_plugin.getDescription());
        for (SonargraphPluginAttribute sonargraphPluginAttribute : this.m_plugin.getConfiguration().getAttributes().values()) {
            Label name;
            String nextGroup = sonargraphPluginAttribute.getGroup();
            if (nextGroup == null && currentGroup != null || nextGroup != null && currentGroup == null || !nextGroup.equals(currentGroup)) {
                currentSection = null;
            }
            currentGroup = nextGroup;
            currentSection = this.getOrCreateSection(body, currentSection);
            if (sonargraphPluginAttribute instanceof SonargraphBooleanPluginAttribute) {
                name = new Label(currentSection, 0);
                name.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                name.setText(sonargraphPluginAttribute.getPresentatioName() + ":");
                name.setToolTipText(sonargraphPluginAttribute.getDescription());
                Button toggle = new Button(currentSection, 32);
                toggle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                toggle.setData((Object)sonargraphPluginAttribute);
                this.m_buttons.add(toggle);
                toggle.setSelection(((SonargraphBooleanPluginAttribute)sonargraphPluginAttribute).getValue().booleanValue());
                if (this.m_isReadOnly != null) continue;
                toggle.addSelectionListener((SelectionListener)this);
                continue;
            }
            name = new Label(currentSection, 0);
            name.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            name.setText(sonargraphPluginAttribute.getPresentatioName() + ":");
            name.setToolTipText(sonargraphPluginAttribute.getDescription());
            if (sonargraphPluginAttribute.getOptionLabelToValue().isEmpty()) {
                ValidatingTextWidget textWidget = new ValidatingTextWidget(currentSection, this.getValidator(sonargraphPluginAttribute), (ValidatingTextOrComboWidget.IConsumer)this, sonargraphPluginAttribute.getValue().toString(), 0);
                textWidget.setData((Object)sonargraphPluginAttribute);
                this.m_validatingTextWidgets.add((ValidatingTextOrComboWidget)textWidget);
                textWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                continue;
            }
            Combo combo = new Combo(currentSection, 8);
            combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            combo.setData((Object)sonargraphPluginAttribute);
            this.m_combos.add(combo);
            int select = 0;
            int index = 0;
            for (Map.Entry nextEntry : sonargraphPluginAttribute.getOptionLabelToValue().entrySet()) {
                combo.add((String)nextEntry.getKey());
                if (sonargraphPluginAttribute.getValue().equals(nextEntry.getValue())) {
                    select = index;
                }
                ++index;
            }
            combo.select(select);
            if (this.m_isReadOnly != null) continue;
            combo.addSelectionListener((SelectionListener)this);
        }
        if (this.m_isReadOnly != null) {
            for (ValidatingTextOrComboWidget validatingTextOrComboWidget : this.m_validatingTextWidgets) {
                validatingTextOrComboWidget.setEnabled(false);
            }
            for (Combo combo : this.m_combos) {
                combo.setEnabled(false);
            }
            for (Button button : this.m_buttons) {
                button.setEnabled(false);
            }
        }
        return body;
    }

    protected void contributeButtons(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'contributeButtons' must not be null";
        this.m_restoreDefaults = new Button(parent, 8);
        this.m_restoreDefaults.setText("Restore Defaults");
        ++((GridLayout)parent.getLayout()).numColumns;
        if (this.m_isReadOnly == null) {
            this.m_restoreDefaults.setEnabled(this.hasChangedFromDefaults());
            this.m_restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PluginPreferencePage.this.setDefaults();
                    PluginPreferencePage.this.m_restoreDefaults.setEnabled(false);
                }
            });
        } else {
            this.m_restoreDefaults.setEnabled(false);
        }
    }

    public boolean performOk() {
        if (this.m_isReadOnly == null && this.hasChanged() && this.hasValidData()) {
            ConfigurePluginCommand command = new ConfigurePluginCommand(WorkbenchRegistry.getInstance().getProvider(), new ConfigurePluginCommand.IConfigurePluginInteraction(){

                public boolean collect(ConfigurePluginCommand.ConfigurePluginData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setData(PluginPreferencePage.this.m_plugin, PluginPreferencePage.this.m_values);
                    return true;
                }

                public void processResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
        return true;
    }

    private boolean hasChanged() {
        return !this.m_values.equals(this.m_initialValues);
    }

    private boolean hasChangedFromDefaults() {
        return !this.m_values.equals(this.m_defaultValues);
    }

    private void setDefaults() {
        UserInterfaceAdapter.Feedback feedback = UserInterfaceAdapter.getInstance().question("Do you want to set defaults?", true);
        if (feedback == UserInterfaceAdapter.Feedback.CONFIRMED) {
            Object defaultValue;
            SonargraphPluginAttribute nextAttribute;
            for (ValidatingTextOrComboWidget validatingTextOrComboWidget : this.m_validatingTextWidgets) {
                nextAttribute = (SonargraphPluginAttribute)validatingTextOrComboWidget.getData();
                defaultValue = nextAttribute.getDefaultValue();
                assert (defaultValue != null && defaultValue instanceof String) : "Unexpected class in method 'setDefaults': " + String.valueOf(defaultValue);
                if (validatingTextOrComboWidget.getText().equals(defaultValue)) continue;
                validatingTextOrComboWidget.setText((String)defaultValue);
            }
            for (Button button : this.m_buttons) {
                nextAttribute = (SonargraphPluginAttribute)button.getData();
                defaultValue = nextAttribute.getDefaultValue();
                assert (defaultValue != null && defaultValue instanceof Boolean) : "Unexpected class in method 'setDefaults': " + String.valueOf(defaultValue);
                button.setSelection(((Boolean)defaultValue).booleanValue());
            }
            for (Combo combo : this.m_combos) {
                nextAttribute = (SonargraphPluginAttribute)combo.getData();
                defaultValue = nextAttribute.getDefaultValue();
                int index = 0;
                int select = 0;
                for (Map.Entry nextEntry : nextAttribute.getOptionLabelToValue().entrySet()) {
                    if (defaultValue.equals(nextEntry.getValue())) {
                        select = index;
                    }
                    ++index;
                }
                combo.select(select);
            }
            this.m_values = new THashMap(this.m_defaultValues);
        }
    }

    private boolean hasValidData() {
        return this.m_invalidTextWidgets.isEmpty();
    }

    public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
        if (input == null) {
            this.m_invalidTextWidgets.add(source);
        } else {
            this.m_invalidTextWidgets.remove(source);
            this.m_values.put((SonargraphPluginAttribute)source.getData(), input);
            this.m_restoreDefaults.setEnabled(this.hasChangedFromDefaults());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button button = (Button)e.getSource();
            this.m_values.put((SonargraphPluginAttribute)button.getData(), button.getSelection());
        } else if (e.getSource() instanceof Combo) {
            Combo combo = (Combo)e.getSource();
            SonargraphPluginAttribute pluginAttribute = (SonargraphPluginAttribute)combo.getData();
            assert (pluginAttribute != null) : "'pluginAttribute' of method 'widgetSelected' must not be null";
            String label = combo.getText();
            Object value = pluginAttribute.getOptionValue(label);
            this.m_values.put(pluginAttribute, value);
        } else assert (false) : "Unexpected widget class selected: " + String.valueOf(e.getSource().getClass());
        this.m_restoreDefaults.setEnabled(this.hasChangedFromDefaults());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

