/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog.feedback;

import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackDialog;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class ReportParsingProblemDialog
extends FeedbackDialog {
    private static final String DONT_ATTACH_DIAGNOSTIC_FILES = "Feedback_Dont_Attach_Diagnostic_Files";
    private final List<TFile> m_diagnosticFiles;
    private ParsingReportFeedbackComposite m_feedbackComposite;

    public ReportParsingProblemDialog(Shell parentShell, TFile logFile, List<TFile> diagnosticFiles) {
        super(parentShell, logFile, "com.hello2morrow.sonargraph.standalone", (IProxySettingsProvider)new StandaloneProxySettingsProvider());
        assert (diagnosticFiles != null) : "Parameter 'diagnosticFiles' of method 'ReportParsingProblemDialog' must not be null";
        this.m_diagnosticFiles = diagnosticFiles;
    }

    protected abstract String getBundleId();

    protected abstract String getDefaultSubject();

    protected void applyData() {
        this.setSubject(this.getDefaultSubject());
        ArrayList<String> files = new ArrayList<String>();
        for (TFile next : this.m_diagnosticFiles) {
            files.add(next.getNormalizedAbsolutePath());
        }
        Collections.sort(files);
        int i = 0;
        while (i < files.size()) {
            this.m_feedbackComposite.getList().add((String)files.get(i), i);
            ++i;
        }
    }

    protected FeedbackDialog.DialogFeedbackComposite createFeedbackComposite(Composite composite) {
        this.m_feedbackComposite = new ParsingReportFeedbackComposite(composite, 0, 2, "Your feedback will be forwarded to support@hello2morrow.com. We will try to get back to you as quickly as possible.", this.getLogFile());
        return this.m_feedbackComposite;
    }

    public boolean attachAdditionalFiles() {
        return this.m_feedbackComposite.attachAdditionalFiles();
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.REPORT_PARSING_PROBLEMS;
    }

    protected IEclipsePreferences saveData() {
        this.m_feedbackComposite.storeSettings();
        IEclipsePreferences settings = this.getPreferences(this.getBundleId());
        settings.putBoolean(DONT_ATTACH_DIAGNOSTIC_FILES, !this.attachLogFile());
        return settings;
    }

    private class ParsingReportFeedbackComposite
    extends FeedbackDialog.DialogFeedbackComposite {
        private Button m_attachDiagnosticFilesCheckBox;
        private boolean m_attachDiagnosticFiles;
        private org.eclipse.swt.widgets.List m_filesList;

        public ParsingReportFeedbackComposite(Composite parent, int style, int columns, String introText, TFile logFile) {
            super((FeedbackDialog)ReportParsingProblemDialog.this, parent, style, columns, introText, logFile, (IProxySettingsProvider)new StandaloneProxySettingsProvider());
        }

        protected void addAdditionalWidgets() {
            super.addAdditionalWidgets();
            Label separator = new Label((Composite)this, 258);
            GridData layoutSeparator = new GridData(4, 1, true, false, 2, 1);
            layoutSeparator.minimumWidth = 300;
            layoutSeparator.widthHint = 300;
            separator.setLayoutData((Object)layoutSeparator);
            Label note = new Label((Composite)this, 0);
            note.setLayoutData((Object)new GridData(1, 128, false, false));
            note.setText("NOTE:");
            Label infoText = new Label((Composite)this, 64);
            infoText.setLayoutData((Object)new GridData(4, 128, true, false));
            infoText.setText("The diagnostic files contain expanded source code and additional detailed information required to solve the parsing problems.\nIf you do not want to send us these files, uncheck the checkbox below!\n\n");
            Label diagnosticFilesLabel = new Label((Composite)this, 0);
            diagnosticFilesLabel.setLayoutData((Object)new GridData(1, 128, false, false));
            diagnosticFilesLabel.setText("Diagnostic Files: ");
            this.m_filesList = new org.eclipse.swt.widgets.List((Composite)this, 2816);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.minimumHeight = 100;
            layoutData.heightHint = 200;
            layoutData.minimumWidth = 300;
            layoutData.widthHint = 300;
            this.m_filesList.setLayoutData((Object)layoutData);
            SwtUtility.createFillerForGridLayoutCell((Composite)this);
            this.m_attachDiagnosticFilesCheckBox = new Button((Composite)this, 32);
            this.m_attachDiagnosticFilesCheckBox.setText("Attach diagnostic files");
            this.m_attachDiagnosticFilesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParsingReportFeedbackComposite.this.m_attachDiagnosticFiles = ParsingReportFeedbackComposite.this.m_attachDiagnosticFilesCheckBox.getSelection();
                }
            });
            IEclipsePreferences settings = ReportParsingProblemDialog.this.getPreferences(this.getBundleId());
            assert (settings != null) : "settings must not be null";
            this.m_attachDiagnosticFiles = !settings.getBoolean(ReportParsingProblemDialog.DONT_ATTACH_DIAGNOSTIC_FILES, false);
            this.m_attachDiagnosticFilesCheckBox.setSelection(this.m_attachDiagnosticFiles);
        }

        public boolean attachAdditionalFiles() {
            return this.m_attachDiagnosticFiles;
        }

        public org.eclipse.swt.widgets.List getList() {
            return this.m_filesList;
        }

        protected String getContextInfoLabel() {
            return "Details: ";
        }
    }
}

