/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ModifiableFileColumnLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PreEditArchitectureFileDialog
extends StandardDialog {
    private final Collection<? extends IPhysicalArchitectureElement> m_elements;
    private final Collection<ArchitectureFile> m_applying;

    public PreEditArchitectureFileDialog(Shell parentShell, Collection<? extends IPhysicalArchitectureElement> elements, Collection<ArchitectureFile> applying) {
        super(parentShell, "Confirm rename architecture element actions");
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'PreEditArchitectureFileDialog' must not be null";
        assert (applying != null) : "Parameter 'applying' of method 'PreEditArchitectureFileDialog' must not be null";
        this.m_elements = elements;
        this.m_applying = applying;
    }

    protected final void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        if (this.m_elements.stream().anyMatch(e -> e.needsSave())) {
            SwtUtility.createOneCellLabel((Composite)composite, (String)"There are changed architecture files that will be saved immediately.", (int)16384);
        }
        if (this.m_applying.size() > 0) {
            SwtUtility.createOneCellLabel((Composite)composite, (String)"All files referencing the renamed file will be modified and immediately saved", (int)16384);
            TableViewer tableViewer = new TableViewer(composite, 2818);
            tableViewer.getTable().setHeaderVisible(true);
            tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
            TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
            column.getColumn().setText("Referencing architecture files");
            column.setLabelProvider((CellLabelProvider)new ModifiableFileColumnLabelProvider());
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            tableViewer.setInput(this.m_applying);
            column.getColumn().pack();
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        }
        SwtUtility.createOneCellLabel((Composite)composite, (String)"Do you want to proceed?", (int)16384);
    }

    public final boolean hasValidData() {
        return true;
    }

    protected final int getNumberOfColumns() {
        return 1;
    }

    protected Point getPreferredSize() {
        return new Point(500, 200);
    }

    protected void applyData() {
        super.applyData();
        this.getButton(0).setEnabled(true);
    }
}

