/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public final class ModifiableFileConflictStateColumnLabelProvider
extends ColumnLabelProvider {
    public String getText(Object element) {
        Pair<IModifiableFile, Files.ConflictState> pair = this.extractTypedPair(element);
        return ((IModifiableFile)pair.getFirst()).getIdentifyingPath();
    }

    public Image getImage(Object element) {
        Pair<IModifiableFile, Files.ConflictState> pair = this.extractTypedPair(element);
        IModifiableFile file = (IModifiableFile)pair.getFirst();
        Files.ConflictState state = (Files.ConflictState)pair.getSecond();
        if (state == Files.ConflictState.NO_CONFLICT) {
            return UiResourceManager.getInstance().getImage(file.getImageResourceName());
        }
        CompositeImageDescriptor descriptor = new CompositeImageDescriptor(file.getImageResourceName());
        descriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, "WarningMarker");
        return UiResourceManager.getInstance().getImage(descriptor);
    }

    public String getToolTipText(Object element) {
        Pair<IModifiableFile, Files.ConflictState> pair = this.extractTypedPair(element);
        IModifiableFile file = (IModifiableFile)pair.getFirst();
        Files.ConflictState state = (Files.ConflictState)pair.getSecond();
        if (state == Files.ConflictState.NO_CONFLICT) {
            return file.getAbsolutePath();
        }
        return state.getPresentationName() + ": " + file.getAbsolutePath();
    }

    private Pair<IModifiableFile, Files.ConflictState> extractTypedPair(Object element) {
        assert (element != null) : "Parameter 'element' of method 'getToolTipText' must not be null";
        assert (element instanceof Pair) : "Unexpected class in method 'getToolTipText': " + String.valueOf(element);
        Pair pair = (Pair)element;
        assert (pair.getFirst() instanceof IModifiableFile) : "Unexpected class: " + String.valueOf(pair.getFirst());
        assert (pair.getSecond() instanceof Files.ConflictState) : "Unexpected class: " + String.valueOf(pair.getSecond());
        Pair typedPair = new Pair((Object)((IModifiableFile)pair.getFirst()), (Object)((Files.ConflictState)pair.getSecond()));
        return typedPair;
    }
}

