/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class ImportQualityModelSelector
extends Composite {
    private ImportQualityModel m_importQualityModel;
    private TableViewer m_tableViewer;
    private TableViewerColumn m_fileColumn;
    private TableViewerColumn m_checkColumn;
    private Button m_selectAll;
    private Button m_deselectAll;
    private Text m_infoText;
    private Object m_lastHoveredItem;

    public ImportQualityModelSelector(Composite parent, ImportQualityModel importQualityModel, final ISelectionChangedListener selectionChangedListener, final SelectionListener selectionListener) {
        super(parent, 0);
        this.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        SashForm sashFrom = new SashForm((Composite)this, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sashFrom);
        sashFrom.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite upper = new Composite((Composite)sashFrom, 0);
        upper.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        upper.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_importQualityModel = importQualityModel;
        this.m_tableViewer = new TableViewer(upper, 68354);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.heightHint = 400;
        this.m_tableViewer.getControl().setLayoutData((Object)gridData2);
        this.m_fileColumn = new TableViewerColumn(this.m_tableViewer, 0);
        this.m_fileColumn.getColumn().setResizable(true);
        this.m_fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'getText' must not be null");
                }
                if (!$assertionsDisabled && !(element instanceof ImportQualityModel.ImportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(element)));
                }
                ImportQualityModel.ImportQualityModelCandidate candidate = (ImportQualityModel.ImportQualityModelCandidate)element;
                return candidate.getModifiableFile().getIdentifyingPath();
            }

            public Image getImage(Object element) {
                ImportQualityModel.CandidateState state;
                if (!$assertionsDisabled && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'getImage' must not be null");
                }
                if (!$assertionsDisabled && !(element instanceof ImportQualityModel.ImportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(element)));
                }
                ImportQualityModel.ImportQualityModelCandidate candidate = (ImportQualityModel.ImportQualityModelCandidate)element;
                if (candidate.isIncluded() && ((state = ImportQualityModelSelector.this.m_importQualityModel.verifyState(candidate)).equals((Object)ImportQualityModel.CandidateState.OVERWRITES) || state.equals((Object)ImportQualityModel.CandidateState.OVERWRITES_MODIFIED))) {
                    CompositeImageDescriptor descriptor = new CompositeImageDescriptor(candidate.getModifiableFile().getImageResourceName());
                    descriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, "WarningMarker");
                    return UiResourceManager.getInstance().getImage(descriptor);
                }
                return UiResourceManager.getInstance().getImage(candidate.getModifiableFile().getImageResourceName());
            }

            public String getToolTipText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof ImportQualityModel.ImportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getToolTipText': " + String.valueOf(element)));
                }
                ImportQualityModel.ImportQualityModelCandidate candidate = (ImportQualityModel.ImportQualityModelCandidate)element;
                ImportQualityModel.CandidateState state = ImportQualityModelSelector.this.m_importQualityModel.verifyState(candidate);
                if (candidate.isIncluded()) {
                    if (state.equals((Object)ImportQualityModel.CandidateState.OVERWRITES)) {
                        return "Will overwrite an existing file";
                    }
                    if (state.equals((Object)ImportQualityModel.CandidateState.OVERWRITES_MODIFIED)) {
                        return "Will overwrite an existing unsaved file";
                    }
                }
                return null;
            }
        });
        this.m_checkColumn = new TableViewerColumn(this.m_tableViewer, 0x1000000);
        this.m_checkColumn.getColumn().setResizable(false);
        this.m_checkColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!$assertionsDisabled && cell == null) {
                    throw new AssertionError((Object)"Parameter 'cell' of method 'update' must not be null");
                }
                if (!($assertionsDisabled || cell.getElement() != null && cell.getElement() instanceof ImportQualityModel.ImportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'update': " + String.valueOf(cell.getElement())));
                }
                if (((ImportQualityModel.ImportQualityModelCandidate)cell.getElement()).isIncluded()) {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxChecked"));
                } else {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxUnchecked"));
                }
            }

            public String getToolTipText(Object element) {
                return null;
            }
        });
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Object firstElement = selection.getFirstElement();
                    if (!($assertionsDisabled || firstElement != null && firstElement instanceof ImportQualityModel.ImportQualityModelCandidate)) {
                        throw new AssertionError((Object)("Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement)));
                    }
                    ImportQualityModel.ImportQualityModelCandidate candidate = (ImportQualityModel.ImportQualityModelCandidate)firstElement;
                    candidate.toggleIncludedState();
                }
                ImportQualityModelSelector.this.updateTableViewer();
                selectionChangedListener.selectionChanged(event);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, (int)2);
        SwtUtility.packAllColumnsAndRightAlignLast((TableViewer)this.m_tableViewer);
        Composite buttonComposite = new Composite(upper, 0);
        buttonComposite.setLayout((Layout)new FillLayout());
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_selectAll = new Button(buttonComposite, 8);
        this.m_selectAll.setText("Select All");
        this.m_selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportQualityModelSelector.this.m_importQualityModel.getCandidates().stream().forEach(c -> c.setIncluded(true));
                ImportQualityModelSelector.this.updateTableViewer();
                selectionListener.widgetSelected(e);
            }
        });
        this.m_deselectAll = new Button(buttonComposite, 8);
        this.m_deselectAll.setText("Deselect All");
        this.m_deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportQualityModelSelector.this.m_importQualityModel.getCandidates().stream().forEach(c -> c.setIncluded(false));
                ImportQualityModelSelector.this.updateTableViewer();
                selectionListener.widgetSelected(e);
            }
        });
        Group lowerPart = new Group((Composite)sashFrom, 0);
        lowerPart.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        this.m_infoText = new Text((Composite)lowerPart, 578);
        this.m_infoText.setText("");
        this.m_infoText.setEditable(false);
        this.m_infoText.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gridDataLower = new GridData(4, 4, true, true);
        gridDataLower.heightHint = SwtUtility.calculatePreferredHeight((Text)this.m_infoText, (int)3);
        lowerPart.setLayoutData((Object)gridDataLower);
        lowerPart.setText("Info");
        sashFrom.setWeights(new int[]{8, 2});
        this.m_tableViewer.getTable().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                TableItem item = ImportQualityModelSelector.this.m_tableViewer.getTable().getItem(new Point(event.x, event.y));
                if (item != null && item.getData() != ImportQualityModelSelector.this.m_lastHoveredItem) {
                    ImportQualityModelSelector.this.m_lastHoveredItem = item.getData();
                    if (ImportQualityModelSelector.this.m_lastHoveredItem instanceof ImportQualityModel.ImportQualityModelCandidate) {
                        ImportQualityModel.ImportQualityModelCandidate candidate = (ImportQualityModel.ImportQualityModelCandidate)ImportQualityModelSelector.this.m_lastHoveredItem;
                        IModifiableFile modifiableFile = candidate.getModifiableFile();
                        StringBuilder info = new StringBuilder(modifiableFile.getFile().getName());
                        info.append(" (").append(modifiableFile.getFileType().getPresentationName()).append(")");
                        String description = candidate.getDescription();
                        if (description != null && description.trim().length() > 0) {
                            info.append("\nDescription: ").append(description);
                        }
                        ImportQualityModelSelector.this.m_infoText.setText(info.toString());
                    }
                }
            }
        });
        this.setInput(this.m_importQualityModel);
    }

    private void updateTableViewer() {
        this.m_tableViewer.getTable().setRedraw(false);
        this.m_tableViewer.refresh();
        this.m_tableViewer.getTable().setRedraw(true);
    }

    public void clear() {
        this.m_tableViewer.setInput(null);
    }

    public void setInput(ImportQualityModel qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setInput' must not be null";
        this.m_importQualityModel = qualityModel;
        this.m_tableViewer.setInput((Object)qualityModel.getCandidates());
        Table table = this.m_tableViewer.getTable();
        TableColumn[] tableColumns = table.getColumns();
        if (tableColumns.length > 1) {
            TableColumn lastButOneTableColumn;
            int widthToBeSet;
            ScrollBar vScrollBar;
            int columnsWidth = 0;
            TableColumn[] tableColumnArray = tableColumns;
            int n = tableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn nextTableColumn = tableColumnArray[n2];
                nextTableColumn.pack();
                columnsWidth += nextTableColumn.getWidth();
                ++n2;
            }
            Rectangle clientArea = table.getClientArea();
            Point preferredSize = table.computeSize(-1, -1);
            int netWidth = clientArea.width - 2 * table.getBorderWidth();
            if (preferredSize.y > clientArea.height + table.getHeaderHeight() && (vScrollBar = table.getVerticalBar()) != null) {
                netWidth -= vScrollBar.getSize().x;
            }
            if ((widthToBeSet = (lastButOneTableColumn = tableColumns[tableColumns.length - 2]).getWidth() + netWidth - columnsWidth) > lastButOneTableColumn.getWidth()) {
                lastButOneTableColumn.setWidth(widthToBeSet);
            }
        }
        boolean enabled = qualityModel.getCandidates().size() > 0;
        this.m_selectAll.setEnabled(enabled);
        this.m_deselectAll.setEnabled(enabled);
    }
}

