/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecture.MoveArchitectureElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NamedElementSelectionDialog;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.PreEditArchitectureFileDialog;
import com.hello2morrow.sonargraph.ui.standalone.debugview.NamedElementBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.SelectionBasedCommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class MoveArchitectureElementsCommandHandler
extends SelectionBasedCommandHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.MOVE_ARCHITECTURE_ELEMENTS;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> selected) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                if (!$assertionsDisabled && selected == null) {
                    throw new AssertionError((Object)"Parameter 'selected' of method 'showInContextMenu' must not be null");
                }
                return workbenchView.getViewId() == ViewId.ARCHITECTURE_VIEW || workbenchView.getViewId() == ViewId.FILES_VIEW;
            }

            public String getLabel(IWorkbenchView workbenchView, List<Element> selection, String defaultLabel) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'getLabel' must not be null");
                }
                if (!$assertionsDisabled && selection == null) {
                    throw new AssertionError((Object)"Parameter 'selection' of method 'getLabel' must not be null");
                }
                if (selection.size() > 1) {
                    return "Move Architecture Elements";
                }
                return "Move Architecture Element";
            }
        };
    }

    public final boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection viewSelection) {
        assert (viewSelection != null) : "Parameter 'selection' of method 'internalCanExecute' must not be null";
        if (!viewSelection.isEmpty() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED})) {
            List selection = CommandHandler.getMultipleSelectionIfAllAreAssignable(IPhysicalArchitectureElement.class, (List)viewSelection.getElements());
            if (selection.isEmpty()) {
                return false;
            }
            Set parents = selection.stream().map(e -> e.getElement().getParent()).collect(Collectors.toSet());
            if (parents.size() != 1) {
                return false;
            }
            IArchitectureProvider architectureProvider = (IArchitectureProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitectureProvider.class);
            List targetDirs = architectureProvider.getAvailableTargetDirectories(selection);
            return !targetDirs.isEmpty();
        }
        return false;
    }

    @Execute
    public final void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (!selection.isEmpty()) : "selection is empty";
        MoveArchitectureElementsCommand command = new MoveArchitectureElementsCommand(WorkbenchRegistry.getInstance().getProvider(), (MoveArchitectureElementsCommand.IMoveInteraction)new MoveInteraction(selection.getElements()));
        UserInterfaceAdapter.getInstance().run((Command)command);
    }

    private static class ArchitectureElementAdapter
    extends NamedElementBeanAdapter {
        private ArchitectureElementAdapter() {
            super(false);
        }

        @Override
        public String getFullName() {
            if (this.m_namedElement instanceof Architecture) {
                return "./";
            }
            return super.getFullName() + "/";
        }
    }

    private class MoveInteraction
    implements MoveArchitectureElementsCommand.IMoveInteraction {
        private final List<? extends IPhysicalArchitectureElement> m_selection;
        private final IArchitectureProvider m_architectureProvider;

        private MoveInteraction(List<Element> selection) {
            this.m_selection = CommandHandler.getMultipleSelectionIfAllAreAssignable(IPhysicalArchitectureElement.class, selection);
            assert (!this.m_selection.isEmpty());
            this.m_architectureProvider = (IArchitectureProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitectureProvider.class);
        }

        public boolean collectData(final MoveArchitectureElementsCommand.MoveCommandData data) {
            data.setElements(this.m_selection);
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    NamedElementSelectionDialog dialog = new NamedElementSelectionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Select Target Directory", MoveInteraction.this.m_architectureProvider.getAvailableTargetDirectories(MoveInteraction.this.m_selection), false, new ArchitectureElementAdapter());
                    int reply = dialog.open();
                    if (reply == 0) {
                        data.setTargetDirectory((DirectoryPath)dialog.getSelection());
                    }
                }
            });
            return data.getTargetDirectory() != null;
        }

        public void processMoveResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public boolean confirmSaveBeforeMove(final Collection<? extends IPhysicalArchitectureElement> files, final Collection<ArchitectureFile> applyingFiles) {
            if (!files.stream().anyMatch(f -> f.needsSave()) && applyingFiles.size() == 0) {
                return true;
            }
            RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                public void run() {
                    PreEditArchitectureFileDialog dialog = new PreEditArchitectureFileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), files, applyingFiles);
                    if (dialog.open() == 0) {
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
        }
    }
}

