/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.architecture.CreateArchitectureFileCommand;
import com.hello2morrow.sonargraph.core.command.system.architecture.RenameArchitectureElementCommand;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.CreateArchitectureFileWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.PreEditArchitectureFileDialog;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ArchitectureFileViewShowInViewSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class ArchitectureFileWizard
extends NonLazySonargraphWizard {
    private final DirectoryPath m_inDirectory;
    private final IPhysicalArchitectureElement m_toBeRenamed;
    private NameAndDescriptionWizardPage m_page;

    public ArchitectureFileWizard(DirectoryPath directoryPath) {
        super("New Architecture File In '" + (directoryPath != null ? directoryPath.getPresentationName(false) : "") + "'");
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'ArchitectureFileWizard' must not be null";
        this.m_inDirectory = directoryPath;
        this.m_toBeRenamed = null;
    }

    public ArchitectureFileWizard(IPhysicalArchitectureElement architectureElement) {
        super("Edit Architecture File");
        assert (architectureElement != null) : "Parameter 'architectureFile' of method 'ArchitectureFileWizard' must not be null";
        this.m_inDirectory = (DirectoryPath)architectureElement.getElement().getParent(DirectoryPath.class, new Class[0]);
        this.m_toBeRenamed = architectureElement;
    }

    public int getPreferredWidth() {
        return 150;
    }

    public int getPreferredHeight() {
        return 100;
    }

    public int getMinimumWidth() {
        return 150;
    }

    public int getMinimumHeight() {
        return 100;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IArchitectureProvider architectureProvider = (IArchitectureProvider)provider.getSoftwareSystem().getExtension(IArchitectureProvider.class);
        this.m_page = this.m_toBeRenamed == null ? new CreateArchitectureFileWizardPage(architectureProvider.getArchitectureFileNameValidator(this.m_inDirectory, this.m_toBeRenamed)) : new NameAndDescriptionWizardPage("EditArchitectureElement", "Rename Architecture Element", "Name", architectureProvider.getArchitectureFileNameValidator(this.m_inDirectory, this.m_toBeRenamed), this.m_toBeRenamed.getEditName(), null);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean canFinish() {
        if (super.canFinish()) {
            if (this.m_toBeRenamed == null) {
                return true;
            }
            return this.m_page.isNameModified();
        }
        return false;
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            if (this.m_toBeRenamed == null) {
                final CreateArchitectureFileCommand createCommand = new CreateArchitectureFileCommand(provider, (CreateArchitectureFileCommand.ICreateInteraction)new CreateInteraction());
                UserInterfaceAdapter.getInstance().run((Command)createCommand, new CommandResultConsumer(){

                    public void consume(CommandException exception) {
                        ArchitectureFile architectureFile;
                        if (exception == null && (architectureFile = createCommand.getArchitectureFile()) != null) {
                            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                                @Override
                                public void run() {
                                    List architectureFileTargets = ArchitectureFileViewShowInViewSupport.getArchitectureFileTargets(Collections.singletonList(architectureFile));
                                    if (!$assertionsDisabled && architectureFileTargets.size() != 1) {
                                        throw new AssertionError((Object)("Only one file target expected but was: " + architectureFileTargets.size()));
                                    }
                                    ArrayList<ArchitectureFileViewShowInViewSupport.FileTargetValue> options = new ArrayList<ArchitectureFileViewShowInViewSupport.FileTargetValue>();
                                    options.add(((ArchitectureFileViewShowInViewSupport.FileTarget)architectureFileTargets.get(0)).getFileTargetValue());
                                    ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.ARCHITECTURE_FILE_VIEW, (String)architectureFile.getFileId(), options, Collections.singletonList(architectureFile), (boolean)false);
                                }
                            });
                        }
                        super.consume(exception);
                    }
                });
            } else {
                RenameArchitectureElementCommand editCommand = new RenameArchitectureElementCommand(provider, (RenameArchitectureElementCommand.IRenameInteraction)new EditInteraction());
                UserInterfaceAdapter.getInstance().run((Command)editCommand);
            }
            return true;
        }
        return false;
    }

    final class CreateInteraction
    extends StandardCommandInteraction
    implements CreateArchitectureFileCommand.ICreateInteraction {
        CreateInteraction() {
        }

        public boolean collect(CreateArchitectureFileCommand.CreateData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            assert (ArchitectureFileWizard.this.m_page != null && ArchitectureFileWizard.this.m_page instanceof CreateArchitectureFileWizardPage) : "Unexpected class in method 'collect': " + String.valueOf((Object)ArchitectureFileWizard.this.m_page);
            data.setName(ArchitectureFileWizard.this.m_page.getElementName());
            data.setDirectoryPath(ArchitectureFileWizard.this.m_inDirectory);
            data.addExampleSnippet(((CreateArchitectureFileWizardPage)ArchitectureFileWizard.this.m_page).addExampleSnippet());
            return true;
        }

        public void processCreateResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    final class EditInteraction
    extends StandardCommandInteraction
    implements RenameArchitectureElementCommand.IRenameInteraction {
        EditInteraction() {
        }

        public boolean collect(RenameArchitectureElementCommand.EditData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setName(ArchitectureFileWizard.this.m_page.getElementName());
            data.setArchitectureElement(ArchitectureFileWizard.this.m_toBeRenamed);
            return true;
        }

        public boolean confirmSaveOnRename(final IPhysicalArchitectureElement element, final Collection<ArchitectureFile> applying) {
            assert (element != null) : "Parameter 'element' of method 'confirmSaveOnEdit' must not be null";
            assert (applying != null) : "Parameter 'applying' of method 'confirmSaveOnEdit' must not be null";
            if (!element.needsSave() && applying.size() == 0) {
                return true;
            }
            RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                public void run() {
                    PreEditArchitectureFileDialog dialog = new PreEditArchitectureFileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), List.of(element), applying);
                    if (dialog.open() == 0) {
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
        }

        public void processRenameResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

