/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.architecture.CreateArchitectureDirectoryCommand;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.CreateArchitectureDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;

public final class ArchitectureDirectoryWizard
extends NonLazySonargraphWizard {
    private final DirectoryPath m_inDirectory;
    private NameAndDescriptionWizardPage m_page;

    public ArchitectureDirectoryWizard(DirectoryPath directoryPath) {
        super("New Architecture File In '" + (directoryPath != null ? directoryPath.getPresentationName(false) : "") + "'");
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'ArchitectureFileWizard' must not be null";
        this.m_inDirectory = directoryPath;
    }

    public int getPreferredWidth() {
        return 150;
    }

    public int getPreferredHeight() {
        return 100;
    }

    public int getMinimumWidth() {
        return 150;
    }

    public int getMinimumHeight() {
        return 100;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IArchitectureProvider architectureProvider = (IArchitectureProvider)provider.getSoftwareSystem().getExtension(IArchitectureProvider.class);
        this.m_page = new CreateArchitectureDirectoryWizardPage(architectureProvider.getArchitectureDirectoryNameValidator(this.m_inDirectory));
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            CreateArchitectureDirectoryCommand createCommand = new CreateArchitectureDirectoryCommand(provider, (CreateArchitectureDirectoryCommand.ICreateInteraction)new CreateInteraction());
            UserInterfaceAdapter.getInstance().run((Command)createCommand);
            return true;
        }
        return false;
    }

    final class CreateInteraction
    extends StandardCommandInteraction
    implements CreateArchitectureDirectoryCommand.ICreateInteraction {
        CreateInteraction() {
        }

        public boolean collect(CreateArchitectureDirectoryCommand.CreateData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            assert (ArchitectureDirectoryWizard.this.m_page != null);
            data.setName(ArchitectureDirectoryWizard.this.m_page.getElementName());
            data.setDirectoryPath(ArchitectureDirectoryWizard.this.m_inDirectory);
            return true;
        }

        public void processCreateResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

