/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.GridPosition;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.IUmlComponentFigureGridLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UmlComponentFigureGridLayout
implements IUmlComponentFigureGridLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmlComponentFigureGridLayout.class);
    private final Figure m_owner;
    private final Rectangle[][] m_grid;
    private final int[] m_rowToHeight;
    private final int[] m_columnToWidth;
    private final Dimension m_size;
    private final int m_gridAreaHalfSpacing;
    private final int m_dependencyOffset;

    UmlComponentFigureGridLayout(Figure owner, List<UmlComponentFigure> umlComponentFigures) {
        assert (umlComponentFigures != null && !umlComponentFigures.isEmpty()) : "Parameter 'umlComponentFigures' of method 'UmlComponentFigureGridLayout' must not be empty";
        this.m_owner = owner;
        TreeMap<Integer, ArrayList<UmlComponentFigure>> levelToUmlComponentFigures = new TreeMap<Integer, ArrayList<UmlComponentFigure>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer l1, Integer l2) {
                if (!$assertionsDisabled && l1 == null) {
                    throw new AssertionError((Object)"Parameter 'l1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && l2 == null) {
                    throw new AssertionError((Object)"Parameter 'l2' of method 'compare' must not be null");
                }
                return l2 - l1;
            }
        });
        int maxDependencies = 0;
        for (UmlComponentFigure nextUmlComponentFigure : umlComponentFigures) {
            UmlComponent umlComponent = (UmlComponent)nextUmlComponentFigure.getNode();
            Integer nextLevel = umlComponent.getLevel();
            ArrayList<UmlComponentFigure> nextOnLevel = (ArrayList<UmlComponentFigure>)levelToUmlComponentFigures.get(nextLevel);
            if (nextOnLevel == null) {
                nextOnLevel = new ArrayList<UmlComponentFigure>();
                levelToUmlComponentFigures.put(nextLevel, nextOnLevel);
            }
            nextOnLevel.add(nextUmlComponentFigure);
            maxDependencies = Math.max(maxDependencies, umlComponent.getIncomingUses().size());
            maxDependencies = Math.max(maxDependencies, umlComponent.getOutgoingUses().size());
        }
        if (maxDependencies % 2 == 0) {
            ++maxDependencies;
        }
        this.m_dependencyOffset = maxDependencies <= 10 ? 8 : (maxDependencies <= 20 ? 6 : (maxDependencies <= 40 ? 4 : (maxDependencies <= 60 ? 3 : 2)));
        int gridAreaTotal = (maxDependencies + 1) * this.m_dependencyOffset;
        if (gridAreaTotal % 2 != 0) {
            ++gridAreaTotal;
        }
        this.m_gridAreaHalfSpacing = gridAreaTotal / 2;
        LOGGER.debug("Grid area total: " + gridAreaTotal + ", grid area half: " + this.m_gridAreaHalfSpacing + ", max deps: " + maxDependencies + ", slots: " + this.getNumberOfSlots());
        int columns = 0;
        for (Map.Entry entry : levelToUmlComponentFigures.entrySet()) {
            columns = Math.max(columns, ((List)entry.getValue()).size());
        }
        int n = levelToUmlComponentFigures.size();
        LOGGER.debug("Columns/rows: " + columns + "/" + n);
        int currentRow = 0;
        for (Map.Entry nextEntry : levelToUmlComponentFigures.entrySet()) {
            List nextOnLevel = (List)nextEntry.getValue();
            LOGGER.debug("Level/components: " + String.valueOf(nextEntry.getKey()) + "/" + nextOnLevel.size());
            int currentColumn = 0;
            for (UmlComponentFigure next : nextOnLevel) {
                next.setGridProsition(this, new GridPosition(currentRow, currentColumn));
                ++currentColumn;
            }
            ++currentRow;
        }
        this.m_grid = new Rectangle[n][columns];
        int r = 0;
        while (r < this.m_grid.length) {
            int c = 0;
            while (c < this.m_grid[r].length) {
                this.m_grid[r][c] = new Rectangle();
                ++c;
            }
            ++r;
        }
        this.m_rowToHeight = new int[this.m_grid.length];
        Arrays.fill(this.m_rowToHeight, 0);
        this.m_columnToWidth = new int[this.m_grid[0].length];
        Arrays.fill(this.m_columnToWidth, 0);
        for (UmlComponentFigure next : umlComponentFigures) {
            Dimension nextPreferredSize = next.getPreferredSize();
            GridPosition nextGridPosition = next.getGridPosition();
            this.m_rowToHeight[nextGridPosition.getRow()] = Math.max(this.m_rowToHeight[nextGridPosition.getRow()], nextPreferredSize.height + 2 * this.m_gridAreaHalfSpacing);
            this.m_columnToWidth[nextGridPosition.getColumn()] = Math.max(this.m_columnToWidth[nextGridPosition.getColumn()], nextPreferredSize.width + 2 * this.m_gridAreaHalfSpacing);
        }
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < this.m_columnToWidth.length) {
            width += this.m_columnToWidth[i];
            ++i;
        }
        i = 0;
        while (i < this.m_rowToHeight.length) {
            height += this.m_rowToHeight[i];
            ++i;
        }
        this.m_size = new Dimension(width + 2 * this.m_gridAreaHalfSpacing, height + 2 * this.m_gridAreaHalfSpacing);
        int offsetX = this.m_gridAreaHalfSpacing;
        int offsetY = this.m_gridAreaHalfSpacing;
        int r2 = 0;
        while (r2 < this.m_grid.length) {
            int nextHeight = this.m_rowToHeight[r2];
            int c = 0;
            while (c < this.m_grid[r2].length) {
                int nextWidth = this.m_columnToWidth[c];
                this.m_grid[r2][c] = new Rectangle(offsetX, offsetY, nextWidth, nextHeight);
                offsetX += nextWidth;
                ++c;
            }
            offsetX = this.m_gridAreaHalfSpacing;
            offsetY += nextHeight;
            ++r2;
        }
    }

    private int calculateOffsetXInGridCell(Rectangle gridCellSize, Dimension nodeSize) {
        assert (gridCellSize != null) : "Parameter 'gridCellSize' of method 'calculateOffsetXInGridCell' must not be null";
        assert (nodeSize != null) : "Parameter 'nodeSize' of method 'calculateOffsetXInGridCell' must not be null";
        int diff = gridCellSize.width - nodeSize.width;
        assert (diff > 0) : "'diff' must be greater than 0";
        return diff / 2;
    }

    private int calculateOffsetYInGridCell(Rectangle gridCellSize, Dimension nodeSize) {
        assert (gridCellSize != null) : "Parameter 'gridCellSize' of method 'calculateOffsetYInGridCell' must not be null";
        assert (nodeSize != null) : "Parameter 'nodeSize' of method 'calculateOffsetYInGridCell' must not be null";
        int diff = gridCellSize.height - nodeSize.height;
        assert (diff > 0) : "'diff' must be greater than 0";
        return diff / 2;
    }

    private Rectangle getBounds(UmlComponentFigure umlComponentFigure) {
        assert (umlComponentFigure != null) : "Parameter 'umlComponentFigure' of method 'getBounds' must not be null";
        Rectangle gridCell = this.m_grid[umlComponentFigure.getGridPosition().getRow()][umlComponentFigure.getGridPosition().getColumn()];
        assert (gridCell != null) : "Parameter 'nextGridCell' of method 'getBounds' must not be null";
        Dimension nextPreferredSize = umlComponentFigure.getPreferredSize();
        return new Rectangle(gridCell.x + this.calculateOffsetXInGridCell(gridCell, nextPreferredSize), gridCell.y + this.calculateOffsetYInGridCell(gridCell, nextPreferredSize), nextPreferredSize.width, nextPreferredSize.height);
    }

    void layout(List<UmlComponentFigure> umlComponentFigures) {
        assert (umlComponentFigures != null && !umlComponentFigures.isEmpty()) : "Parameter 'umlComponentFigures' of method 'layout' must not be empty";
        for (UmlComponentFigure next : umlComponentFigures) {
            next.setBounds(this.getBounds(next));
        }
    }

    Dimension getSize() {
        return this.m_size;
    }

    @Override
    public int getDependencyOffset() {
        return this.m_dependencyOffset;
    }

    @Override
    public int getSpaceOnEachSideOfGridLines() {
        return this.m_gridAreaHalfSpacing;
    }

    @Override
    public int getNumberOfSlots() {
        return 2 * this.m_gridAreaHalfSpacing / this.m_dependencyOffset - 1;
    }

    int getNumberOfHorizontalGridLines() {
        return this.m_rowToHeight.length + 1;
    }

    int getNumberOfVerticalGridLines() {
        return this.m_columnToWidth.length + 1;
    }

    @Override
    public int getVerticalGridLinePosX(int index) {
        assert (index >= 0 && index < this.getNumberOfVerticalGridLines()) : "Invalid grid line index: " + index;
        int posX = (this.m_owner != null ? this.m_owner.getLocation().x : 0) + this.m_gridAreaHalfSpacing;
        int i = 0;
        while (i < index) {
            posX += this.m_columnToWidth[i];
            ++i;
        }
        return posX;
    }

    @Override
    public int getHorizontalGridLinePosY(int index) {
        assert (index >= 0 && index < this.getNumberOfHorizontalGridLines()) : "Invalid grid line index: " + index;
        int posY = (this.m_owner != null ? this.m_owner.getLocation().y : 0) + this.m_gridAreaHalfSpacing;
        int i = 0;
        while (i < index) {
            posY += this.m_rowToHeight[i];
            ++i;
        }
        return posY;
    }

    public String toString() {
        return "Grid layout [rows][columns]: [" + this.m_grid.length + "][" + this.m_grid[0].length + "]";
    }
}

