/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.architecturediagram.CreateArchitectureDiagramCommand;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramCreatedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramDeletedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramModifiedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramRepresentation;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IArchitectureDiagramProvider;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.ArchitectureDiagramFigureProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.ArchitectureDiagramLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentAnchorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentConnectorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentInterfaceFigure;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.FocusableToolTip;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvas;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvasLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithHome;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CanvasImageExporter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureDiagramView
extends WorkbenchSlaveView
implements IViewWithZoom,
IViewWithHome,
FocusableToolTip.IToolTipProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureDiagramView.class);
    private DrawNodeAndConnectionFigureCanvas<UmlComponent, UmlComponent.UmlComponentDependency, ArchitectureDiagramLayout> m_canvas;
    private ArchitectureDiagramFigureProvider m_figureProvider;
    private ArchitectureFile m_file;
    private ArchitectureDiagramRepresentation m_representation;
    private FocusableToolTip m_focusableToolTip;

    public IViewId getViewId() {
        return ViewId.ARCHITECTURE_DIAGRAM_VIEW;
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }

    protected boolean supportsSleep() {
        return false;
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_canvas);
    }

    private void representationCreated(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'representationCreated' must not be null";
        assert (this.m_canvas != null) : "'m_canvas' of method 'createRepresentation' must not be null";
        assert (this.m_file != null) : "'m_file' of method 'createRepresentation' must not be null";
        this.m_canvas.setRedraw(false);
        this.m_canvas.clear();
        boolean initialCreation = true;
        if (this.m_figureProvider != null) {
            this.m_figureProvider.delete();
            this.m_figureProvider = null;
            initialCreation = false;
        }
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'createRepresentation' must not be null";
        this.m_representation = representation;
        this.m_figureProvider = new ArchitectureDiagramFigureProvider(this.getViewId(), this.getSecondaryId(), this.getSelectionProviderAdapter(), (IArchitectureDiagramProvider)softwareSystem.getExtension(IArchitectureDiagramProvider.class), this.m_canvas, this.m_representation);
        this.m_canvas.setRedraw(true);
        if (initialCreation) {
            WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
        }
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    private void updateRepresentation(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateRepresentation' must not be null";
        assert (this.m_representation == representation) : "Different instances";
        LOGGER.debug("Update");
        this.m_canvas.updateFromModel();
        LOGGER.debug("Update - done");
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_canvas = new DrawNodeAndConnectionFigureCanvas(viewContentArea, (DrawNodeAndConnectionFigureCanvasLayout)new ArchitectureDiagramLayout());
        this.m_focusableToolTip = new FocusableToolTip((Control)this.m_canvas, this);
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitectureDiagramCreatedEvent>(ArchitectureDiagramCreatedEvent.class, (Object)this){

            public void handleEvent(ArchitectureDiagramCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitectureDiagramView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getFile() == ArchitectureDiagramView.this.m_file) {
                    ArchitectureDiagramView.this.representationCreated(event.getRepresentation());
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitectureDiagramModifiedEvent>(ArchitectureDiagramModifiedEvent.class, (Object)this){

            public void handleEvent(ArchitectureDiagramModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitectureDiagramView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getRepresentation().getArchitectureFile() == ArchitectureDiagramView.this.m_file) {
                    switch (event.getMode()) {
                        case CREATE: {
                            ArchitectureDiagramView.this.representationCreated(event.getRepresentation());
                            break;
                        }
                        case UPDATE: {
                            ArchitectureDiagramView.this.updateRepresentation(event.getRepresentation());
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)("Unhandled mode: " + String.valueOf(event.getMode())));
                            }
                            break;
                        }
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ArchitectureDiagramDeletedEvent>(ArchitectureDiagramDeletedEvent.class, (Object)this){

            public void handleEvent(ArchitectureDiagramDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (ArchitectureDiagramView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getFile() == ArchitectureDiagramView.this.m_file) {
                    ArchitectureDiagramView.this.resetPartName();
                    ArchitectureDiagramView.this.hideView();
                }
            }
        });
    }

    protected void destroyViewContent() {
        if (this.m_focusableToolTip != null) {
            this.m_focusableToolTip.closeTooltip();
            this.m_focusableToolTip = null;
        }
        EventManager.getInstance().detach(ArchitectureDiagramCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitectureDiagramDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ArchitectureDiagramModifiedEvent.class, (Object)this);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && this.m_file != null && this.m_representation != null) {
            ((IArchitectureDiagramProvider)softwareSystem.getExtension(IArchitectureDiagramProvider.class)).delete(this.m_representation);
        }
        this.m_file = null;
        this.m_representation = null;
        if (this.m_figureProvider != null) {
            this.m_figureProvider.delete();
            this.m_figureProvider = null;
        }
        if (this.m_canvas != null) {
            this.m_canvas.dispose();
            this.m_canvas = null;
        }
    }

    public void requestHome() {
        this.m_canvas.resetZoom();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    public boolean mayRequestHome() {
        return this.m_canvas.isResetZoomPossible();
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        assert (elements.size() == 1) : "Exactly 1 element expected";
        assert (elements.get(0) instanceof ArchitectureFile) : "Unexpected class in method 'showInView': " + String.valueOf(elements.get(0));
        this.m_file = (ArchitectureFile)elements.get(0);
        assert (this.m_file != null) : "'m_file' of method 'showInView' must not be null";
        this.setTitleTooltip(this.m_file.getIdentifyingPath());
        WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_file.getShortName());
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (this.m_file != null) : "'m_file' of method 'finishShowInView' must not be null";
        if (!((IArchitectureDiagramProvider)this.getSoftwareSystem().getExtension(IArchitectureDiagramProvider.class)).hasBeenCreated(this.m_file)) {
            CreateArchitectureDiagramCommand command = new CreateArchitectureDiagramCommand(this.getSoftwareSystemProvider(), new CreateArchitectureDiagramCommand.ICreateArchitectureDiagramInteraction(){

                public boolean collect(CreateArchitectureDiagramCommand.CreateArchitectureDiagramData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setFile(ArchitectureDiagramView.this.m_file);
                    return true;
                }

                public void processCreateArchitectureDiagramResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processLoadArchitectureDiagramResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                    if (result.isFailure()) {
                        UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                            ArchitectureDiagramView.this.resetPartName();
                            ArchitectureDiagramView.this.hideView();
                        });
                    }
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }

    public boolean zoomInPossible() {
        return this.m_canvas.zoomInPossible();
    }

    public boolean zoomOutPossible() {
        return this.m_canvas.zoomOutPossible();
    }

    public void zoomIn(Point location) {
        this.m_canvas.zoomIn();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    public void zoomOut(Point location) {
        this.m_canvas.zoomOut();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    public boolean supportsImageExport() {
        return this.m_file != null && this.m_canvas != null && this.m_figureProvider != null;
    }

    public String getInitialExportImageName() {
        assert (this.m_file != null) : "Parameter 'm_file' of method 'getInitialExportImageName' must not be null";
        return FileUtility.removeExtension((String)this.m_file.getFile().getName());
    }

    public final OperationResult exportToImage(TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportImage' must not be null";
        return CanvasImageExporter.exportToImage(this.m_canvas, (TFile)targetFile);
    }

    private String getTooltipText(UmlComponentAnchorFigure figure) {
        UmlComponent nextUmlComponent;
        Object nextUmlComponent2;
        Object nextUmlComponent3;
        assert (figure != null) : "Parameter 'figure' of method 'getTooltipText' must not be null";
        StringBuilder builder = new StringBuilder();
        UmlComponentAnchor<?> umlComponentAnchor = figure.getUmlComponentAnchor();
        UmlComponent umlComponent = (UmlComponent)umlComponentAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
        builder.append(umlComponentAnchor.getPresentationKind()).append(": ").append("[").append(umlComponent.getName()).append("] ").append(umlComponentAnchor.getName());
        if (umlComponentAnchor.isPassThrough()) {
            builder.append(" <pass-through>");
        }
        if (figure instanceof UmlComponentConnectorFigure) {
            UmlComponentConnectorFigure connectorFigure = (UmlComponentConnectorFigure)figure;
            Set includedByInfo = connectorFigure.getUmlComponentAnchor().getIncludedByInfo();
            if (!includedByInfo.isEmpty()) {
                builder.append("\n\nIncluded by ").append(includedByInfo.size()).append(" connector(s):");
                for (UmlComponentConnector next : includedByInfo) {
                    nextUmlComponent3 = (UmlComponent)next.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextUmlComponent3 != null) : "'nextUmlComponent' of method 'getToolTipText' must not be null";
                    builder.append("\n - ").append("[").append(nextUmlComponent3.getName()).append("] ").append(next.getName());
                }
            } else {
                builder.append("\n\nIs not ncluded by any connectors.");
            }
            Set includesInfo = connectorFigure.getUmlComponentAnchor().getIncludesInfo();
            if (!includesInfo.isEmpty()) {
                builder.append("\n\nIncludes ").append(includesInfo.size()).append(" connector(s):");
                for (UmlComponentConnector next : includesInfo) {
                    nextUmlComponent2 = (UmlComponent)next.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextUmlComponent2 != null) : "'nextUmlComponent' of method 'getToolTipText' must not be null";
                    builder.append("\n - ").append("[").append(nextUmlComponent2.getName()).append("] ").append(next.getName());
                }
            } else {
                builder.append("\n\nDoes not include any connectors.");
            }
            Set allowedInterfaces = this.m_figureProvider.getRepresentation().getAllowedInterfaces(connectorFigure.getUmlComponentAnchor());
            if (!allowedInterfaces.isEmpty()) {
                builder.append("\n\nMay use ").append(allowedInterfaces.size()).append(" interface(s):");
                nextUmlComponent2 = allowedInterfaces.iterator();
                while (nextUmlComponent2.hasNext()) {
                    UmlComponentInterface next = (UmlComponentInterface)nextUmlComponent2.next();
                    nextUmlComponent = (UmlComponent)next.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextUmlComponent != null) : "'nextUmlComponent' of method 'getToolTipText' must not be null";
                    builder.append("\n - ").append("[").append(nextUmlComponent.getName()).append("] ").append(next.getName());
                }
            } else {
                builder.append("\n\nMay not use any interfaces.");
            }
        }
        if (figure instanceof UmlComponentInterfaceFigure) {
            UmlComponentInterfaceFigure interfaceFigure = (UmlComponentInterfaceFigure)figure;
            Set exportedByInfo = interfaceFigure.getUmlComponentAnchor().getExportedByInfo();
            if (!exportedByInfo.isEmpty()) {
                builder.append("\n\nExported by ").append(exportedByInfo.size()).append(" interface(s):");
                for (UmlComponentConnector next : exportedByInfo) {
                    nextUmlComponent3 = (UmlComponent)next.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextUmlComponent3 != null) : "'nextUmlComponent' of method 'getToolTipText' must not be null";
                    builder.append("\n - ").append("[").append(nextUmlComponent3.getName()).append("] ").append(next.getName());
                }
            } else {
                builder.append("\n\nIs not exported by any interfaces.");
            }
            Set exportsInfo = interfaceFigure.getUmlComponentAnchor().getExportsInfo();
            if (!exportsInfo.isEmpty()) {
                builder.append("\n\nExports ").append(exportsInfo.size()).append(" interface(s):");
                for (UmlComponentConnector next : exportsInfo) {
                    nextUmlComponent2 = (UmlComponent)next.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextUmlComponent2 != null) : "'nextUmlComponent' of method 'getToolTipText' must not be null";
                    builder.append("\n - ").append("[").append(nextUmlComponent2.getName()).append("] ").append(next.getName());
                }
            } else {
                builder.append("\n\nDoes not export any interfaces.");
            }
            Set allowedConnectors = this.m_figureProvider.getRepresentation().getAllowedConnectors(interfaceFigure.getUmlComponentAnchor());
            if (!allowedConnectors.isEmpty()) {
                builder.append("\n\nMay be used from ").append(allowedConnectors.size()).append(" connector(s):");
                for (UmlComponentInterface next : allowedConnectors) {
                    nextUmlComponent = (UmlComponent)next.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextUmlComponent != null) : "'nextUmlComponent' of method 'getToolTipText' must not be null";
                    builder.append("\n - ").append("[").append(nextUmlComponent.getName()).append("] ").append(next.getName());
                }
            } else {
                builder.append("\n\nMay not be used from any connectors.");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            builder.append("\n\n").append("DEBUG:").append("\n");
            builder.append(figure.getDebugInfo());
        }
        return builder.toString();
    }

    @Override
    public String getToolTipText(Point location) {
        assert (location != null) : "Parameter 'location' of method 'getToolTipText' must not be null";
        DrawFigure figure = this.m_canvas.getFigureAt(location);
        if (figure != null) {
            if (figure instanceof UmlComponentAnchorFigure) {
                return this.getTooltipText((UmlComponentAnchorFigure)figure);
            }
            StringBuilder builder = new StringBuilder();
            UmlComponentFigure umlComponentFigure = (UmlComponentFigure)DrawUtilities.findSelfOrParent(UmlComponentFigure.class, (IFigure)figure);
            if (umlComponentFigure != null) {
                UmlComponent umlComponent = (UmlComponent)umlComponentFigure.getNode();
                builder.append(umlComponent.getPresentationKind()).append(": ").append(umlComponent.getName());
                String stereotypes = umlComponent.getArtifact().getStereotypes();
                if (stereotypes != null && !stereotypes.isEmpty()) {
                    builder.append(" <<").append(stereotypes).append(">>");
                }
                builder.append("\n\nIncoming connections: ").append(umlComponent.getNumberOfIncomingUses());
                for (UmlComponent.Uses next : umlComponent.getIncomingUses()) {
                    builder.append("\n - ").append(" [").append(next.getSourceComponent().getName()).append("] ").append(next.getSourceAnchor().getName());
                }
                builder.append("\n\nOutgoing connections: ").append(umlComponent.getNumberOfOutgoingUses());
                for (UmlComponent.Uses next : umlComponent.getOutgoingUses()) {
                    builder.append("\n - ").append(" [").append(next.getTargetComponent().getName()).append("] ").append(next.getTargetAnchor().getName());
                }
                if (LOGGER.isDebugEnabled()) {
                    builder.append("\n\n").append("DEBUG:").append("\n");
                    builder.append(umlComponent.getDebugInfo());
                }
                return builder.toString();
            }
            if (figure instanceof UmlComponentDependencyFigure) {
                UmlComponentDependencyFigure umlComponentDependencyFigure = (UmlComponentDependencyFigure)figure;
                builder.append(umlComponentDependencyFigure.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                builder.append("\n\n").append("DEBUG:").append("\n");
                builder.append(figure.getDebugInfo());
            }
            return builder.toString();
        }
        return null;
    }
}

