/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.FigureListener;
import com.hello2morrow.draw2d.FigureUtilities;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

final class TreeEdgeFigureWeightDecorator
extends Figure
implements FigureListener {
    private static final int FONT_HEIGHT = 9;
    private static final UiResourceManager.FontId FONT_ID = new UiResourceManager.FontId("Arial", 9, 0);
    private static final int OFFSET_Y = 3;
    private String m_weight;
    private Dimension m_dimension;

    private static Rectangle calculateBounds(TreeEdgeFigure treeEdgeFigure, Dimension dimension) {
        assert (treeEdgeFigure != null) : "Parameter 'treeEdgeFigure' of method 'calculateBounds' must not be null";
        assert (dimension != null) : "Parameter 'dimension' of method 'calculateBounds' must not be null";
        Rectangle bounds = new Rectangle();
        bounds.setSize(dimension);
        Rectangle treeEdgeFigureBounds = treeEdgeFigure.getBounds();
        TreeEdgeFigure.Mode mode = treeEdgeFigure.getMode();
        switch (mode) {
            case HALF_ARC_LEFT: {
                bounds.setLocation(treeEdgeFigureBounds.getLeft().translate(-dimension.width + 3, -3));
                break;
            }
            case HALF_ARC_RIGHT: {
                bounds.setLocation(treeEdgeFigureBounds.getRight().translate(-dimension.width - 2, -3));
                break;
            }
            case FULL_ARC: {
                bounds.setLocation(treeEdgeFigureBounds.getTopLeft().translate(-dimension.width + 12, 0));
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
                break;
            }
        }
        return bounds;
    }

    TreeEdgeFigureWeightDecorator(TreeEdgeFigure treeEdgeFigure) {
        assert (treeEdgeFigure != null) : "Parameter 'treeEdgeFigure' of method 'EdgeFigureWeightDecorator' must not be null";
        this.setFont(UiResourceManager.getInstance().getFont(FONT_ID));
        this.update(treeEdgeFigure);
        treeEdgeFigure.addFigureListener(this);
    }

    void update(TreeEdgeFigure treeEdgeFigure) {
        assert (treeEdgeFigure != null) : "Parameter 'treeEdgeFigure' of method 'update' must not be null";
        String weight = Integer.toString(treeEdgeFigure.getWeight());
        if (this.m_weight == null || !weight.equals(this.m_weight)) {
            this.m_weight = weight;
            this.m_dimension = FigureUtilities.getStringExtents((String)this.m_weight, (Font)this.getFont());
            ++this.m_dimension.width;
            this.setBounds(TreeEdgeFigureWeightDecorator.calculateBounds(treeEdgeFigure, this.m_dimension));
        }
    }

    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Color initialFgColor = graphics.getForegroundColor();
        Font initialFont = graphics.getFont();
        graphics.setForegroundColor(UiResourceManager.getInstance().getForegroundColor());
        graphics.setFont(this.getFont());
        graphics.drawText(this.m_weight, this.getBounds().getLocation());
        graphics.setForegroundColor(initialFgColor);
        graphics.setFont(initialFont);
    }

    public void figureMoved(IFigure source) {
        assert (source != null && source instanceof TreeEdgeFigure) : "Unexpected class in method 'figureMoved': " + String.valueOf(source);
        this.setBounds(TreeEdgeFigureWeightDecorator.calculateBounds((TreeEdgeFigure)source, this.m_dimension));
    }
}

