/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.dependenciesview.DeadStateInfoProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NavigationStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationStateHandler.class);
    private final IViewId m_viewId;
    private final String m_secondaryId;

    NavigationStateHandler(IViewId viewId, String secondaryId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'NavigationStateHandler' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'NavigationStateHandler' must not be empty";
        this.m_viewId = viewId;
        this.m_secondaryId = secondaryId;
    }

    private ExplorationViewFocus getFocusToApply(NavigationState navigationStateToRestore) {
        assert (navigationStateToRestore != null) : "Parameter 'navigationStateToRestore' of method 'getFocusToApply' must not be null";
        List allNavigationStates = ViewNavigationManager.getInstance().getViewNavigationStates(this.m_viewId, this.m_secondaryId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ALL STATES");
            for (NavigationState nextNavigationState : allNavigationStates) {
                LOGGER.debug("" + nextNavigationState.getId());
            }
        }
        int pos = ViewNavigationManager.getIndexOf((List)allNavigationStates, (NavigationState)navigationStateToRestore);
        assert (pos != -1) : "Navigation state to restore '" + String.valueOf(navigationStateToRestore) + "' not found in " + String.valueOf(navigationStateToRestore);
        List navigationStates = allNavigationStates.subList(0, pos + 1);
        Collections.reverse(navigationStates);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PROCESSED STATES");
            for (NavigationState nextNavigationState : navigationStates) {
                LOGGER.debug("" + nextNavigationState.getId());
            }
        }
        for (NavigationState nextNavigationState : navigationStates) {
            Object focusObject = nextNavigationState.getDataAsObject((IStateData)NavigationStateData.FOCUS);
            if (focusObject == null) continue;
            assert (focusObject instanceof ExplorationViewFocus) : "Unexpected class in method 'getFocusToApply': " + String.valueOf(focusObject);
            LOGGER.debug("PREVIOUS FOCUS FOUND: " + String.valueOf(focusObject));
            return (ExplorationViewFocus)focusObject;
        }
        LOGGER.debug("NO PREVIOUS FOCUS FOUND");
        return null;
    }

    void restoreState(IArchitecturalViewProvider provider, NavigationState navigationState, ExplorationViewRepresentation representation) {
        assert (provider != null) : "Parameter 'provider' of method 'restoreState' must not be null";
        assert (navigationState != null) : "Parameter 'navigationState' of method 'restoreState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'restoreState' must not be null";
        if (!navigationState.isInvolvedInUndoRedoOperation()) {
            Object representationStateObject = navigationState.getDataAsObject((IStateData)NavigationStateData.STATE);
            assert (representationStateObject != null && representationStateObject instanceof ArchitecturalViewState) : "Unexpected class in method 'restoreState': " + String.valueOf(representationStateObject);
            ArchitecturalViewState representationState = (ArchitecturalViewState)representationStateObject;
            ExplorationViewFocus focusToApply = this.getFocusToApply(navigationState);
            ExplorationViewFocus focus = null;
            if (focusToApply == null) {
                if (!representation.getFocus().isEmpty()) {
                    LOGGER.debug("=> CLEAR FOCUS");
                    focus = new ExplorationViewFocus();
                }
            } else if (!focusToApply.equals((Object)representation.getFocus())) {
                LOGGER.debug("=> SET FOCUS");
                focus = focusToApply;
            }
            PresentationMode presentationMode = null;
            IStandardEnumeration standardEnumeration = (IStandardEnumeration)navigationState.getConstant((IStateData)NavigationStateData.PRESENTATION_MODE);
            assert (standardEnumeration != null && standardEnumeration instanceof PresentationMode) : "Unexpected class in method 'restoreState': " + String.valueOf(standardEnumeration);
            if (!standardEnumeration.equals(representation.getPresentationMode())) {
                presentationMode = (PresentationMode)standardEnumeration;
            }
            ExplorationViewSortMode levelizationMode = null;
            IStandardEnumeration standardEnumerationLevelizationMode = (IStandardEnumeration)navigationState.getConstant((IStateData)NavigationStateData.LEVELIZATION_MODE);
            assert (standardEnumerationLevelizationMode != null && standardEnumerationLevelizationMode instanceof ExplorationViewSortMode) : "Unexpected class in method 'restoreState': " + String.valueOf(standardEnumerationLevelizationMode);
            if (!standardEnumerationLevelizationMode.equals(representation.getSortMode())) {
                levelizationMode = (ExplorationViewSortMode)standardEnumerationLevelizationMode;
            }
            String relativePath = navigationState.getString((IStateData)NavigationStateData.TOP_MOST_NODE);
            provider.restoreState(representationState, presentationMode, levelizationMode, focus, relativePath, representation);
        } else {
            LOGGER.error("Ignore unexpected state 'isInvolvedInUndoRedoOperation': " + String.valueOf(navigationState));
        }
    }

    boolean isHomePossible() {
        NavigationState initialViewNavigationState = ViewNavigationManager.getInstance().getInitialViewNavigationState(this.m_viewId, this.m_secondaryId);
        return initialViewNavigationState != null && ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.m_viewId, this.m_secondaryId) != initialViewNavigationState;
    }

    void home(IArchitecturalViewProvider provider, ExplorationViewRepresentation representation) {
        assert (provider != null) : "Parameter 'provider' of method 'home' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'home' must not be null";
        assert (this.isHomePossible()) : "Home not posible";
        NavigationState initialNavigationState = ViewNavigationManager.getInstance().getInitialViewNavigationState(this.m_viewId, this.m_secondaryId);
        assert (initialNavigationState != null) : "'initialNavigationState' of method 'home' must not be null";
        if (ViewNavigationManager.getInstance().getCurrentNavigationState() != initialNavigationState) {
            ViewNavigationManager.getInstance().clear(this.m_viewId, this.m_secondaryId);
            ViewNavigationManager.getInstance().addNavigationState(initialNavigationState);
        }
        this.restoreState(provider, initialNavigationState, representation);
    }

    static void completeInitialState(NavigationState state, PresentationMode presentationMode, ExplorationViewSortMode levelizationMode) {
        assert (state != null) : "Parameter 'state' of method 'completeInitialState' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'completeInitialState' must not be null";
        assert (levelizationMode != null) : "Parameter 'levelizationMode' of method 'completeInitialState' must not be null";
        state.addViewData((IStateData)NavigationStateData.STATE, (Object)new ArchitecturalViewState());
        state.addConstant((IStateData)NavigationStateData.PRESENTATION_MODE, (Enum)presentationMode);
        state.addConstant((IStateData)NavigationStateData.LEVELIZATION_MODE, (Enum)levelizationMode);
        state.setDeadStateInfoProvider((NavigationState.IDeadStateInfoProvider)DeadStateInfoProvider.INSTANCE);
    }

    static void completeState(IArchitecturalViewProvider provider, NavigationState state, DrawNodeFigure<ArchitecturalViewNode> topMostNode, ExplorationViewRepresentation representation) {
        assert (provider != null) : "Parameter 'provider' of method 'completeState' must not be null";
        assert (state != null) : "Parameter 'state' of method 'completeInitialState' must not be null";
        ArchitecturalViewState representationState = provider.createState(representation);
        state.addViewData((IStateData)NavigationStateData.STATE, (Object)representationState);
        state.addConstant((IStateData)NavigationStateData.PRESENTATION_MODE, (Enum)representation.getPresentationMode());
        state.addConstant((IStateData)NavigationStateData.LEVELIZATION_MODE, (Enum)representation.getSortMode());
        if (topMostNode != null) {
            state.addString((IStateData)NavigationStateData.TOP_MOST_NODE, ((ArchitecturalViewNode)topMostNode.getNode()).getRelativePath());
        }
        state.setDeadStateInfoProvider((NavigationState.IDeadStateInfoProvider)DeadStateInfoProvider.INSTANCE);
    }

    private void createAndAddNavigationState(IArchitecturalViewProvider provider, ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger, DrawNodeFigure<ArchitecturalViewNode> topMostNode, boolean isInitial, ExplorationViewRepresentation representation) {
        assert (provider != null) : "Parameter 'provider' of method 'createAndAddNavigationState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createAndAddNavigationState' must not be null";
        NavigationState.Type type = NavigationState.Type.CONTENT_MODIFIED;
        if (trigger != null) {
            switch (trigger) {
                case EXPAND: {
                    type = NavigationState.Type.CONTENT_EXPANDED;
                    break;
                }
                case COLLAPSE: {
                    type = NavigationState.Type.CONTENT_COLLAPSED;
                    break;
                }
                case FOCUS: {
                    type = NavigationState.Type.CONTENT_FOCUSED;
                    break;
                }
                case PRESENTATION_MODE: 
                case SORT_MODE: {
                    type = NavigationState.Type.VIEW_OPTIONS_CHANGED;
                    break;
                }
                case SELECTION: {
                    type = NavigationState.Type.CONTENT_SELECTED;
                    break;
                }
                case MODEL: 
                case OPERATION_WITH_STRUCTURE_MODIFICATION: 
                case OPERATION_WITHOUT_STRUCTURE_MODIFICATION: 
                case REVEAL: {
                    type = NavigationState.Type.CONTENT_MODIFIED;
                    break;
                }
                case UNDO_REDO: 
                case RESTORE_STATE: 
                case DEPENDENCIES: {
                    assert (false) : "Unexpected trigger: " + String.valueOf(trigger);
                    break;
                }
                default: {
                    assert (false) : "Unhandled trigger: " + String.valueOf(trigger);
                    break;
                }
            }
        }
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.m_viewId, this.m_secondaryId, type);
        state.addViewData((IStateData)NavigationStateData.STATE, (Object)provider.createState(representation));
        state.addConstant((IStateData)NavigationStateData.PRESENTATION_MODE, (Enum)representation.getPresentationMode());
        state.addConstant((IStateData)NavigationStateData.LEVELIZATION_MODE, (Enum)representation.getSortMode());
        if (topMostNode != null) {
            state.addString((IStateData)NavigationStateData.TOP_MOST_NODE, ((ArchitecturalViewNode)topMostNode.getNode()).getRelativePath());
        }
        if (!representation.getFocus().isEmpty() && (isInitial || ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.FOCUS.equals((Object)trigger) || ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.UNDO_REDO.equals((Object)trigger))) {
            state.addViewData((IStateData)NavigationStateData.FOCUS, (Object)representation.getFocus().copy());
        }
        state.setDeadStateInfoProvider((NavigationState.IDeadStateInfoProvider)DeadStateInfoProvider.INSTANCE);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    private void updateNavigationStates(IArchitecturalViewProvider provider, List<NavigationState> navigationStates, NavigationState initialNavigationState, ExplorationViewRepresentation representation) {
        assert (provider != null) : "Parameter 'provider' of method 'updateNavigationStates' must not be null";
        assert (navigationStates != null && !navigationStates.isEmpty()) : "Parameter 'navigationStates' of method 'updateNavigationStates' must not be empty";
        assert (initialNavigationState != null) : "'initialNavigationState' of method 'handleModification' must not be null";
        assert (navigationStates.get(0) == initialNavigationState) : "Initial state is not the first in the list";
        assert (representation != null) : "Parameter 'representation' of method 'updateNavigationStates' must not be null";
        LOGGER.debug("Update navigation states for '" + String.valueOf(this.m_viewId) + "/" + this.m_secondaryId + "'");
        ArrayList<ArchitecturalViewState> explorationViewStates = new ArrayList<ArchitecturalViewState>(navigationStates.size());
        for (NavigationState nextNavigationState : navigationStates) {
            Object nextStateObject = nextNavigationState.getDataAsObject((IStateData)NavigationStateData.STATE);
            assert (nextStateObject != null && nextStateObject instanceof ArchitecturalViewState) : "Unexpected class in method 'handleModification': " + String.valueOf(nextStateObject);
            explorationViewStates.add((ArchitecturalViewState)nextStateObject);
        }
        List updatedExplorationViewStates = provider.updateStates(explorationViewStates, representation);
        assert (updatedExplorationViewStates != null && updatedExplorationViewStates.size() == explorationViewStates.size()) : "'updatedExplorationViewStates' of method 'handleModification' must have the same size as 'explorationViewStates'";
        int index = 0;
        for (ArchitecturalViewState nextExplorationViewState : updatedExplorationViewStates) {
            NavigationState nextNavigationState = navigationStates.get(index);
            nextNavigationState.addViewData((IStateData)NavigationStateData.STATE, (Object)nextExplorationViewState);
            Object focusObject = nextNavigationState.getDataAsObject((IStateData)NavigationStateData.FOCUS);
            if (focusObject != null) {
                assert (focusObject instanceof ExplorationViewFocus) : "Unexpected class in method 'handleModification': " + String.valueOf(focusObject);
                ExplorationViewFocus nextFocus = (ExplorationViewFocus)focusObject;
                ExplorationViewFocus updatedFocus = provider.updateFocus(nextFocus, representation);
                if (!updatedFocus.isEmpty()) {
                    nextNavigationState.addViewData((IStateData)NavigationStateData.FOCUS, (Object)updatedFocus);
                } else {
                    nextNavigationState.removeViewData((IStateData)NavigationStateData.FOCUS);
                    if (nextNavigationState.getType() == NavigationState.Type.CONTENT_FOCUSED) {
                        nextNavigationState.setType(NavigationState.Type.CONTENT_MODIFIED);
                    }
                }
            }
            ++index;
        }
        ViewNavigationManager viewNavigationManager = ViewNavigationManager.getInstance();
        NavigationState currentViewState = viewNavigationManager.getCurrentViewNavigationState(this.m_viewId, this.m_secondaryId);
        NavigationState currentState = viewNavigationManager.getCurrentNavigationState();
        NavigationState lastNotRemovedNavigationState = initialNavigationState;
        int i = 1;
        while (i < navigationStates.size()) {
            NavigationState nextNavigationState = navigationStates.get(i);
            if (nextNavigationState.equals((Object)lastNotRemovedNavigationState)) {
                if (nextNavigationState == currentViewState) {
                    viewNavigationManager.setCurrentViewNavigationState(lastNotRemovedNavigationState);
                }
                if (nextNavigationState == currentState) {
                    viewNavigationManager.setCurrentNavigationState(lastNotRemovedNavigationState);
                }
                viewNavigationManager.removeNavigationState(nextNavigationState);
            } else {
                lastNotRemovedNavigationState = nextNavigationState;
            }
            ++i;
        }
        LOGGER.debug("Update navigation states for '" + String.valueOf(this.m_viewId) + "/" + this.m_secondaryId + "' - done");
    }

    void handleModification(IArchitecturalViewProvider provider, ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger, DrawNodeFigure<ArchitecturalViewNode> topMostNode, boolean isInitial, ExplorationViewRepresentation representation) {
        assert (provider != null) : "Parameter 'provider' of method 'handleModification' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'handleModification' must not be null";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((isInitial ? "Creation '" : "Modification '") + representation.getPresentationName(false) + (String)(trigger == null ? "' [no trigger]" : "' [" + String.valueOf(trigger) + "]"));
        }
        boolean handled = true;
        if (ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.MODEL.equals((Object)trigger)) {
            assert (!isInitial) : "Unexpected trigger '" + String.valueOf(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.MODEL) + "' in 'Creation'";
            List navigationStates = ViewNavigationManager.getInstance().getViewNavigationStates(this.m_viewId, this.m_secondaryId);
            if (navigationStates != null && !navigationStates.isEmpty()) {
                NavigationState initialNavigationState = ViewNavigationManager.getInstance().getInitialViewNavigationState(this.m_viewId, this.m_secondaryId);
                if (initialNavigationState != null && navigationStates.get(0) == initialNavigationState) {
                    this.updateNavigationStates(provider, navigationStates, initialNavigationState, representation);
                } else {
                    LOGGER.error("Initial state not the first state in found states for '" + String.valueOf(this.m_viewId) + "/" + this.m_secondaryId + "' - resetting states and creating and adding an initial state");
                    ViewNavigationManager.getInstance().clear(this.m_viewId, this.m_secondaryId);
                    this.createAndAddNavigationState(provider, null, topMostNode, true, representation);
                }
            } else {
                LOGGER.error("No states found for '" + String.valueOf(this.m_viewId) + "/" + this.m_secondaryId + "' - resetting states and creating and adding an initial state");
                ViewNavigationManager.getInstance().clear(this.m_viewId, this.m_secondaryId);
                this.createAndAddNavigationState(provider, null, topMostNode, true, representation);
            }
        } else if (!(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.DEPENDENCIES.equals((Object)trigger) || ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.RESTORE_STATE.equals((Object)trigger) || ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.UNDO_REDO.equals((Object)trigger))) {
            this.createAndAddNavigationState(provider, trigger, topMostNode, isInitial, representation);
        } else {
            handled = false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((isInitial ? "Creation" : "Modification") + (handled ? " <handled> '" : " <ignored> '") + representation.getPresentationName(false) + (String)(trigger == null ? "' [no trigger]" : "' [" + String.valueOf(trigger) + "]") + " - done");
        }
    }

    private static enum NavigationStateData implements IStateData
    {
        STATE,
        PRESENTATION_MODE,
        LEVELIZATION_MODE,
        FOCUS,
        TOP_MOST_NODE;

    }
}

