/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactData;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNameOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.EditCreateArtifactOperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactFilterPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.EditArtifactOperationWizard;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SingleArtifactPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.Collections;

final class EditCreateArtifactOperationWizard
extends EditArtifactOperationWizard<EditCreateArtifactOperationInfo> {
    EditCreateArtifactOperationWizard(EditCreateArtifactOperationInfo info) {
        super(info);
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IArchitecturalViewProvider architecturalViewProvider = (IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        ArchitecturalViewArtifactOperationAvailability availability = architecturalViewProvider.isCreateArtifactPossible(Collections.singletonList(((EditCreateArtifactOperationInfo)this.getOperationInfo()).getTargetParent().getArchitecturalViewElement()));
        assert (availability != null) : "'availability' of method 'addPages' must not be null";
        assert (availability.isAvailable()) : "Operation not available";
        AssignableTargetInfo assignableTargetInfo = new AssignableTargetInfo(availability.getAssignableTarget(), ((EditCreateArtifactOperationInfo)this.getOperationInfo()).getOperation().getTargetPos());
        SingleArtifactPage artifactPage = new SingleArtifactPage(architecturalViewProvider.getArtifactNameValidator(assignableTargetInfo, null), (ArtifactNameOperation)((EditCreateArtifactOperationInfo)this.getOperationInfo()).getOperation(), "", availability.getIgnoreSubTrees(), null, ((EditCreateArtifactOperationInfo)this.getOperationInfo()).getRepresentation());
        this.addPage((SonargraphWizardPage)artifactPage);
        ArtifactFilterPage filterPage = new ArtifactFilterPage(provider.getSoftwareSystem().getUsedLanguages(), architecturalViewProvider, ((EditCreateArtifactOperationInfo)this.getOperationInfo()).getRepresentation(), ((EditCreateArtifactOperationInfo)this.getOperationInfo()).getFilter());
        this.addPage((SonargraphWizardPage)filterPage);
        artifactPage.setFilterPage(filterPage);
    }

    public boolean canFinish() {
        if (super.canFinish()) {
            ArtifactFilterPage artifactFilterPage = (ArtifactFilterPage)this.getPage(ArtifactFilterPage.NAME);
            assert (artifactFilterPage != null) : "'artifactFilterPage' of method 'canFinish' must not be null";
            if (artifactFilterPage.hasBeenEdited()) {
                return true;
            }
            SingleArtifactPage singleArtifactPage = (SingleArtifactPage)this.getPage(SingleArtifactPage.NAME);
            assert (singleArtifactPage != null) : "'singleArtifactPage' of method 'canFinish' must not be null";
            if (singleArtifactPage.hasBeenEdited()) {
                return true;
            }
        }
        return false;
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ArtifactFilterPage artifactFilterPage = (ArtifactFilterPage)this.getPage(ArtifactFilterPage.NAME);
            assert (artifactFilterPage != null) : "'artifactFilterPage' of method 'performFinish' must not be null";
            return artifactFilterPage.assureCanFinish();
        }
        return false;
    }

    void collectData(CreateArtifactData data) {
        assert (data != null) : "Parameter 'data' of method 'collectData' must not be null";
        SingleArtifactPage singleArtifactPage = (SingleArtifactPage)this.getPage(SingleArtifactPage.NAME);
        assert (singleArtifactPage != null) : "Parameter 'singleArtifactPage' of method 'collectData' must not be null";
        data.setTargetInfo(singleArtifactPage.getAssignableTargetInfo());
        data.setShortName(singleArtifactPage.getElementName());
        data.setProperties(singleArtifactPage.getArtifactProperties());
        ArtifactFilterPage artifactFilterPage = (ArtifactFilterPage)this.getPage(ArtifactFilterPage.NAME);
        assert (artifactFilterPage != null) : "'artifactFilterPage' of method 'collectData' must not be null";
        data.setFilter(artifactFilterPage.getEditedFilter());
    }
}

