/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.FigureBasedFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SecondaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import org.eclipse.swt.graphics.Color;

final class DropIndicator
extends FigureBasedFigure<SecondaryTreeNodeFigure> {
    private final DrawNodeFigure.DropPosition m_dropPosition;

    DropIndicator(ExplorationViewLayout layout, SecondaryTreeNodeFigure figure, DrawNodeFigure.DropPosition dropPosition) {
        super(layout, figure);
        assert (dropPosition != null) : "Parameter 'dropPosition' of method 'DropIndicator' must not be null";
        assert (!DrawNodeFigure.DropPosition.ON.equals((Object)dropPosition)) : "Unexpected drop position: " + String.valueOf(dropPosition);
        this.m_dropPosition = dropPosition;
    }

    public void postLayout(IFigure container) {
        SecondaryTreeNodeFigure figure = (SecondaryTreeNodeFigure)((Object)this.getBasedOnFigure());
        Rectangle bounds = new Rectangle(0, DrawNodeFigure.DropPosition.BEFORE.equals((Object)this.m_dropPosition) ? figure.getLocation().y - 1 : figure.getLocation().y + 16 + 1, this.getLayout().getFullWidth(), 3);
        this.setBounds(bounds);
    }

    protected final void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Color initialBgColor = graphics.getBackgroundColor();
        graphics.setBackgroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_GREY));
        graphics.fillRectangle(this.getBounds());
        graphics.setBackgroundColor(initialBgColor);
    }
}

