/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.DeleteElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ElementsData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperationType;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.Collection;
import java.util.List;

public final class DeleteElementsCommandAdapter
extends ArchitecturalViewCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.DELETE;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.DELETE_ARCHITECTURAL_VIEW_ELEMENTS;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        IArchitecturalViewProvider architecturalViewProvider;
        DeleteElementsOperationType type;
        List viewElements;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && !elements.isEmpty() && !(viewElements = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, elements)).isEmpty() && (type = (architecturalViewProvider = (IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isDeleteElementsPossible(viewElements)) != DeleteElementsOperationType.NONE) {
            ArchitecturalViewFile file = architecturalViewProvider.getArchitecturalViewFile((Collection)viewElements);
            assert (file != null) : "'file' of method 'applicable' must not be null";
            if (viewElements.size() == 1) {
                return new CompositeCommandAdapter.Applicable("Element In Architectural View [" + file.getIdentifyingPath() + "]", "Element");
            }
            return new CompositeCommandAdapter.Applicable("Elements In Architectural View [" + file.getIdentifyingPath() + "]", "Elements");
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
        final List viewElements = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, elements);
        assert (viewElements != null && !viewElements.isEmpty()) : "'viewElements' of method 'apply' must not be empty";
        DeleteElementsCommand command = new DeleteElementsCommand(provider, new DeleteElementsCommand.IDeleteElementsInteraction(){

            public boolean collect(ElementsData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setElements(viewElements);
                return true;
            }

            public void processDeleteElementsResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processDeleteElementsResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

