/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class CreateElementWizardPage
extends StandardWizardPage {
    static final String NAME = CoreDialogId.ARCHITECTURAL_VIEW_NEW_ELEMENT.getStandardName();
    private final RecursiveElementCreationInfo m_creationInfo;
    private ValidatingTextWidget m_validatingNameTextWidget;
    private String m_currentName;
    private boolean m_nameModified;

    private static String createTitle(RecursiveElementCreationInfo creationInfo) {
        assert (creationInfo != null) : "Parameter 'creationInfo' of method 'createTitle' must not be null";
        RecursiveElementRefactoringDescriptor descriptor = creationInfo.getValidator().getDescriptor();
        return "New " + descriptor.getLanguage().getPresentationName() + " " + descriptor.getPresentationName();
    }

    CreateElementWizardPage(RecursiveElementCreationInfo creationInfo) {
        super(NAME, CreateElementWizardPage.createTitle(creationInfo));
        assert (creationInfo != null) : "Parameter 'creationInfo' of method 'CreateElementWizardPage' must not be null";
        this.m_creationInfo = creationInfo;
    }

    protected final void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        Label rootElementLabel = new Label(composite, 0);
        rootElementLabel.setText("Underneath:");
        rootElementLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        CLabel rootElementInfo = new CLabel(composite, 0);
        rootElementInfo.setImage(UiResourceManager.getInstance().getImage((Element)this.m_creationInfo.getValidator().getRootNode()));
        rootElementInfo.setText(this.m_creationInfo.getValidator().getRootNode().getPresentationName(false));
        rootElementInfo.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name");
        nameLabel.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        this.m_validatingNameTextWidget = new ValidatingTextWidget(composite, (ITextValidator)this.m_creationInfo.getValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                CreateElementWizardPage.this.m_currentName = text;
                CreateElementWizardPage.this.m_nameModified = inputModified;
                CreateElementWizardPage.this.validate();
            }
        }, this.m_creationInfo.getNameProposal(), 0);
        this.m_validatingNameTextWidget.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.validate();
        }
        super.setVisible(visible);
        this.m_validatingNameTextWidget.setFocus();
    }

    protected final void validate() {
        boolean hasValidData = this.hasBeenDisposed() ? false : this.m_currentName != null && !this.m_currentName.isEmpty() && this.m_creationInfo.getValidator().isValid(this.m_currentName, this.m_currentName).isSuccess();
        this.setPageComplete(hasValidData);
    }

    protected int getNumberOfColumns() {
        return 3;
    }

    public boolean isNameModified() {
        return this.m_nameModified;
    }

    public String getElementName() {
        return this.m_currentName;
    }
}

