/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactFromElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactFromElementsData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactsForElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateArtifactsForElementsData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ICreateArtifactFromElementsInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ICreateArtifactInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ICreateArtifactsForElementsInteraction;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactCreationMode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactFilterPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactsWizard;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.MultipleArtifactsPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SingleArtifactPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;

public final class CreateArtifactsWizard
extends ArtifactsWizard {
    private final ArtifactCreationMode m_mode;
    private final List<ArchitecturalViewElement> m_elements;

    public CreateArtifactsWizard(ArtifactCreationMode mode, List<ArchitecturalViewElement> elements) {
        super(mode != null ? mode.getPresentationName() : "");
        assert (mode != null) : "Parameter 'mode' of method 'ArtifactCreationWizard' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'CreateArtifactsWizard' must not be empty";
        this.m_mode = mode;
        this.m_elements = elements;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IArchitecturalViewProvider architecturalViewProvider = (IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        ExplorationViewRepresentation representation = architecturalViewProvider.getArchitecturalViewRepresentation(this.m_elements);
        switch (this.m_mode) {
            case SINGLE: {
                ArchitecturalViewArtifactOperationAvailability availability = architecturalViewProvider.isCreateArtifactPossible(this.m_elements);
                assert (availability != null) : "'availability' of method 'addPages' must not be null";
                assert (availability.isAvailable()) : "Operation not available";
                AssignableTargetInfo assignableTargetInfo = new AssignableTargetInfo(availability.getAssignableTarget(), -1);
                SingleArtifactPage artifactPage = new SingleArtifactPage(architecturalViewProvider.getArtifactNameValidator(assignableTargetInfo, null), null, "", availability.getIgnoreSubTrees(), null, representation);
                this.addPage((SonargraphWizardPage)artifactPage);
                ArtifactFilterPage filterPage = new ArtifactFilterPage(provider.getSoftwareSystem().getUsedLanguages(), architecturalViewProvider, representation, new ArtifactNodeFilter(null));
                this.addPage((SonargraphWizardPage)filterPage);
                artifactPage.setFilterPage(filterPage);
                break;
            }
            case SINGLE_FROM_ELEMENTS: {
                ArchitecturalViewArtifactOperationAvailability availability = architecturalViewProvider.isCreateArtifactFromElementsPossible(this.m_elements);
                assert (availability != null) : "'availability' of method 'addPages' must not be null";
                assert (availability.isAvailable()) : "Operation n ot available";
                AssignableTargetInfo assignableTargetInfo = new AssignableTargetInfo(availability.getAssignableTarget(), -1);
                String nameProposal = architecturalViewProvider.getNameProposalForCreateArtifactFromElements(availability.getAssignableTarget(), this.m_elements);
                PartialAlternativeInfo alternativeInfo = architecturalViewProvider.calculatePartialCreateArtifactFromElementsAlternative(this.m_elements);
                this.addPage((SonargraphWizardPage)new SingleArtifactPage(architecturalViewProvider.getArtifactFromElementsNameValidator(assignableTargetInfo, this.m_elements), null, nameProposal, availability.getIgnoreSubTrees(), alternativeInfo, representation));
                break;
            }
            case MULTIPLE_FOR_ELEMENTS: {
                ArchitecturalViewArtifactOperationAvailability availability = architecturalViewProvider.isCreateArtifactsForElementsPossible(this.m_elements);
                assert (availability != null) : "'availability' of method 'addPages' must not be null";
                assert (availability.isAvailable()) : "Operation n ot available";
                PartialAlternativeInfo alternativeInfo = architecturalViewProvider.calculatePartialCreateArtifactsForElementsAlternative(this.m_elements);
                this.addPage((SonargraphWizardPage)new MultipleArtifactsPage(architecturalViewProvider, null, new AssignableTargetInfo(availability.getAssignableTarget(), -1), availability.getIgnoreSubTrees(), alternativeInfo, representation));
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
                break;
            }
        }
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            switch (this.m_mode) {
                case SINGLE: {
                    ArtifactFilterPage editFilterPage = (ArtifactFilterPage)this.getPage(ArtifactFilterPage.NAME);
                    assert (editFilterPage != null) : "'editFilterPage' of method 'canFinish' must not be null";
                    if (!editFilterPage.assureCanFinish()) {
                        return false;
                    }
                    UserInterfaceAdapter.getInstance().run((Command)new CreateArtifactCommand(provider, (ICreateArtifactInteraction)new CreateSingleArtifactInteraction()));
                    return true;
                }
                case SINGLE_FROM_ELEMENTS: {
                    UserInterfaceAdapter.getInstance().run((Command)new CreateArtifactFromElementsCommand(provider, (ICreateArtifactFromElementsInteraction)new CreateSingleArtifactFromElementsInteraction()));
                    return true;
                }
                case MULTIPLE_FOR_ELEMENTS: {
                    UserInterfaceAdapter.getInstance().run((Command)new CreateArtifactsForElementsCommand(provider, (ICreateArtifactsForElementsInteraction)new CreateMultipleArtifactsForElementsInteraction()));
                    return true;
                }
            }
            assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
        }
        return false;
    }

    final class CreateMultipleArtifactsForElementsInteraction
    implements ICreateArtifactsForElementsInteraction {
        CreateMultipleArtifactsForElementsInteraction() {
        }

        public boolean collect(CreateArtifactsForElementsData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            MultipleArtifactsPage page = (MultipleArtifactsPage)CreateArtifactsWizard.this.getPage(MultipleArtifactsPage.NAME);
            assert (page != null) : "'page' of method 'collect' must not be null";
            data.setTargetInfo(page.getAssignableTargetInfo());
            data.setProperties(page.getArtifactProperties());
            List<? extends ArchitecturalViewElement> elements = page.getPartialAlternative();
            if (elements != null) {
                data.setElements(elements);
            } else {
                data.setElements(CreateArtifactsWizard.this.m_elements);
            }
            return true;
        }

        public void processCreateArtifactsForElementsResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processCreateArtifactResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    final class CreateSingleArtifactFromElementsInteraction
    implements ICreateArtifactFromElementsInteraction {
        CreateSingleArtifactFromElementsInteraction() {
        }

        public boolean collect(CreateArtifactFromElementsData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            SingleArtifactPage page = (SingleArtifactPage)CreateArtifactsWizard.this.getPage(SingleArtifactPage.NAME);
            assert (page != null) : "'page' of method 'collect' must not be null";
            data.setTargetInfo(page.getAssignableTargetInfo());
            data.setShortName(page.getElementName());
            data.setProperties(page.getArtifactProperties());
            List<? extends ArchitecturalViewElement> elements = page.getPartialAlternative();
            if (elements != null) {
                data.setElements(elements);
            } else {
                data.setElements(CreateArtifactsWizard.this.m_elements);
            }
            return true;
        }

        public void processCreateArtifactFromElementsResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processCreateArtifactResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    final class CreateSingleArtifactInteraction
    implements ICreateArtifactInteraction {
        CreateSingleArtifactInteraction() {
        }

        public boolean collect(CreateArtifactData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            SingleArtifactPage page = (SingleArtifactPage)CreateArtifactsWizard.this.getPage(SingleArtifactPage.NAME);
            assert (page != null) : "Parameter 'page' of method 'collect' must not be null";
            data.setTargetInfo(page.getAssignableTargetInfo());
            data.setShortName(page.getElementName());
            data.setProperties(page.getArtifactProperties());
            ArtifactFilterPage filterPage = (ArtifactFilterPage)CreateArtifactsWizard.this.getPage(ArtifactFilterPage.NAME);
            assert (filterPage != null) : "'filterPage' of method 'collect' must not be null";
            data.setFilter(filterPage.getEditedFilter());
            return true;
        }

        public void processCreateArtifactResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processCreateArtifactResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

