/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.system.architecturalview.ApplyFocusOperationCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.CreateElementCommand;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IRecursiveElementCreationValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewWizard;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.CreateElementWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.FocusDialog;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.Collections;
import java.util.List;

public final class CreateArchitecturalViewElementWizard
extends ArchitecturalViewWizard {
    private final RecursiveElementCreationInfo m_creationInfo;

    public CreateArchitecturalViewElementWizard(RecursiveElementCreationInfo creationInfo) {
        super("Create Element");
        assert (creationInfo != null) : "Parameter 'creationInfo' of method 'CreateArchitecturalViewElementWizard' must not be null";
        this.m_creationInfo = creationInfo;
    }

    public int getPreferredWidth() {
        return 150;
    }

    public int getPreferredHeight() {
        return 150;
    }

    public int getMinimumWidth() {
        return 150;
    }

    public int getMinimumHeight() {
        return 150;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        this.addPage((SonargraphWizardPage)new CreateElementWizardPage(this.m_creationInfo));
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            final ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No system available";
            final CreateElementWizardPage page = (CreateElementWizardPage)this.getPage(CreateElementWizardPage.NAME);
            assert (page != null) : "'page' of method 'performFinish' must not be null";
            CreateElementCommand command = null;
            IRecursiveElementCreationValidator.Action action = this.m_creationInfo.getValidator().getAction();
            switch (action) {
                case CREATE_ELEMENT: {
                    command = new CreateElementCommand(provider, new CreateElementCommand.ICreateElementInteraction(){

                        public boolean collect(CreateElementCommand.CreateElementData data) {
                            if (!$assertionsDisabled && data == null) {
                                throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                            }
                            data.setCreationInfo(CreateArchitecturalViewElementWizard.this.m_creationInfo);
                            data.setName(page.getElementName());
                            return true;
                        }

                        public void processCreateElementResult(OperationResult result) {
                            if (!$assertionsDisabled && result == null) {
                                throw new AssertionError((Object)"Parameter 'result' of method 'processCreateElementResult' must not be null");
                            }
                            UserInterfaceAdapter.getInstance().process(result);
                        }
                    });
                    break;
                }
                case MODIFY_FOCUS: {
                    command = new ApplyFocusOperationCommand(provider, new ApplyFocusOperationCommand.IApplyFocusOperationInteraction(){

                        public boolean collect(final ExplorationViewFocusProperties properties) {
                            if (!$assertionsDisabled && properties == null) {
                                throw new AssertionError((Object)"Parameter 'properties' of method 'collect' must not be null");
                            }
                            RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                                public void run() {
                                    FocusDialog dialog = new FocusDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), properties);
                                    if (dialog.open() == 0) {
                                        this.setResult(Boolean.TRUE);
                                    } else {
                                        this.setResult(Boolean.FALSE);
                                    }
                                }
                            };
                            UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                            return (Boolean)runnable.getResult();
                        }

                        public boolean collect(ApplyFocusOperationCommand.FocusOperationtData data) {
                            if (!$assertionsDisabled && data == null) {
                                throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                            }
                            List<ArchitecturalViewNode> nodes = Collections.singletonList(CreateArchitecturalViewElementWizard.this.m_creationInfo.getValidator().getNodeForAction());
                            data.set(ExplorationViewFocusProperties.FocusType.ADD_TO_FOCUS, new ExplorationViewFocusRequest(((IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getArchitecturalViewRepresentation(nodes), nodes, Collections.emptyList()));
                            return true;
                        }

                        public void processApplyResult(OperationResult result) {
                            if (!$assertionsDisabled && result == null) {
                                throw new AssertionError((Object)"Parameter 'res' of method 'processApplyResult' must not be null");
                            }
                            UserInterfaceAdapter.getInstance().process(result);
                        }
                    });
                    break;
                }
                case NONE: {
                    assert (false) : "Unexpected action: " + String.valueOf(action);
                    break;
                }
                default: {
                    assert (false) : "Unhandled action: " + String.valueOf(action);
                    break;
                }
            }
            assert (command != null) : "Parameter 'command' of method 'performFinish' must not be null";
            UserInterfaceAdapter.getInstance().run(command);
            return true;
        }
        return false;
    }
}

