/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewWizardAdapter;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArtifactCreationMode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.CreateArtifactsWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;

abstract class ArtifactWizardAdapter
extends ArchitecturalViewWizardAdapter {
    protected ArtifactWizardAdapter() {
    }

    public final String getImageResource() {
        return "CreateArtifact";
    }

    protected abstract ArtifactCreationMode getMode();

    public final String getName() {
        return this.getMode().getPresentationName();
    }

    public final boolean isAvailable() {
        switch (this.getMode()) {
            case SINGLE: {
                return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_ARCHITECTURAL_VIEW_ARTIFACT);
            }
            case SINGLE_FROM_ELEMENTS: {
                return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_ARCHITECTURAL_VIEW_ARTIFACT_FROM_ELEMENTS);
            }
            case MULTIPLE_FOR_ELEMENTS: {
                return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_ARCHITECTURAL_VIEW_ARTIFACTS_FOR_ELEMENTS);
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)this.getMode());
        return false;
    }

    public final boolean isEnabled(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'isEnabled' must not be null";
        assert (selected != null) : "Parameter 'selected ' of method 'isEnabled' must not be null";
        if (this.isAvailable() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED})) {
            IArchitecturalViewProvider architecturalViewProvider = (IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
            List elements = CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, selected);
            if (!elements.isEmpty()) {
                switch (this.getMode()) {
                    case SINGLE: {
                        ArchitecturalViewArtifactOperationAvailability single = architecturalViewProvider.isCreateArtifactPossible(elements);
                        return single != null && single.isAvailable();
                    }
                    case SINGLE_FROM_ELEMENTS: {
                        ArchitecturalViewArtifactOperationAvailability singleFromElements = architecturalViewProvider.isCreateArtifactFromElementsPossible(elements);
                        return singleFromElements != null && singleFromElements.isAvailable();
                    }
                    case MULTIPLE_FOR_ELEMENTS: {
                        ArchitecturalViewArtifactOperationAvailability multipleForElements = architecturalViewProvider.isCreateArtifactsForElementsPossible(elements);
                        return multipleForElements != null && multipleForElements.isAvailable();
                    }
                }
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.getMode());
            }
        }
        return false;
    }

    public final SonargraphWizard create(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'create' must not be null";
        assert (selected != null && !selected.isEmpty()) : "Parameter 'selected' of method 'create' must not be empty";
        return new CreateArtifactsWizard(this.getMode(), CommandHandler.getMultipleSelectionIfAllAreAssignable(ArchitecturalViewElement.class, selected));
    }
}

