/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.LayoutListener;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.MoveElementsCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.SelectAllCommand;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.CycleGroupSeparator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.CycleIndicator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.DropIndicator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.DropTargetNodeBox;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExpandCollapseModification;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExpandedNodeBox;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.GestureHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.HorizontalSeparatorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.LevelSeparator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.NavigationStateHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PartialAlternativeInfoComposite;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PrimaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SecondaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigureAnchor;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigureRouter;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvas;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ElementInteractor;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitecturalViewFigureProvider
implements DrawNodeFigure.INodeFigureProvider<ArchitecturalViewNode>,
DrawConnectionFigure.IConnectionFigureProvider<ArchitecturalViewNode.ArchitecturalViewDependency>,
DrawNodeAndConnectionFigureCanvas.IListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewFigureProvider.class);
    private final Map<SecondaryTreeNodeFigure, ExpandedNodeBox> m_figureToExpandedNodeBox = new THashMap();
    private final Map<PrimaryTreeNodeFigure, HorizontalSeparatorFigure> m_figureToHorizontalSeparator = new THashMap();
    private final Map<PrimaryTreeNodeFigure, CycleIndicator> m_figureToCycleIndicator = new THashMap();
    private final ElementInteractor m_elementInteractor;
    private final ISoftwareSystemProvider m_softwareSystemProvider;
    private final IArchitecturalViewProvider m_architecturalViewProvider;
    private final DrawNodeAndConnectionFigureCanvas<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency, ExplorationViewLayout> m_canvas;
    private final ExplorationViewRepresentation m_representation;
    private final NavigationStateHandler m_stateHandler;
    private final GestureHandler m_gestureHandler;
    private DropTargetNodeBox m_dropTargetNodeBox;
    private DropIndicator m_dropIndicator;
    private boolean m_autoExpand;

    private static int createRecursively(DrawNodeAndConnectionFigureCanvas<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency, ExplorationViewLayout> canvas, DrawNodeFigure.INodeFigureProvider<ArchitecturalViewNode> connector, List<ArchitecturalViewNode> currentNodes, int currentIndex, Map<ArchitecturalViewNode, PrimaryTreeNodeFigure> nodeToNodeFigure) {
        assert (canvas != null) : "Parameter 'canvas' of method 'createRecursively' must not be null";
        assert (connector != null) : "Parameter 'connector' of method 'createRecursively' must not be null";
        assert (currentNodes != null) : "Parameter 'currentNodes' of method 'createRecursively' must not be null";
        assert (nodeToNodeFigure != null) : "Parameter 'nodeToNodeFigure' of method 'createRecursively' must not be null";
        int index = currentIndex;
        for (ArchitecturalViewNode nextNode : currentNodes) {
            SecondaryTreeNodeFigure nextSecondaryTreeNode = new SecondaryTreeNodeFigure(nextNode, connector, index);
            PrimaryTreeNodeFigure nextPrimaryTreeNode = new PrimaryTreeNodeFigure(nextNode, connector, nextSecondaryTreeNode);
            canvas.addNodeFigure((DrawNodeFigure)nextPrimaryTreeNode);
            canvas.addNodeFigure((DrawNodeFigure)nextSecondaryTreeNode);
            nodeToNodeFigure.put(nextNode, nextPrimaryTreeNode);
            ++index;
            if (!nextNode.isExpanded()) continue;
            index = ArchitecturalViewFigureProvider.createRecursively(canvas, connector, nextNode.getSortedVisibleNodeChildren(), index, nodeToNodeFigure);
        }
        return index;
    }

    ArchitecturalViewFigureProvider(IViewId viewId, String secondaryId, ElementInteractor elementInteractor, SelectionProviderAdapter selectionProviderAdapter, ISoftwareSystemProvider softwareSystemProvider, DrawNodeAndConnectionFigureCanvas<ArchitecturalViewNode, ArchitecturalViewNode.ArchitecturalViewDependency, ExplorationViewLayout> figureWidget, ExplorationViewRepresentation representation, ArchitecturalViewNode reveal) {
        PrimaryTreeNodeFigure primaryTreeNodeFigureToReveal;
        assert (viewId != null) : "Parameter 'viewId' of method 'ArchitecturalViewFigureProvider' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'ArchitecturalViewFigureProvider' must not be empty";
        assert (elementInteractor != null) : "Parameter 'elementInteractor' of method 'ArchitecturalViewFigureProvider' must not be null";
        assert (selectionProviderAdapter != null) : "Parameter 'selectionProviderAdapter' of method 'ArchitecturalViewFigureProvider' must not be null";
        assert (softwareSystemProvider.hasSoftwareSystem()) : "No system available";
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'ArchitecturalViewFigureProvider' must not be null";
        assert (figureWidget != null) : "Parameter 'figureWidget' of method 'ArchitecturalViewFigureProvider' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ArchitecturalViewFigureProvider' must not be null";
        this.m_elementInteractor = elementInteractor;
        this.m_softwareSystemProvider = softwareSystemProvider;
        this.m_architecturalViewProvider = (IArchitecturalViewProvider)this.m_softwareSystemProvider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        this.m_canvas = figureWidget;
        this.m_representation = representation;
        this.m_stateHandler = new NavigationStateHandler(viewId, secondaryId);
        LinkedHashMap<ArchitecturalViewNode, PrimaryTreeNodeFigure> nodeToNodeFigure = new LinkedHashMap<ArchitecturalViewNode, PrimaryTreeNodeFigure>();
        ArchitecturalViewFigureProvider.createRecursively(this.m_canvas, this, this.m_representation.getSortedVisibleNodeChildren(), 0, nodeToNodeFigure);
        TreeEdgeFigureRouter treeEdgeFigureRouter = ((ExplorationViewLayout)this.m_canvas.getCanvasLayout()).getEdgeFigureRouter();
        ArrayList<SecondaryTreeNodeFigure> selectedNodes = new ArrayList<SecondaryTreeNodeFigure>();
        ArrayList<TreeEdgeFigure> selectedDependencies = new ArrayList<TreeEdgeFigure>();
        ArchitecturalViewNode previousNode = null;
        for (PrimaryTreeNodeFigure nextFromPrimaryTreeNodeFigure : nodeToNodeFigure.values()) {
            ArchitecturalViewNode nextFromNode = (ArchitecturalViewNode)nextFromPrimaryTreeNodeFigure.getNode();
            SecondaryTreeNodeFigure nextFromSecondaryTreeNodeFigure = nextFromPrimaryTreeNodeFigure.getSecondaryTreeNode();
            for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : nextFromNode.getOutgoingDependencies()) {
                SecondaryTreeNodeFigure nextToSecondaryTreeNodeFigure;
                ArchitecturalViewNode nextToNode = nextOut.getTo();
                PrimaryTreeNodeFigure nextToPrimaryTreeNodeFigure = (PrimaryTreeNodeFigure)((Object)nodeToNodeFigure.get(nextToNode));
                SecondaryTreeNodeFigure secondaryTreeNodeFigure = nextToSecondaryTreeNodeFigure = nextToPrimaryTreeNodeFigure != null ? nextToPrimaryTreeNodeFigure.getSecondaryTreeNode() : null;
                if (nextToSecondaryTreeNodeFigure != null) {
                    assert (nextToSecondaryTreeNodeFigure != null) : "'nextToMapped' of method 'createRepresentation' must not be null for '" + nextToNode.getName() + "' (" + nextToNode.getClass().getSimpleName() + ") used from '" + nextFromNode.getName() + "' (" + nextFromNode.getClass().getSimpleName() + ")";
                    TreeEdgeFigure nextTreeEdgeFigure = new TreeEdgeFigure(nextOut, this, new TreeEdgeFigureAnchor(nextFromSecondaryTreeNodeFigure), new TreeEdgeFigureAnchor(nextToSecondaryTreeNodeFigure), treeEdgeFigureRouter);
                    this.m_canvas.addConnectionFigure((DrawConnectionFigure)nextTreeEdgeFigure);
                    if (!nextOut.isSelected()) continue;
                    selectedDependencies.add(nextTreeEdgeFigure);
                    continue;
                }
                LOGGER.error("'nextToMapped' of method 'createRepresentation' must not be null for '" + nextToNode.getName() + "' (" + nextToNode.getClass().getSimpleName() + ") used from '" + nextFromNode.getName() + "' (" + nextFromNode.getClass().getSimpleName() + ")");
            }
            if (nextFromNode.isExpanded()) {
                this.createExpandedNodeBox(nextFromSecondaryTreeNodeFigure);
            }
            this.createCycleInfoDecorations(previousNode, nextFromNode, nextFromPrimaryTreeNodeFigure);
            previousNode = nextFromNode;
            if (!nextFromNode.isSelected()) continue;
            selectedNodes.add(nextFromSecondaryTreeNodeFigure);
        }
        this.m_gestureHandler = new GestureHandler(this.m_canvas, selectionProviderAdapter, this.m_representation);
        boolean updateSelectionState = false;
        if (!selectedNodes.isEmpty()) {
            this.m_gestureHandler.selectNodes(selectedNodes, false);
            updateSelectionState = true;
        }
        if (!selectedDependencies.isEmpty()) {
            this.m_gestureHandler.selectEdges(selectedDependencies, false);
            updateSelectionState = true;
        }
        if (updateSelectionState) {
            this.m_gestureHandler.updateSelectionState();
        }
        this.m_canvas.forceUpdate();
        if (reveal != null && (primaryTreeNodeFigureToReveal = (PrimaryTreeNodeFigure)((Object)nodeToNodeFigure.get(reveal))) != null) {
            this.m_canvas.setTopMostVisibleNode((DrawNodeFigure)primaryTreeNodeFigureToReveal);
        }
        this.m_canvas.setListener((DrawNodeAndConnectionFigureCanvas.IListener)this);
        selectionProviderAdapter.handleSelectionChanged(this.m_gestureHandler.getSelectedElements());
    }

    ExplorationViewRepresentation getRepresentation() {
        return this.m_representation;
    }

    boolean enableAutoExpand(boolean enable) {
        if (enable != this.m_autoExpand) {
            this.m_autoExpand = enable;
            return true;
        }
        return false;
    }

    static void completeInitialState(NavigationState state, PresentationMode presentationMode, ExplorationViewSortMode levelizationMode) {
        assert (state != null) : "Parameter 'state' of method 'completeInitialState' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'completeInitialState' must not be null";
        assert (levelizationMode != null) : "Parameter 'levelizationMode' of method 'completeInitialState' must not be null";
        NavigationStateHandler.completeInitialState(state, presentationMode, levelizationMode);
    }

    void completeState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeInitialState' must not be null";
        NavigationStateHandler.completeState(this.m_architecturalViewProvider, state, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), this.m_representation);
    }

    void restoreState(NavigationState state) {
        this.m_stateHandler.restoreState(this.m_architecturalViewProvider, state, this.m_representation);
    }

    boolean isHomePossible() {
        return this.m_stateHandler.isHomePossible();
    }

    void home() {
        this.m_stateHandler.home(this.m_architecturalViewProvider, this.m_representation);
    }

    void handleModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger, boolean isInitial) {
        this.m_stateHandler.handleModification(this.m_architecturalViewProvider, trigger, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), isInitial, this.m_representation);
    }

    void update(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger) {
        this.m_gestureHandler.clearSelection(false);
        this.m_canvas.updateFromModel();
        this.m_gestureHandler.updateSelectionState();
        this.m_stateHandler.handleModification(this.m_architecturalViewProvider, trigger, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
    }

    public void aboutToUpdate(DrawNodeFigure<ArchitecturalViewNode> nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'aboutToUpdate' must not be null";
        if (((ArchitecturalViewNode)nodeFigure.getNode()).isSelected() && nodeFigure instanceof SecondaryTreeNodeFigure) {
            this.m_gestureHandler.selectNodes(Collections.singletonList((SecondaryTreeNodeFigure)nodeFigure), false);
        }
    }

    public void aboutToUpdate(DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency> edgeFigure) {
        assert (edgeFigure != null && edgeFigure instanceof TreeEdgeFigure) : "Unexpected class in method 'aboutToUpdate': " + String.valueOf(edgeFigure);
        if (((ArchitecturalViewNode.ArchitecturalViewDependency)edgeFigure.getConnection()).isSelected()) {
            this.m_gestureHandler.selectEdges(Collections.singletonList((TreeEdgeFigure)edgeFigure), false);
        }
    }

    private SecondaryTreeNodeFigure getSecondaryTreeNodeFigure(DrawNodeFigure<ArchitecturalViewNode> nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'getSecondaryTreeNodeFigure' must not be null";
        if (nodeFigure instanceof PrimaryTreeNodeFigure) {
            return ((PrimaryTreeNodeFigure)nodeFigure).getSecondaryTreeNode();
        }
        assert (nodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'getSecondaryTreeNodeFigure': " + String.valueOf(nodeFigure);
        return (SecondaryTreeNodeFigure)nodeFigure;
    }

    public void clicked(DrawNodeFigure<ArchitecturalViewNode> nodeFigure, DrawModifier modifier, IFigure source) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'select' must not be null";
        assert (modifier != null) : "Parameter 'modifier' of method 'clicked' must not be null";
        SecondaryTreeNodeFigure secondaryTreeNode = this.getSecondaryTreeNodeFigure(nodeFigure);
        switch (modifier) {
            case NONE: {
                if (((ArchitecturalViewNode)secondaryTreeNode.getNode()).isSelected()) {
                    return;
                }
                this.m_gestureHandler.handleNonShiftBasedNodeClick(secondaryTreeNode, false);
                break;
            }
            case PRIMARY: {
                this.m_gestureHandler.handleNonShiftBasedNodeClick(secondaryTreeNode, true);
                break;
            }
            case SHIFT: {
                this.m_gestureHandler.handleShiftNodeClick(secondaryTreeNode);
                break;
            }
            default: {
                assert (false) : "Unhandled modifier: " + String.valueOf(modifier);
                break;
            }
        }
        this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
    }

    public void clickFinished(DrawNodeFigure<ArchitecturalViewNode> nodeFigure, DrawModifier modifier, IFigure source) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'clickFinished' must not be null";
        assert (modifier != null) : "Parameter 'modifier' of method 'clickFinished' must not be null";
        switch (modifier) {
            case NONE: {
                SecondaryTreeNodeFigure secondaryTreeNode = this.getSecondaryTreeNodeFigure(nodeFigure);
                if (!((ArchitecturalViewNode)secondaryTreeNode.getNode()).isSelected() || this.m_gestureHandler.getNumberOfSelectedNodes() <= 1) break;
                this.m_gestureHandler.handleNonShiftBasedNodeClick(secondaryTreeNode, false);
                this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
                break;
            }
            case PRIMARY: 
            case SHIFT: {
                break;
            }
            default: {
                assert (false) : "Unhandled modifier: " + String.valueOf(modifier);
                break;
            }
        }
    }

    private void createEdgeFigures(ArchitecturalViewNode node, SecondaryTreeNodeFigure secondaryTreeNodeFigure, Map<ArchitecturalViewNode, SecondaryTreeNodeFigure> elementToSecondaryTreeNodeFigure, TreeEdgeFigureRouter treeEdgeFigureRouter) {
        TreeEdgeFigure nextTreeEdgeFigure;
        assert (node != null) : "Parameter 'node' of method 'createEdgeFigures' must not be null";
        assert (secondaryTreeNodeFigure != null) : "Parameter 'secondaryTreeNodeFigure' of method 'createEdgeFigures' must not be null";
        assert (elementToSecondaryTreeNodeFigure != null) : "Parameter 'elementToSecondaryTreeNodeFigure' of method 'createEdgeFigures' must not be null";
        assert (treeEdgeFigureRouter != null) : "Parameter 'treeEdgeFigureRouter' of method 'createEdgeFigures' must not be null";
        for (ArchitecturalViewNode.ArchitecturalViewDependency nextIn : node.getIncomingDependencies()) {
            ArchitecturalViewNode nextFromElement = nextIn.getFrom();
            SecondaryTreeNodeFigure nextFromNodeFigure = elementToSecondaryTreeNodeFigure.get(nextFromElement);
            assert (nextFromNodeFigure != null) : "'nextFromNodeFigure' of method 'createEdgeFigures' must not be null: " + nextFromElement.getName();
            nextTreeEdgeFigure = new TreeEdgeFigure(nextIn, this, new TreeEdgeFigureAnchor(nextFromNodeFigure), new TreeEdgeFigureAnchor(secondaryTreeNodeFigure), treeEdgeFigureRouter);
            this.m_canvas.addConnectionFigure((DrawConnectionFigure)nextTreeEdgeFigure);
        }
        for (ArchitecturalViewNode.ArchitecturalViewDependency nextOut : node.getOutgoingDependencies()) {
            ArchitecturalViewNode nextToElement = nextOut.getTo();
            SecondaryTreeNodeFigure nextToNodeFigure = elementToSecondaryTreeNodeFigure.get(nextToElement);
            assert (nextToNodeFigure != null) : "'nextToNode' of method 'createEdgeFigures' must not be null: " + nextToElement.getName();
            nextTreeEdgeFigure = new TreeEdgeFigure(nextOut, this, new TreeEdgeFigureAnchor(secondaryTreeNodeFigure), new TreeEdgeFigureAnchor(nextToNodeFigure), treeEdgeFigureRouter);
            this.m_canvas.addConnectionFigure((DrawConnectionFigure)nextTreeEdgeFigure);
        }
    }

    private void removeInvalidEdgeFigures() {
        for (DrawConnectionFigure nextEdgeFigure : this.m_canvas.getConnectionFigures()) {
            if (((ArchitecturalViewNode.ArchitecturalViewDependency)nextEdgeFigure.getConnection()).isValid()) continue;
            this.m_canvas.removeConnectionFigure(nextEdgeFigure);
            assert (nextEdgeFigure instanceof TreeEdgeFigure) : "Unexpected class in method 'removeInvalidEdgeFigures': " + String.valueOf(nextEdgeFigure);
            this.m_gestureHandler.clearEdgeSelection((TreeEdgeFigure)nextEdgeFigure);
        }
    }

    private void expand(SecondaryTreeNodeFigure nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'expand' must not be null";
        this.m_gestureHandler.aboutToExpandOrCollapse();
        this.m_canvas.setRedraw(false);
        int index = nodeFigure.getIndex();
        List children = this.m_architecturalViewProvider.expand((ArchitecturalViewNode)nodeFigure.getNode(), this.m_autoExpand, this.m_representation);
        ExpandCollapseModification modification = new ExpandCollapseModification();
        modification.add(children, index + 1);
        modification.update(index);
        this.update(modification);
        this.m_gestureHandler.updateSelectionState();
        this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
        this.m_canvas.setRedraw(true);
        this.m_canvas.forceUpdate();
    }

    public void expand(DrawNodeFigure<ArchitecturalViewNode> nodeFigure) {
        assert (nodeFigure != null && nodeFigure instanceof PrimaryTreeNodeFigure) : "Unexpected class in method 'expand': " + String.valueOf(nodeFigure);
        this.expand(((PrimaryTreeNodeFigure)nodeFigure).getSecondaryTreeNode());
    }

    private void collapse(SecondaryTreeNodeFigure nodeFigure) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'collapse' must not be null";
        this.m_gestureHandler.aboutToExpandOrCollapse();
        this.m_canvas.setRedraw(false);
        int index = nodeFigure.getIndex();
        int nodesToRemove = this.m_architecturalViewProvider.collapse((ArchitecturalViewNode)nodeFigure.getNode(), this.m_representation);
        int fromIndex = index + 1;
        int toIndex = index + nodesToRemove;
        ExpandCollapseModification modification = new ExpandCollapseModification();
        modification.remove(fromIndex, toIndex);
        modification.update(index);
        this.update(modification);
        this.m_gestureHandler.updateSelectionState();
        this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
        this.m_canvas.setRedraw(true);
        this.m_canvas.forceUpdate();
    }

    public void collapse(DrawNodeFigure<ArchitecturalViewNode> nodeFigure) {
        assert (nodeFigure != null && nodeFigure instanceof PrimaryTreeNodeFigure) : "Unexpected class in method 'collapse': " + String.valueOf(nodeFigure);
        this.collapse(((PrimaryTreeNodeFigure)nodeFigure).getSecondaryTreeNode());
    }

    private void createExpandedNodeBox(SecondaryTreeNodeFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'createExpandedNodeBox' must not be null";
        ExpandedNodeBox box = new ExpandedNodeBox((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), figure);
        this.m_canvas.addLayoutListener((LayoutListener)box);
        this.m_figureToExpandedNodeBox.put(figure, box);
        this.m_canvas.addToBasementLayer((IFigure)box);
    }

    private void removeExpandedNodeBox(SecondaryTreeNodeFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'removeExpandedNodeBox' must not be null";
        ExpandedNodeBox box = this.m_figureToExpandedNodeBox.remove((Object)figure);
        if (box != null) {
            this.m_canvas.removeFromBasementLayer((IFigure)box);
        }
    }

    private void createCycleInfoDecorations(ArchitecturalViewNode previous, ArchitecturalViewNode current, PrimaryTreeNodeFigure figure) {
        int currentDepth;
        int previousDepth;
        assert (current != null) : "Parameter 'current' of method 'createCycleInfoDecorations' must not be null";
        assert (figure != null) : "Parameter 'figure' of method 'createCycleInfoDecorations' must not be null";
        int currentCycleIndex = current.getCycleIndex();
        if (currentCycleIndex != -1) {
            CycleIndicator box = new CycleIndicator((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), figure, currentCycleIndex);
            this.m_canvas.addLayoutListener((LayoutListener)box);
            this.m_figureToCycleIndicator.put(figure, box);
            this.m_canvas.addToSecondFloorLayer((IFigure)box);
        }
        if (previous != null && (previousDepth = previous.getDepth()) >= (currentDepth = current.getDepth())) {
            ArchitecturalViewNode relevantPrevious = previous;
            if (previousDepth > currentDepth) {
                ArchitecturalViewNode currentPreviousParent = previous.getNodeParent();
                while (currentPreviousParent != null) {
                    if (currentPreviousParent.getDepth() == currentDepth) {
                        relevantPrevious = currentPreviousParent;
                        currentPreviousParent = null;
                        continue;
                    }
                    currentPreviousParent = currentPreviousParent.getNodeParent();
                }
            }
            assert (relevantPrevious != null) : "'relevantPrevious' of method 'createSeperatorIfNecessary' must not be null";
            if (relevantPrevious.getLevel() != current.getLevel()) {
                separator = new LevelSeparator((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), figure);
                this.m_canvas.addLayoutListener((LayoutListener)separator);
                this.m_figureToHorizontalSeparator.put(figure, separator);
                this.m_canvas.addToAtticLayer((IFigure)separator);
            } else if (relevantPrevious.getCycleIndex() != currentCycleIndex) {
                separator = new CycleGroupSeparator((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), figure);
                this.m_canvas.addLayoutListener((LayoutListener)separator);
                this.m_figureToHorizontalSeparator.put(figure, separator);
                this.m_canvas.addToAtticLayer((IFigure)separator);
            }
        }
    }

    private void removeCycleInfoDecorations(PrimaryTreeNodeFigure figure) {
        HorizontalSeparatorFigure separator;
        assert (figure != null) : "Parameter 'figure' of method 'removeCycleInfoDecorations' must not be null";
        CycleIndicator box = this.m_figureToCycleIndicator.remove((Object)figure);
        if (box != null) {
            this.m_canvas.removeFromSecondFloorLayer((IFigure)box);
        }
        if ((separator = this.m_figureToHorizontalSeparator.remove((Object)figure)) != null) {
            this.m_canvas.removeFromAtticLayer((IFigure)separator);
        }
    }

    private void updateIndexes() {
        List nodeFigures = this.m_canvas.getNodeFigures();
        int currentIndex = 0;
        for (DrawNodeFigure next : nodeFigures) {
            if (!(next instanceof SecondaryTreeNodeFigure)) continue;
            ((SecondaryTreeNodeFigure)next).setIndex(currentIndex);
            ++currentIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void update(ExpandCollapseModification modification) {
        Collection<Integer> update;
        Collection<Integer> remove;
        assert (modification != null) : "Parameter 'modification' of method 'update' must not be null";
        assert (!modification.isEmpty()) : "Nothing to update";
        this.removeInvalidEdgeFigures();
        THashMap addedNodeToNodeFigure = Collections.emptyMap();
        List<ArchitecturalViewNode> add = modification.add();
        if (!add.isEmpty()) {
            void var12_24;
            addedNodeToNodeFigure = new THashMap();
            List nodeFigures = this.m_canvas.getNodeFigures();
            int index = modification.addAtIndex();
            int numberOfAllNodeFigures = nodeFigures.size();
            ArchitecturalViewNode previousNode = null;
            ArrayList<TreeNodeFigure> addedNodeFigures = new ArrayList<TreeNodeFigure>(add.size() * 2);
            for (ArchitecturalViewNode nextToAdd : add) {
                SecondaryTreeNodeFigure nextSecondaryTreeNodeFigure = new SecondaryTreeNodeFigure(nextToAdd, this);
                PrimaryTreeNodeFigure primaryTreeNodeFigure = new PrimaryTreeNodeFigure(nextToAdd, this, nextSecondaryTreeNodeFigure);
                addedNodeFigures.add(primaryTreeNodeFigure);
                addedNodeFigures.add(nextSecondaryTreeNodeFigure);
                addedNodeToNodeFigure.put(nextToAdd, nextSecondaryTreeNodeFigure);
                this.createCycleInfoDecorations(previousNode, nextToAdd, primaryTreeNodeFigure);
                previousNode = nextToAdd;
            }
            int numberOfPreceedingNodeFigures = index * 2;
            int numberOfMovedNodeFigures = numberOfAllNodeFigures - numberOfPreceedingNodeFigures;
            ArrayList<DrawNodeFigure> movedNodeFigures = new ArrayList<DrawNodeFigure>(numberOfMovedNodeFigures);
            int n = numberOfPreceedingNodeFigures;
            while (var12_24 < numberOfAllNodeFigures) {
                movedNodeFigures.add((DrawNodeFigure)nodeFigures.get((int)var12_24));
                ++var12_24;
            }
            assert (movedNodeFigures.size() == numberOfMovedNodeFigures) : "Number of moved node figures not correct: " + movedNodeFigures.size() + "/" + numberOfMovedNodeFigures;
            for (DrawNodeFigure drawNodeFigure : movedNodeFigures) {
                this.m_canvas.removeNodeFigure(drawNodeFigure);
            }
            for (DrawNodeFigure drawNodeFigure : addedNodeFigures) {
                this.m_canvas.addNodeFigure(drawNodeFigure);
            }
            for (DrawNodeFigure drawNodeFigure : movedNodeFigures) {
                this.m_canvas.addNodeFigure(drawNodeFigure);
            }
            this.updateIndexes();
        }
        if (!(remove = modification.remove()).isEmpty()) {
            List nodeFigures = this.m_canvas.getNodeFigures();
            for (Integer nextToRemove : remove) {
                DrawNodeFigure nextPrimaryNodeFigure = (DrawNodeFigure)nodeFigures.get(nextToRemove * 2);
                assert (nextPrimaryNodeFigure != null && nextPrimaryNodeFigure instanceof PrimaryTreeNodeFigure) : "Unexpected class in method 'update': " + String.valueOf(nextPrimaryNodeFigure);
                DrawNodeFigure nextSecondaryNodeFigure = (DrawNodeFigure)nodeFigures.get(nextToRemove * 2 + 1);
                assert (nextSecondaryNodeFigure != null && nextSecondaryNodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'update': " + String.valueOf(nextSecondaryNodeFigure);
                this.m_canvas.removeNodeFigure(nextPrimaryNodeFigure);
                this.m_canvas.removeNodeFigure(nextSecondaryNodeFigure);
                this.removeCycleInfoDecorations((PrimaryTreeNodeFigure)nextPrimaryNodeFigure);
                this.removeExpandedNodeBox((SecondaryTreeNodeFigure)nextSecondaryNodeFigure);
                this.m_gestureHandler.clearNodeSelection((SecondaryTreeNodeFigure)nextSecondaryNodeFigure, false, false);
            }
            this.updateIndexes();
        }
        if (!(update = modification.update()).isEmpty()) {
            TreeEdgeFigureRouter treeEdgeFigureRouter = ((ExplorationViewLayout)this.m_canvas.getCanvasLayout()).getEdgeFigureRouter();
            ArrayList<SecondaryTreeNodeFigure> select = new ArrayList<SecondaryTreeNodeFigure>();
            List nodeFigures = this.m_canvas.getNodeFigures();
            THashMap nodeToNodeFigure = new THashMap((Map)addedNodeToNodeFigure);
            for (DrawNodeFigure nextNodeFigure : nodeFigures) {
                if (!(nextNodeFigure instanceof SecondaryTreeNodeFigure)) continue;
                nodeToNodeFigure.put((ArchitecturalViewNode)nextNodeFigure.getNode(), (SecondaryTreeNodeFigure)nextNodeFigure);
            }
            for (Integer nextToUpdate : update) {
                DrawNodeFigure drawNodeFigure = (DrawNodeFigure)nodeFigures.get(nextToUpdate * 2);
                assert (drawNodeFigure != null && drawNodeFigure instanceof PrimaryTreeNodeFigure) : "Unexpected class in method 'update': " + String.valueOf(drawNodeFigure);
                DrawNodeFigure nextSecondaryNodeFigure = (DrawNodeFigure)nodeFigures.get(nextToUpdate * 2 + 1);
                assert (nextSecondaryNodeFigure != null && nextSecondaryNodeFigure instanceof SecondaryTreeNodeFigure) : "Unexpected class in method 'update': " + String.valueOf(nextSecondaryNodeFigure);
                PrimaryTreeNodeFigure nextPrimaryTreeNodeFigure = (PrimaryTreeNodeFigure)drawNodeFigure;
                SecondaryTreeNodeFigure nextSecondaryTreeNodeFigure = (SecondaryTreeNodeFigure)nextSecondaryNodeFigure;
                ArchitecturalViewNode nextNode = (ArchitecturalViewNode)nextPrimaryTreeNodeFigure.getNode();
                this.m_gestureHandler.clearNodeSelection(nextSecondaryTreeNodeFigure, false, false);
                if (((ArchitecturalViewNode)nextSecondaryNodeFigure.getNode()).isSelected()) {
                    select.add(nextSecondaryTreeNodeFigure);
                }
                this.removeExpandedNodeBox(nextSecondaryTreeNodeFigure);
                this.createEdgeFigures(nextNode, nextSecondaryTreeNodeFigure, (Map<ArchitecturalViewNode, SecondaryTreeNodeFigure>)nodeToNodeFigure, treeEdgeFigureRouter);
                nextPrimaryTreeNodeFigure.update();
                nextSecondaryNodeFigure.update();
                if (!nextNode.isExpanded()) continue;
                this.createExpandedNodeBox(nextSecondaryTreeNodeFigure);
            }
            if (!select.isEmpty()) {
                this.m_gestureHandler.selectNodes(select, false);
            }
        }
        this.m_canvas.setNeedsLayout();
    }

    public void clicked(DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency> edgeFigure, DrawModifier modifier) {
        assert (edgeFigure != null && edgeFigure instanceof TreeEdgeFigure) : "Unexpected class in method 'clicked': " + String.valueOf(edgeFigure);
        assert (modifier != null) : "Parameter 'modifier' of method 'clicked' must not be null";
        TreeEdgeFigure treeEdgeFigure = (TreeEdgeFigure)edgeFigure;
        switch (modifier) {
            case NONE: {
                if (((ArchitecturalViewNode.ArchitecturalViewDependency)treeEdgeFigure.getConnection()).isSelected()) {
                    return;
                }
                this.m_gestureHandler.handleNonShiftBasedEdgeClick(treeEdgeFigure, false);
                this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
                break;
            }
            case PRIMARY: {
                this.m_gestureHandler.handleNonShiftBasedEdgeClick(treeEdgeFigure, true);
                this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
                break;
            }
            case SHIFT: {
                break;
            }
            default: {
                assert (false) : "Unhandled modifier: " + String.valueOf(modifier);
                break;
            }
        }
    }

    public void clickFinished(DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency> edgeFigure, DrawModifier modifier) {
        assert (edgeFigure != null && edgeFigure instanceof TreeEdgeFigure) : "Unexpected class in method 'clickFinished': " + String.valueOf(edgeFigure);
        assert (modifier != null) : "Parameter 'modifier' of method 'clickFinished' must not be null";
        switch (modifier) {
            case NONE: {
                TreeEdgeFigure treeEdgeFigure = (TreeEdgeFigure)edgeFigure;
                if (!((ArchitecturalViewNode.ArchitecturalViewDependency)treeEdgeFigure.getConnection()).isSelected() || this.m_gestureHandler.getNumberOfSelectedEdges() <= 1) break;
                this.m_gestureHandler.handleNonShiftBasedEdgeClick(treeEdgeFigure, false);
                this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
                break;
            }
            case PRIMARY: 
            case SHIFT: {
                break;
            }
            default: {
                assert (false) : "Unhandled modifier: " + String.valueOf(modifier);
                break;
            }
        }
    }

    List<Element> getSelectedElements() {
        return this.m_gestureHandler.getSelectedElements();
    }

    public void handleNoNodeOrConnectionClicked(DrawModifier modifier, Point location) {
        if (this.m_gestureHandler.handleNoNodeOrEdgeClicked()) {
            this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
        }
    }

    public boolean hasSelection() {
        return this.m_gestureHandler.hasSelection();
    }

    public void handleSelectAll() {
        SelectAllCommand command = new SelectAllCommand(this.m_softwareSystemProvider, new SelectAllCommand.ISelectAllInteraction(){

            public boolean collect(ArchitecturalViewRepresentationData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setRepresentation(ArchitecturalViewFigureProvider.this.m_representation);
                return true;
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }

    public void handleArrowUp(DrawModifier modifier) {
        assert (modifier != null) : "Parameter 'modifier' of method 'handleArrowUp' must not be null";
        if (this.m_gestureHandler.handleArrowUp(DrawModifier.SHIFT.equals((Object)modifier))) {
            this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
        }
    }

    public void handleArrowDown(DrawModifier modifier) {
        assert (modifier != null) : "Parameter 'modifier' of method 'handleArrowDown' must not be null";
        if (this.m_gestureHandler.handleArrowDown(DrawModifier.SHIFT.equals((Object)modifier))) {
            this.m_stateHandler.handleModification(this.m_architecturalViewProvider, null, (DrawNodeFigure<ArchitecturalViewNode>)this.m_canvas.getTopMostVisibleNode(), false, this.m_representation);
        }
    }

    public void handleArrowLeft(DrawModifier modifier) {
        SecondaryTreeNodeFigure nodeFigure;
        assert (modifier != null) : "Parameter 'modifier' of method 'handleArrowLeft' must not be null";
        if (this.m_gestureHandler.getNumberOfSelectedNodes() == 1 && ((ArchitecturalViewNode)(nodeFigure = this.m_gestureHandler.getSelectedSecondaryTreeNodeFigures().get(0)).getNode()).isExpanded()) {
            this.collapse(nodeFigure);
        }
    }

    public void handleArrowRight(DrawModifier modifier) {
        SecondaryTreeNodeFigure nodeFigure;
        assert (modifier != null) : "Parameter 'modifier' of method 'handleArrowRight' must not be null";
        if (this.m_gestureHandler.getNumberOfSelectedNodes() == 1 && !((ArchitecturalViewNode)(nodeFigure = this.m_gestureHandler.getSelectedSecondaryTreeNodeFigures().get(0)).getNode()).isExpanded() && ((ArchitecturalViewNode)nodeFigure.getNode()).isExpandable()) {
            this.expand(nodeFigure);
        }
    }

    private void createDropTargetNodeBox(SecondaryTreeNodeFigure secondaryTreeNodeFigure) {
        assert (secondaryTreeNodeFigure != null) : "Parameter 'secondaryTreeNodeFigure' of method 'createDropTargetNodeBox' must not be null";
        this.removeDragAndDropIndicators();
        this.m_dropTargetNodeBox = new DropTargetNodeBox((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), secondaryTreeNodeFigure);
        this.m_canvas.addLayoutListener((LayoutListener)this.m_dropTargetNodeBox);
        this.m_canvas.addToSecondFloorLayer((IFigure)this.m_dropTargetNodeBox);
    }

    private void removeDragAndDropIndicators() {
        if (this.m_dropTargetNodeBox != null) {
            this.m_canvas.removeFromSecondFloorLayer((IFigure)this.m_dropTargetNodeBox);
            this.m_dropTargetNodeBox = null;
        }
        if (this.m_dropIndicator != null) {
            this.m_canvas.removeFromSecondFloorLayer((IFigure)this.m_dropIndicator);
            this.m_dropIndicator = null;
        }
    }

    private void createDropIndicator(SecondaryTreeNodeFigure secondaryTreeNodeFigure, DrawNodeFigure.DropPosition position) {
        assert (secondaryTreeNodeFigure != null) : "Parameter 'secondaryTreeNodeFigure' of method 'createDropIndicator' must not be null";
        assert (position != null) : "Parameter 'position' of method 'createDropIndicator' must not be null";
        this.removeDragAndDropIndicators();
        this.m_dropIndicator = new DropIndicator((ExplorationViewLayout)this.m_canvas.getCanvasLayout(), secondaryTreeNodeFigure, position);
        this.m_canvas.addLayoutListener((LayoutListener)this.m_dropIndicator);
        this.m_canvas.addToSecondFloorLayer((IFigure)this.m_dropIndicator);
    }

    public boolean startDrag(DrawNodeFigure<ArchitecturalViewNode> nodeFigure, Point location) {
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'startDrag' must not be null";
        assert (location != null) : "Parameter 'location' of method 'startDrag' must not be null";
        List<ArchitecturalViewNode> selectedNodes = this.m_gestureHandler.getSelectedNodes();
        return !selectedNodes.isEmpty() && this.m_architecturalViewProvider.isMoveElementsPossible(selectedNodes) && this.m_elementInteractor.dragAndDropStarted();
    }

    private ArchitecturalViewCommand<?> isDropPossible(ArchitecturalViewNode node, DrawNodeFigure.DropPosition position, boolean reportDropInfo) {
        assert (node != null) : "Parameter 'node' of method 'isDropPossible' must not be null";
        assert (position != null) : "Parameter 'position' of method 'isDropPossible' must not be null";
        final List<ArchitecturalViewNode> selectedNodes = this.m_gestureHandler.getSelectedNodes();
        if (!selectedNodes.isEmpty()) {
            final MovableTargetInfo targetInfo = this.getTargetInfoForMoveElements(node, position);
            MoveElementsInfo operationInfo = this.m_architecturalViewProvider.isPossibleTargetInMoveElements(selectedNodes, targetInfo);
            if (operationInfo.isApplicable()) {
                return new MoveElementsCommand(this.m_softwareSystemProvider, new MoveElementsCommand.IMoveElementsInteraction(){

                    public boolean collect(MoveElementsCommand.MoveElementsData data) {
                        if (!$assertionsDisabled && data == null) {
                            throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                        }
                        PartialAlternativeInfo alternativeInfo = ArchitecturalViewFigureProvider.this.m_architecturalViewProvider.calculatePartialMoveElementsAlternative(selectedNodes);
                        if (alternativeInfo != null) {
                            switch (PartialAlternativeInfoComposite.getMovePartialElementsFeedback()) {
                                case 0: {
                                    data.set(alternativeInfo.getAlternativeNodes(), targetInfo);
                                    return true;
                                }
                                case 1: {
                                    data.set(selectedNodes, targetInfo);
                                    return true;
                                }
                            }
                            return false;
                        }
                        data.set(selectedNodes, targetInfo);
                        return true;
                    }

                    public void processMoveElementsResult(OperationResult result) {
                        if (!$assertionsDisabled && result == null) {
                            throw new AssertionError((Object)"Parameter 'result' of method 'processMoveElementsResult' must not be null");
                        }
                        UserInterfaceAdapter.getInstance().process(result);
                    }
                });
            }
            if (reportDropInfo && (!operationInfo.isApplicable() || operationInfo.hasAdditionalElementInfo())) {
                StringBuilder builder = new StringBuilder();
                operationInfo.getElementInfo().forEach(e -> {
                    StringBuilder stringBuilder2 = builder.append((String)e).append("\n");
                });
                UserInterfaceAdapter.getInstance().information(!operationInfo.isApplicable() ? "Drop not possible" : "Drop operation additional info", builder.toString());
            }
        }
        return null;
    }

    public void dropCandidateEntered(DrawNodeFigure<ArchitecturalViewNode> dragged, DrawNodeFigure<ArchitecturalViewNode> nodeFigure, DrawNodeFigure.DropPosition position) {
        assert (dragged != null) : "Parameter 'dragged' of method 'dropCandidateEntered' must not be null";
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'dropCandidateEntered' must not be null";
        assert (position != null) : "Parameter 'position' of method 'dropCandidateEntered' must not be null";
        if (this.isDropPossible((ArchitecturalViewNode)nodeFigure.getNode(), position, false) != null) {
            this.createDropTargetNodeBox(this.getSecondaryTreeNodeFigure(nodeFigure));
        } else {
            this.removeDragAndDropIndicators();
        }
    }

    public void dropCandidateExited(DrawNodeFigure<ArchitecturalViewNode> dragged, DrawNodeFigure<ArchitecturalViewNode> nodeFigure, DrawNodeFigure.DropPosition position) {
        assert (dragged != null) : "Parameter 'dragged' of method 'dropCandidateExited' must not be null";
        assert (nodeFigure != null) : "Parameter 'nodeFigure' of method 'dropCandidateExited' must not be null";
        assert (position != null) : "Parameter 'position' of method 'dropCandidateExited' must not be null";
        if (this.isDropPossible((ArchitecturalViewNode)nodeFigure.getNode(), position, false) != null) {
            this.createDropIndicator(this.getSecondaryTreeNodeFigure(nodeFigure), position);
        } else {
            this.removeDragAndDropIndicators();
        }
    }

    private MovableTargetInfo getTargetInfoForMoveElements(ArchitecturalViewNode targetNode, DrawNodeFigure.DropPosition position) {
        assert (targetNode != null) : "Parameter 'targetNode' of method 'getTargetInfoForMoveElements' must not be null";
        assert (position != null) : "Parameter 'position' of method 'getTargetInfoForMoveElements' must not be null";
        DrawNodeFigure.DropPosition positionToUse = position;
        if (targetNode.isExpanded() && position.equals((Object)DrawNodeFigure.DropPosition.AFTER)) {
            positionToUse = DrawNodeFigure.DropPosition.ON;
        }
        if (targetNode instanceof IAssignableTarget) {
            if (!(targetNode instanceof ArtifactNode)) {
                IAssignableTarget assignableTarget = (IAssignableTarget)targetNode.getParent(IAssignableTarget.class, new Class[0]);
                assert (assignableTarget != null) : "'assignableTarget' of method 'getTargetInfoForMoveElements' must not be null";
                int targetPos = -1;
                List artifacts = assignableTarget.getArchitecturalViewElement().getChildren(ArtifactNode.class);
                if (artifacts.isEmpty()) {
                    targetPos = 0;
                } else if (artifacts.size() < assignableTarget.getArchitecturalViewElement().getChildren(ArchitecturalViewNode.class).size()) {
                    targetPos = artifacts.size();
                }
                return new MovableTargetInfo(assignableTarget.getArchitecturalViewElement(), targetPos);
            }
            switch (positionToUse) {
                case BEFORE: {
                    IAssignableTarget parent = (IAssignableTarget)targetNode.getParent(IAssignableTarget.class, new Class[0]);
                    assert (parent != null) : "'parent' of method 'getTargetInfoForArtifactMove' must not be null";
                    int indexOfChild = targetNode.getRelativeIndex();
                    return new MovableTargetInfo(parent.getArchitecturalViewElement(), indexOfChild);
                }
                case AFTER: {
                    IAssignableTarget parent = (IAssignableTarget)targetNode.getParent(IAssignableTarget.class, new Class[0]);
                    assert (parent != null) : "'parent' of method 'getTargetInfoForArtifactMove' must not be null";
                    int indexOfChild = targetNode.getRelativeIndex();
                    int numberOfChildren = parent.getArchitecturalViewElement().getNumberOfChildren();
                    MovableTargetInfo assignableTargetInfo = new MovableTargetInfo(parent.getArchitecturalViewElement(), indexOfChild == numberOfChildren - 1 ? -1 : indexOfChild + 1);
                    return assignableTargetInfo;
                }
                case ON: {
                    return new MovableTargetInfo((ArchitecturalViewElement)targetNode, -1);
                }
            }
            assert (false) : "Unhandled drop position: " + String.valueOf(positionToUse);
            return null;
        }
        switch (positionToUse) {
            case BEFORE: 
            case AFTER: {
                ArchitecturalViewNode parent = targetNode.getNodeParent();
                return parent == null ? new MovableTargetInfo((ArchitecturalViewElement)this.m_representation, -1) : new MovableTargetInfo((ArchitecturalViewElement)parent, -1);
            }
            case ON: {
                return new MovableTargetInfo((ArchitecturalViewElement)targetNode, -1);
            }
        }
        assert (false) : "Unhandled drop position: " + String.valueOf(positionToUse);
        return null;
    }

    public void dragFinishedWithDrop(DrawNodeFigure<ArchitecturalViewNode> dragged, DrawNodeFigure<ArchitecturalViewNode> targetNodeFigure, DrawNodeFigure.DropPosition position) {
        assert (dragged != null) : "Parameter 'dragged' of method 'dragFinishedWithDrop' must not be null";
        assert (targetNodeFigure != null) : "Parameter 'targetNodeFigure' of method 'dragFinishedWithDrop' must not be null";
        assert (position != null) : "Parameter 'position' of method 'dragFinishedWithDrop' must not be null";
        ArchitecturalViewCommand<?> command = this.isDropPossible((ArchitecturalViewNode)targetNodeFigure.getNode(), position, true);
        if (command != null) {
            UserInterfaceAdapter.getInstance().run(command);
        }
        this.removeDragAndDropIndicators();
        this.m_elementInteractor.dragAndDropFinished();
    }

    public void dragFinished(DrawNodeFigure<ArchitecturalViewNode> dragged, Point location) {
        this.removeDragAndDropIndicators();
        this.m_elementInteractor.dragAndDropFinished();
    }

    public void dragCancelled(DrawNodeFigure<ArchitecturalViewNode> nodeFigure) {
        this.removeDragAndDropIndicators();
        this.m_elementInteractor.dragAndDropFinished();
    }

    void delete() {
        this.m_canvas.setListener(null);
    }

    public void drawAreaResized() {
        WorkbenchRegistry.getInstance().refreshUIElements();
    }
}

