/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.application;

import com.hello2morrow.sonargraph.client.eclipse.application.IExceptionHandler;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.EclipseApplicationExceptionHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IExceptionHandlingSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackOnErrorDialog;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWTException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandaloneExceptionHandler
extends EclipseApplicationExceptionHandler
implements IExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneExceptionHandler.class);
    private static final String ORG_ECLIPSE_EQUINOX_P2 = "org.eclipse.equinox.p2";
    private static final String ORG_ECLIPSE_E4_UI_WORKBENCH = "org.eclipse.e4.ui.workbench";
    private static final String SONARGRAPH_STANDALONE_EXECUTABLE_WIN = "Sonargraph.Standalone.executable.win";
    private static final String UNZIP_ACTION = "org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction";
    private final IProxySettingsProvider m_proxySettingsProvider;
    private boolean m_hasOutOfMemoryExceptionOccurred;

    public StandaloneExceptionHandler(IExceptionHandlingSupport uiAdapterProvider, IProxySettingsProvider proxySettingsProvider) {
        super(uiAdapterProvider);
        assert (proxySettingsProvider != null) : "Parameter 'proxySettingsProvider' of method 'StandaloneExceptionHandler' must not be null";
        this.m_proxySettingsProvider = proxySettingsProvider;
    }

    protected boolean exceptionHandledPriorToStandardHandling(IStatus status, String plugin, Throwable throwable) {
        assert (status != null) : "Parameter 'status' of method 'processException' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'processException' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'processException' must not be null";
        if (!this.alreadyShowingWarningOrErrorDialog() && this.m_hasOutOfMemoryExceptionOccurred) {
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    int feedback;
                    if (UserInterfaceAdapter.hasInstance() && (feedback = UserInterfaceAdapter.getInstance().question(1, "Error After Previous Out of Memory", "This error is likely being caused by a previous out of memory exception." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Please consider giving the application more memory in" + StringUtility.LINE_SEPARATOR + StandaloneExceptionHandler.this.getInstallationPath("Sonargraph.ini") + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "It is strongly recommended to restart the application!" + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Do you want to exit?", new String[]{"OK", "Cancel"})) == 0) {
                        LOGGER.warn("Shutting down after out of memory error.");
                        System.exit(-1);
                    }
                    StandaloneExceptionHandler.this.setAlreadyShowingWarningOrErrorDialog(false);
                }
            });
            return true;
        }
        if (throwable.hashCode() == this.getLastHandledThrowableHashCode()) {
            return true;
        }
        if (throwable instanceof OutOfMemoryError || throwable.getCause() != null && throwable.getCause() instanceof OutOfMemoryError) {
            this.m_hasOutOfMemoryExceptionOccurred = true;
            this.setHasCriticalExceptionAlreadyOccurred(true);
            if (!this.alreadyShowingWarningOrErrorDialog() && this.getExceptionHandlingSupport().isRunning()) {
                this.setAlreadyShowingWarningOrErrorDialog(true);
                UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                    @Override
                    public void run() {
                        int feedback;
                        if (UserInterfaceAdapter.hasInstance() && (feedback = UserInterfaceAdapter.getInstance().question(1, "Out of Memory Error", "Please consider giving the application more memory in" + StringUtility.LINE_SEPARATOR + StandaloneExceptionHandler.this.getInstallationPath("Sonargraph.ini") + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "It is strongly recommended to restart the application!" + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Do you want to exit?", new String[]{"OK", "Cancel"})) == 0) {
                            LOGGER.warn("Shutting down after out of memory error.");
                            System.exit(-1);
                        }
                        StandaloneExceptionHandler.this.setAlreadyShowingWarningOrErrorDialog(false);
                    }
                });
            }
            return true;
        }
        return false;
    }

    protected void handleFeedbackInteraction(IStatus status, Throwable throwable) {
        assert (status != null) : "Parameter 'status' of method 'handleFeedbackInteraction' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'handleFeedbackInteraction' must not be null";
        if (!UserInterfaceAdapter.hasInstance()) {
            return;
        }
        TFile logFile = SendFeedbackCommand.getLogFile();
        String infoText = "Sadly we did not even detect this problem during our 'Monkey' test." + StringUtility.LINE_SEPARATOR + "We recommend that you send us the error report and close the application." + StringUtility.LINE_SEPARATOR + "You can choose to proceed, but at this point all bets are off." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR;
        FeedbackOnErrorDialog dialog = new FeedbackOnErrorDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), throwable, logFile, "com.hello2morrow.sonargraph.standalone", this.m_proxySettingsProvider, infoText, new String[]{IDialogConstants.SHOW_DETAILS_LABEL, "Close Sonargraph", IDialogConstants.PROCEED_LABEL}, 2);
        int returnValue = dialog.open();
        if ((returnValue == 1 || returnValue == 2) && dialog.sendErrorEmail()) {
            try {
                List additionalFiles;
                if (logFile != null) {
                    additionalFiles = new ArrayList(1);
                    additionalFiles.add(new TFile((File)RcpUtility.getRcpWorkspaceMetaDataDirectory(), ".log"));
                } else {
                    additionalFiles = Collections.emptyList();
                }
                OperationResult result = SendFeedbackCommand.sendErrorFeedback((Feedback.Salutation)dialog.getSalutation(), (String)dialog.getContactName(), (String)dialog.getEmail(), (String)dialog.getPhone(), (String)dialog.getContextInfo(), (Throwable)throwable, (String)status.getMessage(), (TFile)logFile, additionalFiles, (ProxySettings)this.m_proxySettingsProvider.getProxySettings(false));
                UserInterfaceAdapter.getInstance().process(result);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to send error email! " + StringUtility.LINE_SEPARATOR + "{}", (Object)ExceptionUtility.collectAll((Throwable)t));
            }
        }
        if (returnValue == 1) {
            LOGGER.warn("Shutting down after showing error dialog.");
            System.exit(-1);
        }
    }

    private String getInstallationPath(String iniFileName) {
        assert (iniFileName != null && iniFileName.length() > 0) : "Parameter 'iniFileName' of method 'getInstallationPath' must not be empty";
        try {
            TFile directory = RcpUtility.getSonargraphExecutable().getParentFile();
            return new TFile((File)directory, iniFileName).getAbsolutePath();
        }
        catch (IOException ex) {
            return "<installdir>/" + iniFileName;
        }
    }

    protected boolean isRelevant(String plugin, IStatus status, Throwable throwable) {
        assert (plugin != null) : "Parameter 'plugin' of method 'isRelevant' must not be null";
        assert (status != null) : "Parameter 'status' of method 'isRelevant' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'isRelevant' must not be null";
        if (plugin.startsWith(ORG_ECLIPSE_EQUINOX_P2)) {
            return false;
        }
        String pluginFromStatus = status.getPlugin();
        if (pluginFromStatus != null && pluginFromStatus.startsWith(ORG_ECLIPSE_EQUINOX_P2)) {
            return false;
        }
        if (pluginFromStatus != null && pluginFromStatus.startsWith("org.codehaus.groovy.eclipse.core")) {
            return false;
        }
        if (throwable.getClass().equals(RuntimeException.class) && throwable.getMessage().startsWith("WARNINGS:")) {
            return false;
        }
        String statusMessage = status.getMessage();
        if (statusMessage != null && statusMessage.contains(UNZIP_ACTION) && statusMessage.contains(SONARGRAPH_STANDALONE_EXECUTABLE_WIN)) {
            return false;
        }
        if ("org.eclipse.jdt.core".equals(pluginFromStatus)) {
            return false;
        }
        if ((ORG_ECLIPSE_E4_UI_WORKBENCH.equals(plugin) || ORG_ECLIPSE_E4_UI_WORKBENCH.equals(pluginFromStatus)) && throwable instanceof NullPointerException && (ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.e4.ui.workbench.addons.dndaddon.DetachedDropAgent.drop") || ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.e4.ui.workbench.addons.minmax.TrimStack.showStack") || ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.swt.widgets.Control.internal_new_GC") || ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.swt.widgets.Menu._setVisible") || ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.swt.custom.StyledText.setMouseWordSelectionAnchor") || ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.e4.ui.internal.workbench.PartActivationHistory.activate"))) {
            return false;
        }
        return !(throwable instanceof InjectionException) || !(throwable.getCause() instanceof NullPointerException) && !(throwable.getCause() instanceof SWTException) || !ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.e4.core.internal.di.MethodRequestor.execute") && !ExceptionUtility.stacktraceContains((Throwable)throwable, (String)"org.eclipse.e4.ui.internal.workbench.PartActivationHistory.activate");
    }
}

