/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Polyline;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CreateManualWorkspaceDependencyCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateWorkspaceDependenciesRepresentationCommand;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.WorkspaceDependenciesViewDeadStateInfoProvider;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableWidgetListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.ActivityEventBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graph.GraphView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class WorkspaceDependenciesView
extends GraphView {
    private static final WorkspaceDependenciesViewDeadStateInfoProvider DEAD_STATE_INFO_PROVIDER = new WorkspaceDependenciesViewDeadStateInfoProvider();
    private static final String HIGHLIGHT_ORIGINAL_INPUT_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.highlightInputWorkspaceDepView";
    private static final String SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES_MENU_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyDependenciesOfSelectedNodesWorkspaceDependenciesView";
    private static final String SHOW_ONLY_VISIBLE_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledtoolitem.onlyVisible";
    private List<Element> m_elementsForShowInViewSelection;
    private Polyline m_polyline;
    private boolean m_initial = true;

    public IViewId getViewId() {
        return ViewId.WORKSPACE_DEPENDENCIES_VIEW;
    }

    public boolean startElementsMoveInteraction(Gesture gesture, List<Element> selectedElements) {
        assert (gesture != null) : "Parameter 'gesture' of method 'startElementsMoveInteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'startElementsMoveInteraction' must not be null";
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof RepresentationNode) {
            switch (gesture) {
                case MOVE_ELEMENT_COMPOSITE: {
                    this.m_polyline = new Polyline();
                    this.getGraphWidget().addFigure((Figure)this.m_polyline, this.getGraphWidget().getTopLayer());
                    break;
                }
                case MOVE_ELEMENT_SIMPLE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled gesture: " + String.valueOf(gesture);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void move(List<Element> selectedElements, Point targetLocation) {
        assert (selectedElements != null && !selectedElements.isEmpty()) : "Parameter 'selectedElements' of method 'move' must not be empty";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'move' must not be null";
        assert (selectedElements.size() == 1) : "Exactly on element expected";
        Element element = selectedElements.get(0);
        assert (element != null && element instanceof RepresentationNode) : "Unexpected class in method 'inElementsMoveInteraction': " + String.valueOf(element);
        for (RepresentationNode node : this.getGraphWidget().getUnderlyingRepresentation().getNodes()) {
            if (node != element) continue;
            GraphNodeFigure nodeFigure = (GraphNodeFigure)this.getGraphWidget().getNode(node);
            assert (nodeFigure != null) : "'nodeFigure' of method 'move' must not be null";
            this.setLocation(nodeFigure, targetLocation, this.allowYAxisDragging());
            break;
        }
    }

    private void drawDependencyGhost(Point sourceLocation, Point targetLocation) {
        assert (this.m_polyline != null) : "'m_polyline' of method 'inElementsMoveInteraction' must not be null";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'drawDependencyGhost' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'drawDependencyGhost' must not be null";
        Rectangle clientArea = this.getGraphWidget().getFigureCanvas().getViewport().getClientArea();
        if (!clientArea.contains(targetLocation)) {
            Point delta = new Point();
            if (targetLocation.x > clientArea.x + clientArea.width || targetLocation.x < clientArea.x) {
                delta.x = targetLocation.x > clientArea.x ? targetLocation.x - (clientArea.x + clientArea.width) : targetLocation.x - clientArea.x;
            }
            if (targetLocation.y > clientArea.y + clientArea.height || targetLocation.y < clientArea.y) {
                delta.y = targetLocation.y > clientArea.y ? targetLocation.y - (clientArea.y + clientArea.height) : targetLocation.y - clientArea.y;
            }
            Point currentViewLocation = this.getGraphWidget().getFigureCanvas().getViewport().getViewLocation();
            Point newViewLocation = new Point(currentViewLocation);
            newViewLocation.translate(delta.x, delta.y);
            if (newViewLocation.x < 0) {
                newViewLocation.x = 0;
            }
            if (newViewLocation.y < 0) {
                newViewLocation.y = 0;
            }
            this.getGraphWidget().getFigureCanvas().getViewport().setViewLocation(newViewLocation);
        }
        this.m_polyline.setPoints(new PointList(new int[]{sourceLocation.x, sourceLocation.y, targetLocation.x, targetLocation.y}));
        this.getGraphWidget().redraw();
    }

    public void inElementsMoveInteraction(Gesture gesture, List<Element> selectedElements, Point sourceLocation, Point targetLocation) {
        assert (gesture != null) : "Parameter 'gesture' of method 'inElementsMoveInteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'inElementsMoveInteraction' must not be null";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'inElementsMoveInteraction' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'inElementsMoveInteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                this.drawDependencyGhost(sourceLocation, targetLocation);
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                this.move(selectedElements, targetLocation);
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + String.valueOf(gesture);
                break;
            }
        }
    }

    public void finishElementsMoveInteraction(Gesture gesture, List<Element> selectedElements, Point sourceLocation, Point targetLocation) {
        assert (gesture != null) : "Parameter 'gesture' of method 'finishElementsMoveInnteraction' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'finishElementsMoveInnteraction' must not be null";
        assert (selectedElements.size() == 1) : "Exactly one element expected";
        assert (sourceLocation != null) : "Parameter 'sourceLocation' of method 'finishElementsMoveInteraction' must not be null";
        assert (targetLocation != null) : "Parameter 'targetLocation' of method 'finishElementsMoveInteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                assert (this.m_polyline != null) : "'m_polyline' of method 'finishElementsMoveInteraction' must not be null";
                this.m_polyline.removeAllPoints();
                this.getGraphWidget().removeFigure((Figure)this.m_polyline);
                this.m_polyline = null;
                IWorkspaceDependencyElement foundTo = null;
                IFigure figure = this.getGraphWidget().getFigureAt(targetLocation.x, targetLocation.y);
                if (figure != null) {
                    for (IDrawableNode next : this.getGraphWidget().getNodes()) {
                        if (next != figure) continue;
                        foundTo = (IWorkspaceDependencyElement)((RepresentationNode)next.getRepresentationElement()).getUnderlyingObject();
                        break;
                    }
                }
                if (foundTo != null) {
                    IWorkspaceDependencyElement to;
                    Element element = selectedElements.get(0);
                    assert (element != null && element instanceof RepresentationNode) : "Unexpected class in method 'finishElementsMoveInteraction': " + String.valueOf(element);
                    final IWorkspaceDependencyElement from = (IWorkspaceDependencyElement)((RepresentationNode)element).getUnderlyingObject();
                    if (from != (to = foundTo)) {
                        CreateManualWorkspaceDependencyCommand cmd = new CreateManualWorkspaceDependencyCommand(this.getSoftwareSystemProvider(), new CreateManualWorkspaceDependencyCommand.IInteraction(){

                            public void processWorkspaceDependencyCreationResult(OperationResult result) {
                                UserInterfaceAdapter.getInstance().process(result);
                            }

                            public boolean collect(CreateManualWorkspaceDependencyCommand.WorkspaceDependencyData data) {
                                if (!$assertionsDisabled && data == null) {
                                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                                }
                                data.setEndpoints(from, to);
                                return true;
                            }

                            public INavigationState getNavigationState() {
                                return ViewNavigationManager.getInstance().getCurrentNavigationState();
                            }
                        });
                        UserInterfaceAdapter.getInstance().run((Command)cmd);
                    }
                }
                this.getGraphWidget().reLayout(false);
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                this.getGraphWidget().reLayout(true);
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + String.valueOf(gesture);
                break;
            }
        }
    }

    public void cancelElementsMoveInteraction(Gesture gesture) {
        assert (gesture != null) : "Parameter 'gesture' of method 'cancelElementsMoveInteraction' must not be null";
        switch (gesture) {
            case MOVE_ELEMENT_COMPOSITE: {
                assert (this.m_polyline != null) : "'m_polyline' of method 'cancelElementsMoveInteraction' must not be null";
                this.m_polyline.removeAllPoints();
                this.getGraphWidget().getContents().remove((IFigure)this.m_polyline);
                this.m_polyline = null;
                break;
            }
            case MOVE_ELEMENT_SIMPLE: {
                break;
            }
            default: {
                assert (false) : "Unhandled gesture: " + String.valueOf(gesture);
                break;
            }
        }
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.createWorkspaceDependenciesWidget(null);
        super.softwareSystemShow(mode);
    }

    protected NavigationState.IDeadStateInfoProvider getDeadStateInfoProvider() {
        return DEAD_STATE_INFO_PROVIDER;
    }

    protected boolean hideOnSoftwareSystemClosed() {
        return false;
    }

    protected boolean supportsCreationWithEmptyInput() {
        return true;
    }

    private void createWorkspaceDependenciesWidget(final List<Element> elements) {
        this.removeRepresentationInWidgetFromModel(false, false);
        final CreateWorkspaceDependenciesRepresentationCommand command = new CreateWorkspaceDependenciesRepresentationCommand(this.getSoftwareSystemProvider());
        this.setViewReady(false);
        if (command.isEnabled().isSuccess()) {
            DefaultWorkerContext workerContext = this.m_initial ? DefaultWorkerContext.INSTANCE : new ActivityEventBasedWorkerContext(this.getSoftwareSystemProvider());
            UserInterfaceAdapter.getInstance().run((Command)command, (IWorkerContext)workerContext, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (exception == null && WorkspaceDependenciesView.this.getGraphWidget() != null && !WorkspaceDependenciesView.this.getGraphWidget().isDisposed()) {
                        WorkspaceDependenciesView.this.getGraphWidget().removeListeners();
                        WorkspaceDependenciesView.this.getGraphWidget().setRedraw(false);
                        GraphRepresentation representation = (GraphRepresentation)command.getRepresentation();
                        EnumSet<DrawableWidget.ShowOption> showOptions = EnumSet.of(DrawableWidget.ShowOption.SCROLL_TO_TOP);
                        if (WorkspaceDependenciesView.this.fitToView()) {
                            showOptions.add(DrawableWidget.ShowOption.FIT_TO_VIEW);
                        }
                        if (!representation.getMainNodes().isEmpty()) {
                            showOptions.add(DrawableWidget.ShowOption.REVEAL_INPUT);
                        }
                        WorkspaceDependenciesView.this.getGraphWidget().show((NodeAndEdgeRepresentation)representation, showOptions);
                        WorkspaceDependenciesView.this.getSelectionProviderAdapter().handleSelectionChanged();
                        WorkspaceDependenciesView.this.finishGraphCreation();
                        WorkspaceDependenciesView.this.refreshUIElements();
                        WorkspaceDependenciesView.this.updateStatusWidget(representation.getParserDependencyTypesForEdges(), representation.getFocusMode(), representation.getRepresentationProperties());
                        WorkspaceDependenciesView.this.getGraphWidget().setRedraw(true);
                        WorkspaceDependenciesView.this.getGraphWidget().addListeners((IDrawableWidgetListener)WorkspaceDependenciesView.this);
                        WorkspaceDependenciesView.this.m_initial = false;
                        if (elements != null) {
                            WorkspaceDependenciesView.this.select(elements);
                        }
                        WorkspaceDependenciesView.this.performFinishShowInView(false);
                    }
                }
            });
        }
    }

    private void select(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'select' must not be null";
        this.getGraphWidget().setRedraw(false);
        if (!elements.isEmpty()) {
            ArrayList<GraphNodeFigure> items = new ArrayList<GraphNodeFigure>(elements.size());
            for (Element element : elements) {
                GraphNodeFigure node = (GraphNodeFigure)this.getGraphWidget().getNode((NamedElement)element);
                if (node == null) continue;
                items.add(node);
            }
            this.getGraphWidget().setSelection(items, true);
            if (!items.isEmpty()) {
                this.getGraphWidget().reveal((IDrawableNode)items.iterator().next());
            }
        } else {
            this.getGraphWidget().setSelection(Collections.emptyList(), true);
        }
        this.getGraphWidget().setRedraw(true);
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        if (this.getGraphWidget().getUnderlyingRepresentation() != null) {
            for (Element element : elements) {
                if (this.getGraphWidget().getNode((NamedElement)element) != null) continue;
                this.createWorkspaceDependenciesWidget(elements);
                return;
            }
            this.select(elements);
            this.performFinishShowInView(false);
        } else {
            this.m_elementsForShowInViewSelection = elements;
        }
    }

    protected void finishGraphCreation() {
        if (this.m_elementsForShowInViewSelection != null) {
            this.select(this.m_elementsForShowInViewSelection);
            this.m_elementsForShowInViewSelection = null;
        }
    }

    public void requestHome() {
        ViewNavigationManager.getInstance().clear(this.getViewId(), this.getSecondaryId());
        this.createWorkspaceDependenciesWidget(null);
    }

    public EndpointType getEndpointType() {
        return EndpointType.WORKSPACE_DEPENDENCY;
    }

    protected String getHighlightOriginalSelectionHandledItemId() {
        return HIGHLIGHT_ORIGINAL_INPUT_TOOLITEM_ID;
    }

    protected String getShowOnlyDependenciesOfSelectedNodesHandledItemId() {
        return SHOW_ONLY_DEPENDENCIES_OF_SELECTED_NODES_MENU_ID;
    }

    protected String getShowOnlyViolationsHandledItemId() {
        return null;
    }

    protected String getHideSelfArcsHandledItemId() {
        return null;
    }

    protected String getOnlyVisibleHandledItemId() {
        return SHOW_ONLY_VISIBLE_TOOLITEM_ID;
    }

    public boolean supportsDependencyTypeFocus() {
        return false;
    }
}

