/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.model.treemap.IssueCollectorValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.MetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.ui.standalone.treemap.IssueCollectorConfigurationComposite;
import com.hello2morrow.sonargraph.ui.standalone.treemap.LayoutUtil;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TitleComposite;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class TreeMapConfigurationComposite
extends Composite {
    private final Map<ComboWithImages, IssueCollectorConfigurationComposite> m_valueSourceComboToConfigurationComposite = new THashMap();
    private final TreeMapProperties m_properties;
    private final IListener m_listener;

    public TreeMapConfigurationComposite(Composite parent, TreeMapProperties properties, IListener listener) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'TreeMapConfigurationComposite' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'TreeMapConfigurationComposite' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'TreeMapConfigurationComposite' must not be null";
        this.m_properties = properties;
        this.m_listener = listener;
        this.setLayout((Layout)LayoutUtil.createCompositeGridLayout(1));
        TitleComposite title = new TitleComposite(this, "2D Treemap Configuration");
        title.setLayoutData(new GridData(4, 0x1000000, true, false));
        Group leafElementGroup = new Group((Composite)this, 32);
        leafElementGroup.setText("Leaf Element");
        leafElementGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        leafElementGroup.setLayout((Layout)LayoutUtil.createCompositeGridLayout(1));
        ComboWithImages leafElements = new ComboWithImages((Composite)leafElementGroup, -1, "Select Leaf Element", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapLeafElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((TreeMapLeafElement)item).getPresentationName();
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapLeafElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage(((TreeMapLeafElement)item).getImageResourceName());
            }
        });
        leafElements.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        leafElements.setItems(Arrays.asList(TreeMapLeafElement.values()), (Object)this.m_properties.getLeafElement());
        final Group sizeGroup = new Group((Composite)this, 32);
        sizeGroup.setText("Size Source");
        sizeGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        sizeGroup.setLayout((Layout)LayoutUtil.createCompositeGridLayout(1));
        final ComboWithImages sizeValueSources = new ComboWithImages((Composite)sizeGroup, -1, "Select Size Source", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((TreeMapValueSource)item).getPresentationName();
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage(((TreeMapValueSource)item).getImageResourceName());
            }
        });
        sizeValueSources.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        sizeValueSources.setItems((Collection)this.m_properties.getAvailableSizeSources(), (Object)this.m_properties.getSizeSource());
        this.selectValueSource((Composite)sizeGroup, sizeValueSources, this.m_properties.getSizeSource());
        final Group colorGroup = new Group((Composite)this, 32);
        colorGroup.setText("Color Source");
        colorGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        colorGroup.setLayout((Layout)LayoutUtil.createCompositeGridLayout(1));
        final ComboWithImages colorValueSources = new ComboWithImages((Composite)colorGroup, -1, "Select Color Source", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((TreeMapValueSource)item).getPresentationName();
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage(((TreeMapValueSource)item).getImageResourceName());
            }
        });
        colorValueSources.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        colorValueSources.setItems((Collection)this.m_properties.getAvailableColorSources(), (Object)this.m_properties.getColorSource());
        this.selectValueSource((Composite)colorGroup, colorValueSources, this.m_properties.getColorSource());
        colorValueSources.updateDecoration(this.m_properties.getColorSource().isValid());
        Group redThresholdGroup = new Group((Composite)this, 32);
        redThresholdGroup.setText("Color Source Red Threshold");
        redThresholdGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        redThresholdGroup.setLayout((Layout)LayoutUtil.createCompositeGridLayout(2));
        Label descriptionLabel = new Label((Composite)redThresholdGroup, 0);
        descriptionLabel.setText("0 (dynamic) or a positive multiple of 2:");
        descriptionLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        ValidatingTextWidget redThreshold = new ValidatingTextWidget((Composite)redThresholdGroup, TreeMapProperties.getRedThresholdValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (input != null) {
                    block4: {
                        try {
                            int number = Integer.parseInt(input);
                            TreeMapConfigurationComposite.this.m_properties.setRedThreshold(number);
                        }
                        catch (NumberFormatException e) {
                            if ($assertionsDisabled) break block4;
                            throw new AssertionError((Object)("Unexpected: " + ExceptionUtility.collectAll((Throwable)e)));
                        }
                    }
                    TreeMapConfigurationComposite.this.m_listener.modified();
                } else {
                    TreeMapConfigurationComposite.this.m_properties.setRedThreshold(-1);
                    TreeMapConfigurationComposite.this.m_listener.modified();
                }
            }
        }, Integer.toString(this.m_properties.getRedThreshold()), 131072);
        redThreshold.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TitleComposite threeDimSeparator = new TitleComposite(this, "3D Treemap Configuration (Optional)");
        threeDimSeparator.setLayoutData(new GridData(4, 0x1000000, true, false));
        final Group heightGroup = new Group((Composite)this, 32);
        heightGroup.setText("Height Source");
        heightGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        heightGroup.setLayout((Layout)LayoutUtil.createCompositeGridLayout(1));
        final ComboWithImages heightValueSources = new ComboWithImages((Composite)heightGroup, -1, "Select Height Source", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((TreeMapValueSource)item).getPresentationName();
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage(((TreeMapValueSource)item).getImageResourceName());
            }
        });
        heightValueSources.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        heightValueSources.setItems((Collection)this.m_properties.getAvailableHeightSources(), (Object)this.m_properties.getHeightSource());
        this.selectValueSource((Composite)heightGroup, heightValueSources, this.m_properties.getHeightSource());
        heightValueSources.updateDecoration(this.m_properties.getHeightSource().isValid());
        leafElements.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapLeafElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                TreeMapConfigurationComposite.this.m_properties.setLeafElement((TreeMapLeafElement)item);
                sizeValueSources.setItems((Collection)TreeMapConfigurationComposite.this.m_properties.getAvailableSizeSources(), (Object)TreeMapConfigurationComposite.this.m_properties.getSizeSource());
                TreeMapConfigurationComposite.this.selectValueSource((Composite)sizeGroup, sizeValueSources, TreeMapConfigurationComposite.this.m_properties.getSizeSource());
                colorValueSources.setItems((Collection)TreeMapConfigurationComposite.this.m_properties.getAvailableColorSources(), (Object)TreeMapConfigurationComposite.this.m_properties.getColorSource());
                TreeMapConfigurationComposite.this.selectValueSource((Composite)colorGroup, colorValueSources, TreeMapConfigurationComposite.this.m_properties.getColorSource());
                heightValueSources.setItems((Collection)TreeMapConfigurationComposite.this.m_properties.getAvailableHeightSources(), (Object)TreeMapConfigurationComposite.this.m_properties.getHeightSource());
                TreeMapConfigurationComposite.this.selectValueSource((Composite)heightGroup, heightValueSources, TreeMapConfigurationComposite.this.m_properties.getHeightSource());
                TreeMapConfigurationComposite.this.m_listener.modified();
            }
        });
        sizeValueSources.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                TreeMapConfigurationComposite.this.m_properties.setSizeSource((TreeMapValueSource)item);
                TreeMapConfigurationComposite.this.selectValueSource((Composite)sizeGroup, sizeValueSources, (TreeMapValueSource)item);
                TreeMapConfigurationComposite.this.m_listener.modified();
            }
        });
        colorValueSources.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                TreeMapConfigurationComposite.this.m_properties.setColorSource((TreeMapValueSource)item);
                TreeMapConfigurationComposite.this.selectValueSource((Composite)colorGroup, colorValueSources, (TreeMapValueSource)item);
                colorValueSources.updateDecoration(((TreeMapValueSource)item).isValid());
                heightValueSources.updateDecoration(TreeMapConfigurationComposite.this.m_properties.getHeightSource().isValid());
                TreeMapConfigurationComposite.this.m_listener.modified();
            }
        });
        heightValueSources.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof TreeMapValueSource)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                TreeMapConfigurationComposite.this.m_properties.setHeightSource((TreeMapValueSource)item);
                TreeMapConfigurationComposite.this.selectValueSource((Composite)heightGroup, heightValueSources, (TreeMapValueSource)item);
                heightValueSources.updateDecoration(((TreeMapValueSource)item).isValid());
                colorValueSources.updateDecoration(TreeMapConfigurationComposite.this.m_properties.getColorSource().isValid());
                TreeMapConfigurationComposite.this.m_listener.modified();
            }
        });
    }

    private void selectValueSource(Composite parent, ComboWithImages valueSources, TreeMapValueSource source) {
        assert (parent != null) : "Parameter 'parent' of method 'selectValueSource' must not be null";
        assert (valueSources != null) : "Parameter 'valueSources' of method 'selectValueSource' must not be null";
        assert (source != null) : "Parameter 'source' of method 'selectValueSource' must not be null";
        boolean update = false;
        IssueCollectorConfigurationComposite issueCollectorConfigurationComposite = this.m_valueSourceComboToConfigurationComposite.remove(valueSources);
        if (issueCollectorConfigurationComposite != null) {
            issueCollectorConfigurationComposite.dispose();
            update = true;
        }
        if (!(source instanceof MetricValueSource) && source instanceof IssueCollectorValueSource) {
            IssueCollectorValueSource issueCollectorValueSource = (IssueCollectorValueSource)source;
            IssueCollectorConfigurationComposite configurationComposite = new IssueCollectorConfigurationComposite(parent, valueSources, issueCollectorValueSource, new IssueCollectorConfigurationComposite.IListener(){

                @Override
                public void modified(IssueCollectorConfigurationComposite configurationComposite) {
                    for (IssueCollectorConfigurationComposite next : TreeMapConfigurationComposite.this.m_valueSourceComboToConfigurationComposite.values()) {
                        next.updateFromModel();
                    }
                }
            });
            configurationComposite.setLayoutData(new GridData(4, 4, true, true));
            this.m_valueSourceComboToConfigurationComposite.put(valueSources, configurationComposite);
            update = true;
        }
        valueSources.updateDecoration(source.isValid());
        if (update) {
            parent.getShell().layout(true, true);
        }
    }

    public static interface IListener {
        public void modified();
    }
}

