/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.TreeMapsDirectory;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.wizard.StandaloneWizardAdapter;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;

public final class NewTreeMapWizardAdapter
extends StandaloneWizardAdapter {
    public final SonargraphWizardAdapter.Category getCategory() {
        return SonargraphWizardAdapter.Category.OTHER;
    }

    public boolean showInContextMenu(ISoftwareSystemProvider provider, IWorkbenchView workbenchView, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'showInContextMenu' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'showInContextMenu' must not be null";
        if (workbenchView.getViewId() == ViewId.FILES_VIEW) {
            if (selected.isEmpty()) {
                return true;
            }
            if (selected.size() == 1) {
                Element element = selected.get(0);
                return element instanceof TreeMapsDirectory;
            }
        }
        return false;
    }

    public String getName() {
        return "New Treemap";
    }

    public String getImageResource() {
        return "TreeMapView";
    }

    public boolean isAvailable() {
        return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_TREE_MAP);
    }

    public boolean isEnabled(ISoftwareSystemProvider provider, List<Element> selected) {
        return this.isAvailable() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_IS_CLEARABLE});
    }

    public SonargraphWizard create(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'create' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'create' must not be null";
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
        assert (softwareSystem != null) : "No system available";
        return new TreeMapWizard(((ITreeMapProvider)softwareSystem.getExtension(ITreeMapProvider.class)).getDefaultProperties());
    }
}

