/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapCommandAdapter;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.compositecommand.CompositeCommandAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public final class EditTreeMapCommandAdapter
extends TreeMapCommandAdapter {
    public CompositeCommandAdapter.Type getType() {
        return CompositeCommandAdapter.Type.EDIT;
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.EDIT_TREE_MAP;
    }

    public CompositeCommandAdapter.Applicable applicable(ISoftwareSystemProvider provider, List<Element> elements) {
        TreeMapFile file;
        assert (provider != null) : "Parameter 'provider' of method 'applicable' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'applicable' must not be null";
        if (this.mayBeExecuted(provider, elements) && (file = (TreeMapFile)CommandHandler.getSingleSelection(TreeMapFile.class, elements, (boolean)false)) != null && ((ITreeMapProvider)provider.getSoftwareSystem().getExtension(ITreeMapProvider.class)).isEditTreeMapPossible(file)) {
            return new CompositeCommandAdapter.Applicable(file.getPresentationKind() + " [" + file.getIdentifyingPath() + "]", file.getPresentationKind());
        }
        return null;
    }

    public void apply(ISoftwareSystemProvider provider, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'apply' must not be null";
        assert (provider.hasSoftwareSystem()) : "No system available";
        TreeMapFile file = (TreeMapFile)CommandHandler.getSingleSelection(TreeMapFile.class, elements, (boolean)false);
        assert (file != null) : "Parameter 'file' of method 'apply' must not be null";
        TreeMapWizard wizard = new TreeMapWizard(file);
        WizardDialog dialog = SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }
}

