/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.BaselineAction;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SnapshotActionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class SonargraphEnterprisePreferenceProvider {
    private static final String SONARGRAPH_ENTERPRISE_SETTINGS = "sonargraphenterprise.connection";
    private static final String SERVER_URL = "url";
    private static final String PORT = "port";
    private static final String CLIENT_KEY = "clientkey";
    private static final String USE_PROXY = "useproxy";
    private static final String SNAPSHOT_ACTION = "snapshotaction";
    private static final String SNAPSHOT_PATH = "snapshotpath";
    private static final String BASELINE_ACTION = "baselineaction";
    private static final String BASELINE_PATH = "baselinepath";
    private final IEclipsePreferences m_preferences = PreferencesUtility.getPreferences((String)"sonargraphenterprise.connection");

    public SonargraphEnterpriseConnection loadConnectionData() {
        return new SonargraphEnterpriseConnection(this.m_preferences.get(SERVER_URL, ""), this.m_preferences.get(PORT, ""), this.m_preferences.get(CLIENT_KEY, ""), this.m_preferences.getBoolean(USE_PROXY, false));
    }

    public void saveConnectionData(String serverUrl, String serverPort, String clientKey, boolean useProxy) {
        this.m_preferences.put(SERVER_URL, serverUrl);
        this.m_preferences.put(PORT, serverPort);
        this.m_preferences.put(CLIENT_KEY, clientKey);
        this.m_preferences.putBoolean(USE_PROXY, useProxy);
        PreferencesUtility.save((IEclipsePreferences)this.m_preferences);
    }

    public TFile getSnapshotDirectory() {
        String path = this.m_preferences.get(SNAPSHOT_PATH, null);
        return path != null ? new TFile(path) : null;
    }

    public void saveSnapshotDirectory(TFile directory) {
        assert (directory != null) : "Parameter 'directory' of method 'saveSnapshotDirectory' must not be null";
        this.m_preferences.put(SNAPSHOT_PATH, directory.getNormalizedAbsolutePath());
    }

    public SnapshotActionWizardPage.SnapshotAction getSnapshotAction(SnapshotActionWizardPage.SnapshotAction defaultAction) {
        assert (defaultAction != null) : "Parameter 'defaultAction' of method 'getSnapshotAction' must not be null";
        String lastAction = this.m_preferences.get(SNAPSHOT_ACTION, null);
        if (lastAction == null) {
            return defaultAction;
        }
        SnapshotActionWizardPage.SnapshotAction action = SnapshotActionWizardPage.SnapshotAction.fromStandardName(lastAction);
        return action != null ? action : defaultAction;
    }

    public void saveAction(SnapshotActionWizardPage.SnapshotAction action) {
        assert (action != null) : "Parameter 'action' of method 'saveAction' must not be null";
        this.m_preferences.put(SNAPSHOT_ACTION, action.getStandardName());
    }

    public void saveBaselineAction(String systemId, BaselineAction selectedAction) {
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'saveBaselineAction' must not be empty";
        assert (selectedAction != null) : "Parameter 'selectedAction' of method 'saveBaselineAction' must not be null";
        this.m_preferences.put(systemId + ".baselineaction", selectedAction.getStandardName());
    }

    public BaselineAction getBaselineAction(String systemId, BaselineAction defaultAction) {
        assert (systemId != null) : "Parameter 'systemId' of method 'getBaselineAction' must not be null";
        String lastAction = this.m_preferences.get(systemId + ".baselineaction", null);
        if (lastAction == null) {
            return defaultAction;
        }
        BaselineAction action = BaselineAction.fromStandardName(lastAction);
        return action != null ? action : defaultAction;
    }

    public TFile getBaselineDirectory(String systemId) {
        assert (systemId != null) : "Parameter 'systemId' of method 'getBaselineDirectory' must not be null";
        String lastPath = this.m_preferences.get(systemId + ".baselinepath", null);
        if (lastPath == null) {
            return null;
        }
        return new TFile(lastPath);
    }

    public void saveBaselineDirectory(String systemId, TFile baselineDirectory) {
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'saveBaselineDirectory' must not be empty";
        assert (baselineDirectory != null) : "Parameter 'baselineDirectory' of method 'saveBaselineDirectory' must not be null";
        this.m_preferences.put(systemId + ".baselinepath", baselineDirectory.getNormalizedAbsolutePath());
    }
}

