/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteReportInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteSystemInfo;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.AbstractRequestRemoteInfoWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.RemoteReportInfoBeanPropertyAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public final class RemoteReportWizardPage
extends AbstractRequestRemoteInfoWizardPage<RemoteReportInfo> {
    private static final IDialogId ID = CoreDialogId.REMOTE_REPORTS_PAGE;
    private RemoteSystemInfo m_remoteSystem;
    private RemoteReportInfo m_baseline;

    public RemoteReportWizardPage(ISonargraphEnterpriseProvider enterpriseExtension, ProxySettings proxySettings) {
        super(ID, enterpriseExtension, proxySettings);
    }

    @Override
    protected PropertyTableViewer<RemoteReportInfo> createPropertyTable(Composite parent) {
        PropertyTableViewer remoteReportsTable = new PropertyTableViewer(parent, (BeanPropertyReader.BeanAdapter)new RemoteReportInfoBeanPropertyAdapter(), "timestamp", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        remoteReportsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        remoteReportsTable.addColumn("Timestamp", "timestamp", "timestamp", null, 200, PropertyTableViewer.ColumnType.TEXT);
        return remoteReportsTable;
    }

    public void setPageComplete(boolean complete) {
        this.m_baseline = (RemoteReportInfo)this.getSelection();
        super.setPageComplete(this.m_baseline != null);
    }

    public boolean updateInfo(RemoteSystemInfo remoteSystem) {
        assert (remoteSystem != null) : "Parameter 'remoteSystem' of method 'updateInfo' must not be null";
        boolean changed = !remoteSystem.equals((Object)this.m_remoteSystem);
        this.m_remoteSystem = remoteSystem;
        return changed;
    }

    @Override
    protected OperationResultWithOutcome<List<RemoteReportInfo>> executeRequest(ISonargraphEnterpriseProvider enterpriseExtension, ISonargraphEnterpriseProvider.IEnterpriseInfoProvider infoProvider) {
        assert (enterpriseExtension != null) : "Parameter 'enterpriseExtension' of method 'executeRequest' must not be null";
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'executeRequest' must not be null";
        assert (this.m_remoteSystem != null) : "'m_remoteSystem' of method 'executeRequest' must not be null";
        OperationResultWithOutcome reportsResult = enterpriseExtension.listReports(this.m_remoteSystem.getId(), this.m_remoteSystem.getName(), infoProvider);
        if (reportsResult == null || reportsResult.getOutcome() == null) {
            UserInterfaceAdapter.getInstance().error("Failed to Load Reports", "No reports could be loaded from Sonargraph-Enterprise server.");
        } else if (((List)reportsResult.getOutcome()).isEmpty()) {
            UserInterfaceAdapter.getInstance().error("Failed to Load Reports", "There are no reports available on Sonargraph-Enterprise server.");
        }
        return reportsResult;
    }
}

