/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseInfo;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.RemoteSystemInfo;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.AbstractRequestRemoteInfoWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

abstract class AbstractDownloadWizardPage<T extends ISonargraphEnterpriseInfo>
extends AbstractRequestRemoteInfoWizardPage<T> {
    private final String m_directoryLabel;
    private Text m_nameText;
    private TFile m_directory;
    private RemoteSystemInfo m_remoteSystem;

    protected AbstractDownloadWizardPage(IDialogId dialogId, ISonargraphEnterpriseProvider enterpriseExtension, ProxySettings proxySettings, TFile directory, String directoryLabel) {
        super(dialogId, enterpriseExtension, proxySettings);
        assert (directoryLabel != null && directoryLabel.length() > 0) : "Parameter 'directoryLabel' of method 'AbstractDownloadWizardPage' must not be empty";
        this.m_directory = directory;
        this.m_directoryLabel = directoryLabel;
    }

    @Override
    protected final void createAdditionalWidgets(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, this.getNumberOfColumns(), 1));
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setText(this.m_directoryLabel);
        directoryLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ValidatingPathWidget directory = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                AbstractDownloadWizardPage.this.m_directory = input;
                AbstractDownloadWizardPage.this.setPageComplete(AbstractDownloadWizardPage.this.isPageComplete());
            }
        }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ_WRITE), 2, this.m_directory, true);
        directory.setLayoutData((Object)new GridData(4, 4, true, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("File Name: ");
        nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.m_nameText = new Text(composite, 8);
        this.m_nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public void setPageComplete(boolean complete) {
        if (this.getSelection() != null) {
            this.updateFileName();
        } else {
            this.m_nameText.setText("");
        }
        super.setPageComplete(complete);
    }

    protected abstract void updateFileName();

    protected final void setFileName(String fileName) {
        this.m_nameText.setText(fileName);
    }

    @Override
    public final boolean isPageComplete() {
        return super.isPageComplete() && this.m_directory != null;
    }

    final boolean updateInfo(RemoteSystemInfo remoteSystem) {
        assert (remoteSystem != null) : "Parameter 'remoteSystem' of method 'updateInfo' must not be null";
        boolean changed = !remoteSystem.equals((Object)this.m_remoteSystem);
        this.m_remoteSystem = remoteSystem;
        return changed;
    }

    final RemoteSystemInfo getRemoteSystem() {
        return this.m_remoteSystem;
    }

    final TFile getTargetFile() {
        return new TFile((File)this.m_directory, this.m_nameText.getText());
    }

    protected final TFile getDirectory() {
        return this.m_directory;
    }
}

