/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.IBoxCompositeContribution;
import com.hello2morrow.sonargraph.ui.swt.base.DetailsSeparatorWidget;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

abstract class ValueTrend
implements IBoxCompositeContribution {
    private static final Color IMPROVED = UiResourceManager.getInstance().getColor(UiResourceManager.GREEN);
    private static final Color WORSE = UiResourceManager.getInstance().getColor(UiResourceManager.RED);
    private static final Color UNCHANGED = UiResourceManager.getInstance().getColor(UiResourceManager.GREY);
    private static final Color MODIFIED = UiResourceManager.getInstance().getForegroundColor();
    private static final Color PENDING = UiResourceManager.getInstance().getColor(UiResourceManager.GREY);
    private static final String ARROW_UP = "\u2197";
    private static final String ARROW_DOWN = "\u2198";
    private static final String ARROW_LEFT_RIGHT = "\u2192";
    private final String m_name;
    private final Label m_nameLabel;
    private final Label m_valueLabel;
    private Number m_value;
    private final Label m_trend;
    private final GridData m_trendGridData;
    private boolean m_showTrend;
    private final GridData m_nameGridData;
    private final GridData m_valueGridData;
    private final Control m_centerControl;
    private final GridData m_centerGridData;

    public ValueTrend(Composite parent, String name, boolean showTrend, boolean showValue, String toolTipText, int firstColumnWidthHint) {
        assert (parent != null) : "Parameter 'parent' of method 'ValueTrend' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ValueTrend' must not be empty";
        this.m_name = name;
        this.m_showTrend = showTrend;
        this.m_nameLabel = new Label(parent, 0);
        this.m_nameLabel.setText(name + ":");
        this.m_nameGridData = new GridData(4, 0x1000000, false, false);
        this.m_nameGridData.widthHint = firstColumnWidthHint;
        this.m_nameLabel.setLayoutData((Object)this.m_nameGridData);
        this.m_nameLabel.setForeground(UiResourceManager.getInstance().getColor(LABEL_COLOR));
        if (toolTipText != null && toolTipText.trim().length() > 0 && !name.equals(toolTipText)) {
            this.m_nameLabel.setToolTipText(SwtUtility.wrapTextForTooltip((String)toolTipText));
        }
        this.m_centerControl = this.createCenterControl(parent);
        this.m_centerGridData = new GridData(4, 0x1000000, false, false);
        this.m_centerGridData.heightHint = 12;
        this.m_centerGridData.widthHint = 140;
        this.m_centerControl.setLayoutData((Object)this.m_centerGridData);
        this.m_trend = new Label(parent, 131072);
        this.m_trendGridData = new GridData(4, 0x1000000, true, false);
        this.m_trendGridData.horizontalIndent = 5;
        this.m_trend.setLayoutData((Object)this.m_trendGridData);
        this.m_trend.setEnabled(true);
        this.m_valueLabel = new Label(parent, 131072);
        if (showValue) {
            this.m_valueLabel.setText("n/a");
        }
        this.m_valueGridData = new GridData(4, 0x1000000, false, false);
        this.m_valueGridData.horizontalIndent = 5;
        this.m_valueLabel.setLayoutData((Object)this.m_valueGridData);
        if (!this.m_showTrend) {
            this.showTrend(false);
        } else {
            this.resetTrend();
        }
    }

    public void changeExpansionState(DetailsSeparatorWidget.ExpansionState expansionState, String identifier) {
        assert (expansionState != null) : "Parameter 'expansionState' of method 'changeExpansionState' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'changeExpansionState' must not be empty";
        boolean visible = expansionState == DetailsSeparatorWidget.ExpansionState.EXPANDED;
        this.m_nameLabel.setVisible(visible);
        this.m_nameGridData.exclude = !visible;
        this.m_centerControl.setVisible(visible);
        this.m_centerGridData.exclude = !visible;
        this.m_trend.setVisible(visible);
        this.m_trendGridData.exclude = !visible;
        this.m_valueLabel.setVisible(visible);
        this.m_valueGridData.exclude = !visible;
    }

    protected Control createCenterControl(Composite parent) {
        return SwtUtility.createFillerForGridLayoutCell((Composite)parent);
    }

    private void setTrendInfoVisible(boolean visible) {
        this.m_trendGridData.exclude = !visible;
        this.m_trend.setVisible(visible);
        this.m_showTrend = visible;
        this.m_nameGridData.horizontalSpan = visible ? 1 : 2;
    }

    public void showTrend(boolean showTrend) {
        if (showTrend != this.m_showTrend) {
            this.setTrendInfoVisible(showTrend);
        }
    }

    public void setValue(Number value, boolean showTrend, boolean resetTrend) {
        this.m_value = value;
        if (value == null) {
            this.m_valueLabel.setText("n/a");
        } else {
            this.m_valueLabel.setText(NumberUtility.format((Number)value));
        }
        this.m_valueLabel.requestLayout();
        this.showTrend(showTrend);
        if (this.m_showTrend && resetTrend) {
            this.resetTrend();
        }
    }

    public void setValue(String value) {
        if (value == null) {
            this.m_valueLabel.setText("");
        } else {
            this.m_valueLabel.setText(value);
        }
        this.m_valueLabel.requestLayout();
    }

    public Number getValue() {
        return this.m_value;
    }

    public void resetTrend() {
        this.m_trend.setFont(UiResourceManager.getInstance().getFont(0));
        this.m_trend.setText("n/a");
        this.m_trend.setForeground(PENDING);
    }

    public void setTrend(Number valueDiffAbsolute, IDiffElement.Change change) {
        Color fontColor;
        String arrow;
        String prefix;
        assert (valueDiffAbsolute != null) : "Parameter 'valueDiffAbsolute' of method 'setTrend' must not be null";
        assert (change != null) : "Parameter 'change' of method 'setTrend' must not be null";
        int compare = Float.compare(valueDiffAbsolute.floatValue(), 0.0f);
        if (compare == 0) {
            prefix = "\u00b1";
            arrow = ARROW_LEFT_RIGHT;
        } else if (compare > 0) {
            prefix = "+";
            arrow = ARROW_UP;
        } else {
            prefix = "";
            arrow = ARROW_DOWN;
        }
        this.m_trend.setText(String.format("%s%s %s", prefix, NumberUtility.format((Number)valueDiffAbsolute), arrow));
        Font font = switch (change) {
            case IDiffElement.Change.WORSENED -> {
                fontColor = WORSE;
                yield UiResourceManager.getInstance().getFont(1);
            }
            case IDiffElement.Change.IMPROVED -> {
                fontColor = IMPROVED;
                yield UiResourceManager.getInstance().getFont(1);
            }
            case IDiffElement.Change.MODIFIED -> {
                fontColor = MODIFIED;
                yield UiResourceManager.getInstance().getFont(1);
            }
            default -> {
                fontColor = UNCHANGED;
                yield UiResourceManager.getInstance().getFont(0);
            }
        };
        this.m_trend.setForeground(fontColor);
        this.m_trend.setFont(font);
        this.showTrend(true);
    }

    protected void setTrend(Number valueDiffAbsolute) {
        assert (valueDiffAbsolute != null) : "Parameter 'valueDiffAbsolute' of method 'setTrend' must not be null";
        int diffAsInt = valueDiffAbsolute.intValue();
        IDiffElement.Change change = diffAsInt == 0 ? IDiffElement.Change.UNMODIFIED : (diffAsInt < 0 ? IDiffElement.Change.IMPROVED : IDiffElement.Change.WORSENED);
        this.setTrend(valueDiffAbsolute, change);
    }

    protected String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.m_name;
    }
}

