/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.EditorPreferences;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveDialog;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SaveCommandInteraction
implements SaveSoftwareSystemCommand.ISaveInteraction {
    private final boolean m_allowCancel;

    public SaveCommandInteraction(boolean allowCancel) {
        this.m_allowCancel = allowCancel;
    }

    public static boolean performCollectSaveData(final SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data, final boolean allowCancel) {
        assert (data != null) : "Parameter 'data' of method 'performCollectSaveData' must not be null";
        RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

            public void run() {
                IWorkbenchView workbenchView = WorkbenchRegistry.getInstance().getCurrentlySelectedView();
                SaveDialog saveDialog = new SaveDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Save Modified File(s)", data.getNeedingSave(), data.getNeedingSave(), allowCancel);
                if (saveDialog.open() == 0) {
                    data.setToBeSaved(saveDialog.getToBeSaved());
                    this.setResult(Boolean.TRUE);
                } else {
                    this.setResult(Boolean.FALSE);
                }
                if (workbenchView != null) {
                    WorkbenchRegistry.getInstance().selectView(workbenchView);
                }
            }
        };
        return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
    }

    public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
        assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        return SaveCommandInteraction.performCollectSaveData(data, this.m_allowCancel);
    }

    protected boolean askToProceedInCaseOfFailure() {
        return false;
    }

    public static boolean performProcessSaveResult(OperationResult saveResult, boolean askToProceedInCaseOfFailure) {
        assert (saveResult != null) : "Parameter 'saveResult' of method 'performProcessSaveResult' must not be null";
        UserInterfaceAdapter.getInstance().process(saveResult);
        return !askToProceedInCaseOfFailure || !saveResult.containsError() || UserInterfaceAdapter.getInstance().question("Errors occured during 'save'. Proceed?", false) != UserInterfaceAdapter.Feedback.DISAGREED;
    }

    public boolean processSaveResult(OperationResult saveResult) {
        assert (saveResult != null) : "Parameter 'saveResult' of method 'processModifiableFilesSavedResult' must not be null";
        return SaveCommandInteraction.performProcessSaveResult(saveResult, this.askToProceedInCaseOfFailure());
    }

    public static final Map<IModifiableFile, IModificationOnSave> performAboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
        assert (system != null) : "Parameter 'system' of method 'performAboutToSave' must not be null";
        assert (toBeSaved != null) : "Parameter 'toBeSaved' of method 'performAboutToSave' must not be null";
        EditorPreferences editorPreferences = new EditorPreferences();
        if (editorPreferences.isAutoFormat()) {
            FormatterOptions formatterOptions = editorPreferences.getFormatterOptions();
            IGroovyProvider groovyProvider = (IGroovyProvider)system.getExtension(IGroovyProvider.class);
            final IFormatter groovyFormatter = groovyProvider.getFormatter(formatterOptions);
            final IFormatter architectureFormatter = ((IArchitectureProvider)system.getExtension(IArchitectureProvider.class)).getFormatter(formatterOptions);
            HashMap<IModifiableFile, IModificationOnSave> modificationsOnSave = new HashMap<IModifiableFile, IModificationOnSave>();
            for (IModifiableFile file : toBeSaved) {
                if (file instanceof GroovyScript) {
                    modificationsOnSave.put(file, new IModificationOnSave(){

                        public String apply(String content) {
                            if (!$assertionsDisabled && content == null) {
                                throw new AssertionError((Object)"'content' of method 'performAboutToSave' must not be null");
                            }
                            return groovyFormatter.format(content);
                        }
                    });
                    continue;
                }
                if (!(file instanceof ArchitectureFile)) continue;
                modificationsOnSave.put(file, new IModificationOnSave(){

                    public String apply(String content) {
                        if (!$assertionsDisabled && content == null) {
                            throw new AssertionError((Object)"'content' of method 'performAboutToSave' must not be null");
                        }
                        return architectureFormatter.format(content);
                    }
                });
            }
            return modificationsOnSave;
        }
        return Collections.emptyMap();
    }

    public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
        assert (system != null) : "Parameter 'system' of method 'aboutToSave' must not be null";
        assert (toBeSaved != null) : "Parameter 'toBeSaved' of method 'aboutToSave' must not be null";
        return SaveCommandInteraction.performAboutToSave(system, toBeSaved);
    }
}

