/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

final class OpenSnapshotInAttachedModeDialog
extends StandardDialog {
    private final TFile m_defaultDirectory;
    private TFile m_directory;

    OpenSnapshotInAttachedModeDialog(Shell shell, TFile defaultDirectory) {
        super(shell, "Open Snapshot");
        assert (defaultDirectory != null) : "Parameter 'defaultDirectory' of method 'OpenSnapshotInAttachedModeDialog' must not be null";
        this.m_defaultDirectory = defaultDirectory;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.OPEN_SNAPSHOT_DIALOG;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void applyData() {
        this.getButton(0).setEnabled(true);
    }

    protected boolean useCalculatedSizeAsMinimumSize() {
        return true;
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Button readOnly = new Button(composite, 16);
        readOnly.setText("'Read-only'");
        readOnly.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button attached = new Button(composite, 16);
        attached.setText("Extract system and 'attach' to snapshot");
        attached.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText("Directory:");
        pathLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final ValidatingPathWidget pathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                OpenSnapshotInAttachedModeDialog.this.m_directory = input;
                OpenSnapshotInAttachedModeDialog.this.getButton(0).setEnabled(OpenSnapshotInAttachedModeDialog.this.m_directory != null);
            }
        }, new IPathValidator(){

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null || newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                }
                return result;
            }
        }, 2, this.m_defaultDirectory, false);
        pathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        pathWidget.setEnabled(false);
        readOnly.setSelection(true);
        readOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                pathWidget.setEnabled(false);
                OpenSnapshotInAttachedModeDialog.this.m_directory = null;
                OpenSnapshotInAttachedModeDialog.this.getButton(0).setEnabled(true);
            }
        });
        attached.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                pathWidget.validate(true);
                pathWidget.setEnabled(true);
            }
        });
    }

    TFile getTargetDirectory() {
        return this.m_directory;
    }
}

