/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.ISoftwareSystemView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class LoadLastSnapshotOnOpenHandler
extends CommandHandler {
    private static final String KEY = "LoadLastSnapshotOnOpen";

    public static boolean isActive() {
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
        return eclipsePreferences.getBoolean(KEY, true);
    }

    public static void activate(boolean activate) {
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
        eclipsePreferences.putBoolean(KEY, activate);
        PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
    }

    public boolean isAvailable() {
        return SonargraphCommand.isAvailable((ICommandId)CoreCommandId.OPEN_SOFTWARE_SYSTEM, (SoftwareSystem)WorkbenchRegistry.getInstance().getSoftwareSystem());
    }

    @CanExecute
    public boolean canExecute(MMenuItem menuItem) {
        assert (menuItem != null) : "Parameter 'menuItem' of method 'canExecute' must not be null";
        if (Platform.isWindows()) {
            menuItem.setIconURI(null);
        }
        menuItem.setSelected(LoadLastSnapshotOnOpenHandler.isActive());
        return true;
    }

    @Execute
    public void execute(MMenuItem menuItem) {
        ISoftwareSystemView softwareSystemView;
        assert (menuItem != null) : "Parameter 'menuItem' of method 'execute' must not be null";
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
        eclipsePreferences.putBoolean(KEY, !menuItem.isSelected());
        PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
        MPart part = RcpUtility.findPart((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (IViewId)ViewId.SOFTWARE_SYSTEM_VIEW, null);
        if (part != null && (softwareSystemView = (ISoftwareSystemView)RcpUtility.getWorkbenchView((MPart)part, ISoftwareSystemView.class)) != null) {
            softwareSystemView.softwareSystemOpenDataModified();
        }
    }
}

