/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SetAnalyzerExecutionLevelCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.LoadLastSnapshotOnOpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenRecentlyUsedSoftwareSystemFromSnapshotHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenRecentlyUsedSoftwareSystemHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RefreshSoftwareSystemOnOpenHandler;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StandaloneActions;
import com.hello2morrow.sonargraph.ui.swt.base.LinkWithImage;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

final class LastRecentlyUsedSystemsWidget
extends Composite {
    private final List<AnalyzerExecutionLevelSelectionListener> m_analyzerExecutionLevelListeners = new ArrayList<AnalyzerExecutionLevelSelectionListener>(AnalyzerExecutionLevel.values().length);
    private final Group m_onOpenOptions;
    private final Button m_loadLastSnapshotOnOpen;
    private final Button m_refreshOnOpen;
    private final Group m_analyzerExecutionLevel;
    private final Group m_openExplorationView;
    private final Group m_lruList;
    private final SelectionAdapter m_loadLastSnapshotOnOpenListener;
    private final SelectionAdapter m_refreshOnOpenListener;
    private final ComboWithImages.IItemSelectionListener m_openExplorationViewListener;
    private final ComboWithImages m_openExplorationViewOptionsCombo;
    private final IEclipseContext m_context;
    private final ISoftwareSystemProvider m_provider;
    private final Set<String> m_currentLastRecentlyUsedPaths = new LinkedHashSet<String>();

    LastRecentlyUsedSystemsWidget(Composite parent, IEclipseContext context, ISoftwareSystemProvider provider) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'LastRecentlyUsedSystemsWidget' must not be null";
        assert (context != null) : "Parameter 'context' of method 'LastRecentlyUsedSystemsWidget' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'LastRecentlyUsedSystemsWidget' must not be null";
        this.m_context = context;
        this.m_provider = provider;
        boolean isArchitectureLicensed = CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE);
        this.setBackground(parent.getBackground());
        this.setLayout((Layout)new GridLayout(isArchitectureLicensed ? 3 : 2, false));
        this.m_onOpenOptions = new Group((Composite)this, 0);
        this.m_onOpenOptions.setBackground(this.getBackground());
        this.m_onOpenOptions.setText("On Open");
        this.m_onOpenOptions.setLayoutData((Object)new GridData(1, 1, false, false));
        RowLayout optionsLayout = new RowLayout(256);
        optionsLayout.marginHeight = 4;
        optionsLayout.marginWidth = 4;
        optionsLayout.spacing = 4;
        optionsLayout.wrap = false;
        optionsLayout.pack = true;
        this.m_onOpenOptions.setLayout((Layout)optionsLayout);
        this.m_loadLastSnapshotOnOpen = new Button((Composite)this.m_onOpenOptions, 32);
        this.m_loadLastSnapshotOnOpen.setText("Load Last Snapshot");
        this.m_loadLastSnapshotOnOpenListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadLastSnapshotOnOpenHandler.activate(LastRecentlyUsedSystemsWidget.this.m_loadLastSnapshotOnOpen.getSelection());
                WorkbenchRegistry.getInstance().refreshUIElements();
            }
        };
        this.m_refreshOnOpen = new Button((Composite)this.m_onOpenOptions, 32);
        this.m_refreshOnOpen.setText("Refresh");
        this.m_refreshOnOpenListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RefreshSoftwareSystemOnOpenHandler.activate(LastRecentlyUsedSystemsWidget.this.m_refreshOnOpen.getSelection());
                WorkbenchRegistry.getInstance().refreshUIElements();
            }
        };
        this.m_analyzerExecutionLevel = new Group((Composite)this, 0);
        this.m_analyzerExecutionLevel.setBackground(this.getBackground());
        this.m_analyzerExecutionLevel.setText("Analyzer Execution Level");
        this.m_analyzerExecutionLevel.setLayoutData((Object)new GridData(1, 4, false, false));
        RowLayout analyzerExecutionLevelLayout = new RowLayout(256);
        analyzerExecutionLevelLayout.marginHeight = 4;
        analyzerExecutionLevelLayout.marginWidth = 4;
        analyzerExecutionLevelLayout.spacing = 4;
        analyzerExecutionLevelLayout.wrap = false;
        analyzerExecutionLevelLayout.pack = true;
        this.m_analyzerExecutionLevel.setLayout((Layout)analyzerExecutionLevelLayout);
        AnalyzerExecutionLevel[] analyzerExecutionLevelArray = AnalyzerExecutionLevel.values();
        int n = analyzerExecutionLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalyzerExecutionLevel next = analyzerExecutionLevelArray[n2];
            Button nextButton = new Button((Composite)this.m_analyzerExecutionLevel, 16);
            nextButton.setText(next.getPresentationName());
            this.m_analyzerExecutionLevelListeners.add(new AnalyzerExecutionLevelSelectionListener(next, nextButton));
            ++n2;
        }
        if (isArchitectureLicensed) {
            this.m_openExplorationView = new Group((Composite)this, 0);
            this.m_openExplorationView.setText("Open Exploration View Automatically");
            this.m_openExplorationView.setLayoutData((Object)new GridData(1, 4, false, false));
            GridLayout openExplorationViewLayout = new GridLayout(1, false);
            this.m_openExplorationView.setLayout((Layout)openExplorationViewLayout);
            int width = 0;
            Label label = new Label((Composite)this.m_openExplorationView, 0);
            final LinkedHashMap<String, ExplorationViewStructureMode> modePresentationNameToMode = new LinkedHashMap<String, ExplorationViewStructureMode>();
            SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
            ExplorationViewStructureMode[] explorationViewStructureModeArray = ExplorationViewStructureMode.values();
            int n3 = explorationViewStructureModeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ExplorationViewStructureMode next = explorationViewStructureModeArray[n4];
                if (next.isAvailableFor((Collection)(softwareSystem != null ? softwareSystem.getUsedLanguages() : null))) {
                    modePresentationNameToMode.put(next.getPresentationName(), next);
                    label.setText(next.getPresentationName());
                    Point nextSize = label.computeSize(-1, -1, true);
                    width = Math.max(width, nextSize.x);
                }
                ++n4;
            }
            modePresentationNameToMode.put("Do Not Open", null);
            label.dispose();
            this.m_openExplorationViewOptionsCombo = new ComboWithImages((Composite)this.m_openExplorationView, width += 20, "", new ComboWithImages.ILabelProvider(){

                public String getText(Object item) {
                    if (!($assertionsDisabled || item != null && item instanceof String)) {
                        throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                    }
                    return (String)item;
                }

                public Image getImage(Object item) {
                    if (!($assertionsDisabled || item != null && item instanceof String)) {
                        throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(item)));
                    }
                    if ("Do Not Open".equals(item)) {
                        return UiResourceManager.getInstance().getImage("DoNotOpen");
                    }
                    return UiResourceManager.getInstance().getImage("ExplorationView");
                }
            }, false);
            this.m_openExplorationViewOptionsCombo.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            ExplorationViewStructureMode selectStructureMode = StandaloneActions.getInstance().getOpenExplorationViewAutomatically();
            this.m_openExplorationViewOptionsCombo.setItems(modePresentationNameToMode.keySet(), (Object)(selectStructureMode == null ? "Do Not Open" : selectStructureMode.getPresentationName()));
            this.m_openExplorationViewListener = new ComboWithImages.IItemSelectionListener(){

                public void itemSelected(ComboWithImages source, Object item) {
                    if (!($assertionsDisabled || item != null && item instanceof String)) {
                        throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                    }
                    StandaloneActions.getInstance().setOpenExplorationViewAutomatically((ExplorationViewStructureMode)modePresentationNameToMode.get(item));
                }
            };
        } else {
            this.m_openExplorationView = null;
            this.m_openExplorationViewOptionsCombo = null;
            this.m_openExplorationViewListener = null;
        }
        this.m_lruList = new Group((Composite)this, 0);
        this.m_lruList.setText("Open Recently Used");
        this.m_lruList.setBackground(this.getBackground());
        this.m_lruList.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        RowLayout lruListLayout = new RowLayout(512);
        lruListLayout.marginHeight = 4;
        lruListLayout.marginWidth = 4;
        lruListLayout.spacing = 4;
        lruListLayout.wrap = false;
        lruListLayout.pack = true;
        this.m_lruList.setLayout((Layout)lruListLayout);
    }

    void recreateEntries() {
        PersistentRecentlyUsedList recentlyUsedList;
        this.setRedraw(false);
        this.m_currentLastRecentlyUsedPaths.clear();
        Control[] controlArray = this.m_lruList.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control next = controlArray[n2];
            next.setVisible(false);
            next.dispose();
            ++n2;
        }
        this.m_loadLastSnapshotOnOpen.removeSelectionListener((SelectionListener)this.m_loadLastSnapshotOnOpenListener);
        this.m_loadLastSnapshotOnOpen.setSelection(LoadLastSnapshotOnOpenHandler.isActive());
        this.m_loadLastSnapshotOnOpen.addSelectionListener((SelectionListener)this.m_loadLastSnapshotOnOpenListener);
        this.m_refreshOnOpen.removeSelectionListener((SelectionListener)this.m_refreshOnOpenListener);
        this.m_refreshOnOpen.setSelection(RefreshSoftwareSystemOnOpenHandler.isActive());
        this.m_refreshOnOpen.addSelectionListener((SelectionListener)this.m_refreshOnOpenListener);
        this.m_analyzerExecutionLevelListeners.forEach(l -> l.getButton().removeSelectionListener((SelectionListener)l));
        this.m_analyzerExecutionLevelListeners.forEach(l -> l.getButton().setSelection(this.m_provider.getAnalyzerExecutionLevel().equals((Object)l.getLevel())));
        this.m_analyzerExecutionLevelListeners.forEach(l -> l.getButton().addSelectionListener((SelectionListener)l));
        if (this.m_openExplorationViewOptionsCombo != null) {
            this.m_openExplorationViewOptionsCombo.setSelectionListener(null);
            ExplorationViewStructureMode selectStructureMode = StandaloneActions.getInstance().getOpenExplorationViewAutomatically();
            this.m_openExplorationViewOptionsCombo.setSelected((Object)(selectStructureMode == null ? "Do Not Open" : selectStructureMode.getPresentationName()));
            this.m_openExplorationViewOptionsCombo.setSelectionListener(this.m_openExplorationViewListener);
        }
        if ((recentlyUsedList = this.m_provider.getRecentlyUsedList()).getNumberOfEntries() > 0) {
            block9: for (String next : recentlyUsedList.getAll()) {
                this.m_currentLastRecentlyUsedPaths.add(next);
                ISoftwareSystemProvider.PathType pathType = this.m_provider.getPathType(next);
                String image = null;
                if (pathType != null) {
                    switch (pathType) {
                        case SNAPSHOT: {
                            if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.OPEN_SOFTWARE_SYSTEM_FROM_SNAPSHOT, null)) continue block9;
                            image = "Snapshot";
                            break;
                        }
                        case SOFTWARE_SYSTEM: {
                            if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.OPEN_SOFTWARE_SYSTEM, null)) continue block9;
                            image = "OpenSystem";
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled path type: " + String.valueOf(pathType);
                            break;
                        }
                    }
                }
                final String canonicalPath = FileUtility.getCanonicalFilePath((TFile)new TFile(next));
                LinkWithImage path = new LinkWithImage((Composite)this.m_lruList, canonicalPath, image, UiResourceManager.getInstance().getForegroundColor());
                switch (pathType) {
                    case SOFTWARE_SYSTEM: {
                        path.addListener(3, new Listener(){

                            public void handleEvent(Event event) {
                                OpenRecentlyUsedSoftwareSystemHandler.performOpen(LastRecentlyUsedSystemsWidget.this.m_context, new TFile(canonicalPath), false);
                            }
                        });
                        break;
                    }
                    case SNAPSHOT: {
                        path.addListener(3, new Listener(){

                            public void handleEvent(Event event) {
                                OpenRecentlyUsedSoftwareSystemFromSnapshotHandler.performOpen(LastRecentlyUsedSystemsWidget.this.m_context, canonicalPath);
                            }
                        });
                        break;
                    }
                    default: {
                        assert (false) : "Unsupported path type: " + String.valueOf(pathType);
                        continue block9;
                    }
                }
            }
        }
        this.layout(true, true);
        this.setRedraw(true);
    }

    static final class AnalyzerExecutionLevelSelectionListener
    extends SelectionAdapter {
        private final AnalyzerExecutionLevel m_level;
        private final Button m_button;

        AnalyzerExecutionLevelSelectionListener(AnalyzerExecutionLevel level, Button button) {
            assert (level != null) : "Parameter 'level' of method 'AnalyzerExecutionLevelSelectionListener' must not be null";
            assert (button != null) : "Parameter 'button' of method 'AnalyzerExecutionLevelSelectionListener' must not be null";
            this.m_level = level;
            this.m_button = button;
        }

        AnalyzerExecutionLevel getLevel() {
            return this.m_level;
        }

        Button getButton() {
            return this.m_button;
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.m_button.getSelection()) {
                SetAnalyzerExecutionLevelCommand command = new SetAnalyzerExecutionLevelCommand(WorkbenchRegistry.getInstance().getProvider(), new SetAnalyzerExecutionLevelCommand.ISetAnalyzerExecutionLevelInteraction(){

                    public boolean collect(SetAnalyzerExecutionLevelCommand.SetAnalyzerExecutionLevelData data) {
                        if (!$assertionsDisabled && data == null) {
                            throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                        }
                        data.setLevel(m_level);
                        return true;
                    }
                });
                UserInterfaceAdapter.getInstance().run((Command)command, new CommandResultConsumer(){

                    public void consume(CommandException exception) {
                        super.consume(exception);
                        if (exception == null) {
                            WorkbenchRegistry.getInstance().saveAnalyzerExecutionLevel(m_level);
                            WorkbenchRegistry.getInstance().refreshUIElements();
                        }
                    }
                });
            }
        }
    }
}

