/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AttachSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.ISnapshotProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SnapshotRelatedHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.widgets.FileDialog;

public final class AttachSnapshotHandler
extends SnapshotRelatedHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.ATTACH_SNAPSHOT;
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        return this.isAvailable(menuItem) && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && WorkbenchRegistry.getInstance().getSoftwareSystem().getMode() == SoftwareSystemMode.SYSTEM;
    }

    @Execute
    public void execute() {
        assert (WorkbenchRegistry.getInstance().getSoftwareSystem() != null) : "No system available";
        UserInterfaceAdapter.getInstance().run((Command)new AttachSnapshotCommand(WorkbenchRegistry.getInstance().getProvider(), (AttachSnapshotCommand.IAttachSnapshotInteraction)new Interaction()));
    }

    private static final class Interaction
    extends SaveCommandInteraction
    implements AttachSnapshotCommand.IAttachSnapshotInteraction {
        Interaction() {
            super(true);
        }

        public boolean collect(AttachSnapshotCommand.SnapshotData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public void run() {
                    FileDialog dialog = new FileDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 4096);
                    List extensions = ((ISnapshotProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(ISnapshotProvider.class)).getPossibleSnapshotExtensions();
                    dialog.setFilterExtensions(extensions.toArray(new String[extensions.size()]));
                    dialog.setFilterPath(WorkbenchRegistry.getInstance().getProvider().getLocation("AttachSnapshot"));
                    this.setResult(dialog.open());
                    WorkbenchRegistry.getInstance().getProvider().setLocation("AttachSnapshot", dialog.getFilterPath());
                }
            };
            UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
            String filePath = (String)runnable.getResult();
            if (filePath != null && !filePath.isEmpty()) {
                data.setFilePath(filePath);
                return true;
            }
            return false;
        }

        public boolean confirm(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirm' must not be empty";
            return UserInterfaceAdapter.getInstance().question(message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void processAttachResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processAttachResult' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

