/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import org.eclipse.swt.widgets.Label;

class AnalyzerStateUpdater {
    private AnalyzerStateUpdater() {
    }

    static void updateSystemAnalyzerState(Label label, boolean running) {
        assert (label != null) : "Parameter 'label' of method 'updateSystemAnalyzerState' must not be null";
        AnalyzerExecutionLevel currentAnalyzerExecutionLevel = WorkbenchRegistry.getInstance().getProvider().getAnalyzerExecutionLevel();
        AnalyzerExecutionLevel lastAppliedAnalyzerExecutionLevel = WorkbenchRegistry.getInstance().getProvider().getLastAppliedAnalyzerExecutionLevel();
        AnalyzerState state = running ? AnalyzerState.RUNNING : (lastAppliedAnalyzerExecutionLevel != null ? AnalyzerState.FINISHED : AnalyzerState.HAVE_NOT_BEEN_RUN);
        StringBuilder builder = new StringBuilder(state.getPresentationName());
        switch (state) {
            case HAVE_NOT_BEEN_RUN: {
                builder.append(" (execution level '").append(currentAnalyzerExecutionLevel.getPresentationName()).append("')");
                break;
            }
            case RUNNING: {
                assert (lastAppliedAnalyzerExecutionLevel != null) : "'lastAppliedAnalyzerExecutionLevel' of method 'updateSystemAnalyzerStateLabel' must not be null";
                builder.append(" (execution level '").append(lastAppliedAnalyzerExecutionLevel.getPresentationName()).append("')");
                break;
            }
            case FINISHED: {
                assert (lastAppliedAnalyzerExecutionLevel != null) : "'lastAppliedAnalyzerExecutionLevel' of method 'updateSystemAnalyzerStateLabel' must not be null";
                if (!lastAppliedAnalyzerExecutionLevel.equals((Object)currentAnalyzerExecutionLevel)) {
                    builder.append(" (applied execution level '").append(lastAppliedAnalyzerExecutionLevel.getPresentationName()).append("', currently set execution level '").append(currentAnalyzerExecutionLevel.getPresentationName()).append("')");
                    break;
                }
                builder.append(" (execution level '").append(lastAppliedAnalyzerExecutionLevel.getPresentationName()).append("')");
                break;
            }
            default: {
                assert (false) : "Unhandled state: " + String.valueOf((Object)state);
                break;
            }
        }
        label.setText(builder.toString());
    }

    static enum AnalyzerState implements IStandardEnumeration
    {
        HAVE_NOT_BEEN_RUN,
        RUNNING,
        FINISHED;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

