/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.FloatThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IntegerThreshold;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class ThresholdDialog
extends StandardDialog {
    private final IMetricsProvider m_metricsProvider;
    private IMetricThreshold m_threshold;
    private ComboViewer m_levelComboViewer;
    private ComboViewer m_metricsComboViewer;
    private ValidatingTextWidget m_lowerThresholdField;
    private ValidatingTextWidget m_upperThresholdField;
    private ComboViewer m_severityComboViewer;
    private IMetricLevel m_currentLevel;
    private IMetricDescriptor m_currentMetric;
    private Number m_lowerThreshold = 0;
    private Number m_upperThreshold = 0;
    private Number m_lastNumberParsed;
    private boolean m_validThresholds = true;
    private boolean m_lowerThresholdModified = false;
    private boolean m_upperThresholdModified = false;
    private ITextValidator m_numberValidator;
    private Severity m_currentSeverity;

    public ThresholdDialog(Shell parentShell, String title, SoftwareSystem system, IMetricDescriptor descriptor) {
        super(parentShell, title);
        assert (system != null) : "Parameter 'system' of method 'ThresholdDialog' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'ThresholdDialog' must not be null";
        this.m_metricsProvider = (IMetricsProvider)((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricsProvider.class);
        this.m_threshold = null;
        this.m_currentLevel = descriptor.getLevel();
        this.m_currentMetric = descriptor;
        this.m_lowerThresholdModified = true;
        this.m_upperThresholdModified = true;
        this.m_currentSeverity = Severity.WARNING;
    }

    public ThresholdDialog(Shell parentShell, String title, SoftwareSystem system, IMetricThreshold threshold) {
        super(parentShell, title);
        assert (system != null) : "Parameter 'system' of method 'ThresholdDialog' must not be null";
        this.m_metricsProvider = (IMetricsProvider)((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricsProvider.class);
        this.m_threshold = threshold;
        if (threshold != null) {
            this.m_currentLevel = threshold.getMetricDescriptor().getLevel();
            this.m_currentMetric = threshold.getMetricDescriptor();
            this.m_lowerThreshold = threshold.getLowerThreshold();
            this.m_upperThreshold = threshold.getUpperThreshold();
            this.m_currentSeverity = threshold.getSeverity();
        } else {
            this.m_currentLevel = CoreMetricLevel.SYSTEM;
            this.m_currentSeverity = Severity.WARNING;
        }
    }

    private static ITextValidator getNumberValidator(IMetricDescriptor metricDescriptor) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getNumberValidator' must not be null";
        return ((IMetricsProvider)WorkbenchRegistry.getInstance().getInstallation().getExtension(IMetricsProvider.class)).getNumberValidator(metricDescriptor.isFloat());
    }

    protected void fillDialogArea(Composite composite) {
        Label levelLabel = new Label(composite, 0);
        levelLabel.setText("Metric Level:");
        this.m_levelComboViewer = new ComboViewer(composite);
        this.m_levelComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_levelComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_levelComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IMetricLevel)) {
                    throw new AssertionError((Object)("Unexpected class: " + element.getClass().getName()));
                }
                return ((IMetricLevel)element).getPresentationName();
            }
        });
        List levels = this.m_metricsProvider.getAvailableElementMetricLevels(true, false);
        this.m_levelComboViewer.setInput((Object)levels);
        this.m_levelComboViewer.getCombo().select(levels.indexOf(this.m_currentLevel));
        if (this.m_currentMetric != null) {
            this.m_levelComboViewer.getCombo().setEnabled(false);
        } else {
            this.m_levelComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!$assertionsDisabled && !(selection.getFirstElement() instanceof IMetricLevel)) {
                        throw new AssertionError((Object)("Unexpected class: " + selection.getFirstElement().getClass().getName()));
                    }
                    IMetricLevel selected = (IMetricLevel)selection.getFirstElement();
                    ThresholdDialog.this.handleMetricLevelChanged(selected);
                }
            });
        }
        Label metricsLabel = new Label(composite, 0);
        metricsLabel.setText("Available Metrics:");
        this.m_metricsComboViewer = new ComboViewer(composite);
        this.m_metricsComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_metricsComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_metricsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IMetricDescriptor)) {
                    throw new AssertionError((Object)("Unexpected class: " + element.getClass().getName()));
                }
                return ((IMetricDescriptor)element).getShortName();
            }
        });
        List metrics = this.m_metricsProvider.getAvailableMetricDescriptorsForLevel(this.m_currentLevel, false);
        Collections.sort(metrics, new Comparator<IMetricDescriptor>(){

            @Override
            public int compare(IMetricDescriptor o1, IMetricDescriptor o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }
        });
        this.m_metricsComboViewer.setInput((Object)metrics);
        if (this.m_currentMetric == null) {
            this.m_currentMetric = (IMetricDescriptor)metrics.get(0);
        } else {
            this.m_metricsComboViewer.getCombo().setEnabled(false);
        }
        this.m_numberValidator = ThresholdDialog.getNumberValidator(this.m_currentMetric);
        this.m_metricsComboViewer.getCombo().select(metrics.indexOf(this.m_currentMetric));
        if (this.m_metricsComboViewer.getCombo().isEnabled()) {
            this.m_metricsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!$assertionsDisabled && !(selection.getFirstElement() instanceof IMetricDescriptor)) {
                        throw new AssertionError((Object)("Unexpected class: " + selection.getFirstElement().getClass().getName()));
                    }
                    IMetricDescriptor selected = (IMetricDescriptor)selection.getFirstElement();
                    ThresholdDialog.this.handleMetricChanged(selected);
                }
            });
        }
        Label lowerLabel = new Label(composite, 0);
        lowerLabel.setText("Lower Threshold:");
        this.m_lowerThresholdField = new ValidatingTextWidget(composite, (ITextValidator)new LowerThresholdValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                ThresholdDialog.this.m_lowerThresholdModified = inputModified;
                ThresholdDialog.this.getButton(0).setEnabled(ThresholdDialog.this.hasValidData());
            }
        }, NumberUtility.format((Number)this.m_lowerThreshold), 131072);
        this.m_lowerThresholdField.setLayoutData((Object)new GridData(4, 128, true, false));
        Label upperLabel = new Label(composite, 0);
        upperLabel.setText("Upper Threshold:");
        this.m_upperThresholdField = new ValidatingTextWidget(composite, (ITextValidator)new UpperThresholdValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                ThresholdDialog.this.m_upperThresholdModified = inputModified;
                ThresholdDialog.this.getButton(0).setEnabled(ThresholdDialog.this.hasValidData());
            }
        }, NumberUtility.format((Number)this.m_upperThreshold), 131072);
        this.m_upperThresholdField.setLayoutData((Object)new GridData(4, 128, true, false));
        Label severityLabel = new Label(composite, 0);
        severityLabel.setText("Violation Severity:");
        this.m_severityComboViewer = new ComboViewer(composite);
        this.m_severityComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_severityComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_severityComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof Severity)) {
                    throw new AssertionError((Object)("Unexpected class: " + element.getClass().getName()));
                }
                return ((Severity)element).getStandardName();
            }
        });
        List<Severity> severities = Arrays.asList(Severity.WARNING, Severity.ERROR);
        assert (severities.contains(this.m_currentSeverity));
        this.m_severityComboViewer.setInput(severities);
        this.m_severityComboViewer.getCombo().select(severities.indexOf(this.m_currentSeverity));
        this.m_severityComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!$assertionsDisabled && !(selection.getFirstElement() instanceof Severity)) {
                    throw new AssertionError((Object)("Unexpected class: " + selection.getFirstElement().getClass().getName()));
                }
                ThresholdDialog.this.m_currentSeverity = (Severity)selection.getFirstElement();
                Button ok = ThresholdDialog.this.getButton(0);
                if (ok != null) {
                    ok.setEnabled(ThresholdDialog.this.hasValidData());
                }
            }
        });
        super.fillDialogArea(composite);
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.hasValidData());
        return result;
    }

    private ValidationResult checkNumber(ValidatingTextWidget widget, String initialInput, String newInput) {
        ValidationResult result = this.m_numberValidator.isValid(initialInput, newInput);
        if (widget != null) {
            widget.clearDecoration();
        }
        this.m_validThresholds = false;
        this.m_lastNumberParsed = NumberUtility.parse((String)newInput, (!this.m_currentMetric.isFloat() ? 1 : 0) != 0, (boolean)true);
        return result;
    }

    private boolean checkRange() {
        if (this.m_lowerThreshold != null && this.m_upperThreshold != null) {
            if (this.m_lowerThreshold.floatValue() > this.m_upperThreshold.floatValue()) {
                return false;
            }
            if (this.m_lowerThresholdField != null) {
                this.m_lowerThresholdField.clearDecoration();
            }
            if (this.m_upperThresholdField != null) {
                this.m_upperThresholdField.clearDecoration();
            }
            this.m_validThresholds = true;
        }
        return true;
    }

    private void resetThresholds() {
        this.m_lowerThreshold = 0;
        this.m_upperThreshold = 0;
        this.m_lowerThresholdField.setText("0");
        this.m_upperThresholdField.setText("0");
        this.getButton(0).setEnabled(true);
    }

    private void handleMetricLevelChanged(IMetricLevel level) {
        this.m_currentLevel = level;
        List metrics = this.m_metricsProvider.getAvailableMetricDescriptorsForLevel(this.m_currentLevel, false);
        assert (metrics != null && !metrics.isEmpty()) : "'metrics' of method 'handleMetricLevelChanged' must not be empty";
        this.m_metricsComboViewer.setInput((Object)metrics);
        this.m_currentMetric = (IMetricDescriptor)metrics.get(0);
        this.m_numberValidator = ThresholdDialog.getNumberValidator(this.m_currentMetric);
        this.m_metricsComboViewer.getCombo().select(0);
        this.resetThresholds();
    }

    private void handleMetricChanged(IMetricDescriptor metric) {
        assert (metric != null) : "Parameter 'metric' of method 'handleMetricChanged' must not be null";
        this.m_currentMetric = metric;
        this.m_numberValidator = ThresholdDialog.getNumberValidator(this.m_currentMetric);
        this.resetThresholds();
    }

    private boolean hasSeverityChanged() {
        return this.m_threshold == null || this.m_threshold.getSeverity() != this.m_currentSeverity;
    }

    public boolean hasValidData() {
        return (this.m_lowerThresholdModified || this.m_upperThresholdModified || this.hasSeverityChanged()) && this.m_validThresholds;
    }

    public IMetricThreshold getThreshold() {
        return this.m_threshold;
    }

    protected void okPressed() {
        if (this.m_threshold == null) {
            this.m_threshold = this.m_currentMetric.isFloat() ? new FloatThreshold(null, this.m_currentMetric, new BigDecimal(this.m_lowerThreshold.toString()), new BigDecimal(this.m_upperThreshold.toString()), this.m_currentSeverity) : new IntegerThreshold(null, this.m_currentMetric, this.m_lowerThreshold.intValue(), this.m_upperThreshold.intValue(), this.m_currentSeverity);
        } else {
            this.m_threshold.setLowerThreshold(this.m_lowerThreshold);
            this.m_threshold.setUpperThreshold(this.m_upperThreshold);
            this.m_threshold.setSeverity(this.m_currentSeverity);
        }
        super.okPressed();
    }

    private class LowerThresholdValidator
    implements ITextValidator {
        private LowerThresholdValidator() {
        }

        public ValidationResult isValid(String initialInput, String newInput) {
            Button ok;
            ValidationResult result = ThresholdDialog.this.checkNumber(ThresholdDialog.this.m_lowerThresholdField, initialInput, newInput);
            ThresholdDialog.this.m_lowerThreshold = null;
            if (result.isSuccess()) {
                ThresholdDialog.this.m_lowerThreshold = ThresholdDialog.this.m_lastNumberParsed;
                if (!ThresholdDialog.this.checkRange()) {
                    result.addError("Lower threshold can't be greater than upper threshold");
                }
            }
            if ((ok = ThresholdDialog.this.getButton(0)) != null) {
                ok.setEnabled(ThresholdDialog.this.hasValidData());
            }
            return result;
        }
    }

    private class UpperThresholdValidator
    implements ITextValidator {
        private UpperThresholdValidator() {
        }

        public ValidationResult isValid(String initialInput, String newInput) {
            Button ok;
            ValidationResult result = ThresholdDialog.this.checkNumber(ThresholdDialog.this.m_upperThresholdField, initialInput, newInput);
            ThresholdDialog.this.m_upperThreshold = null;
            if (result.isSuccess()) {
                ThresholdDialog.this.m_upperThreshold = ThresholdDialog.this.m_lastNumberParsed;
                if (!ThresholdDialog.this.checkRange()) {
                    result.addError("Upper threshold can't be less than lower threshold");
                }
            }
            if ((ok = ThresholdDialog.this.getButton(0)) != null) {
                ok.setEnabled(ThresholdDialog.this.hasValidData());
            }
            return result;
        }
    }
}

