/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.ScmAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.scm.ScmManager;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ScmAnalyzerPropertyPage
extends AnalyzerPropertyPage<ScmAnalyzerConfiguration> {
    private final List<String> m_options = new ArrayList<String>();
    private final String m_originalSelection;
    private String m_selection;
    private org.eclipse.swt.widgets.List m_list;

    public ScmAnalyzerPropertyPage() {
        super((IAnalyzerId)CoreAnalyzerId.SCM_METRICS);
        this.m_options.add("No SCM System");
        this.m_options.addAll(ScmManager.getInstance().getAvailableScmDrivers());
        this.m_selection = (String)((ScmAnalyzerConfiguration)this.getConfiguration()).getValue("ScmName");
        if (this.m_selection == null) {
            this.m_selection = "Auto Detect";
        }
        this.m_originalSelection = this.m_selection;
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.SCM_ANALYZER_PROPERTY_PAGE;
    }

    @Override
    protected void fillDialogArea(Composite composite, ScmAnalyzerConfiguration configuration, boolean readOnly) {
        Label label = new Label(composite, 0);
        label.setText("Select Source Code Management System:");
        this.m_list = new org.eclipse.swt.widgets.List(composite, 2564);
        this.m_list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_options.forEach(option -> this.m_list.add(option));
        this.m_list.select(this.m_options.indexOf(this.m_selection));
        this.m_list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = ScmAnalyzerPropertyPage.this.m_list.getSelectionIndex();
                if (index == -1) {
                    ScmAnalyzerPropertyPage.this.m_list.select(ScmAnalyzerPropertyPage.this.m_options.indexOf("Auto Detect"));
                    ScmAnalyzerPropertyPage.this.m_selection = "Auto Detect";
                } else {
                    ScmAnalyzerPropertyPage.this.m_selection = ScmAnalyzerPropertyPage.this.m_options.get(index);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    protected boolean applyChanges(ScmAnalyzerConfiguration configuration) {
        return !this.m_selection.equals(this.m_originalSelection);
    }

    @Override
    public boolean performOk() {
        if (!this.m_selection.equals(this.m_originalSelection)) {
            ((ScmAnalyzerConfiguration)this.getConfiguration()).setValue("ScmName", (Object)this.m_selection);
        }
        return super.performOk();
    }
}

