/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public final class IntegerConfigurationEntryWidget
extends Composite {
    private final AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor m_property;
    private final IValueListener m_listener;
    private final Spinner m_spinner;

    public IntegerConfigurationEntryWidget(Composite parent, AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor property, int value, IValueListener listener) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'IntegerConfigurationEntryWidget' must not be null";
        assert (property != null) : "Parameter 'property' of method 'IntegerConfigurationEntryWidget' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'IntegerConfigurationEntryWidget' must not be null";
        this.m_property = property;
        this.m_listener = listener;
        String[] strings = property.getPresentationName().split(":");
        assert (strings.length == 2) : "Expected 2:" + property.getPresentationName();
        String propertyTitle = strings[0];
        assert (propertyTitle != null && propertyTitle.length() > 0) : "'propertyTitle' of method 'IntegerConfigurationEntryWidget' must not be empty";
        String propertyExplanation = strings[1];
        assert (propertyExplanation != null && propertyExplanation.length() > 0) : "'propertyExplanation' of method 'IntegerConfigurationEntryWidget' must not be empty";
        this.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        Group group = new Group((Composite)this, 4);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 600;
        group.setLayoutData((Object)gridData);
        group.setText(propertyTitle);
        group.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        Label label = new Label((Composite)group, 64);
        label.setText(propertyExplanation.trim());
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_spinner = new Spinner((Composite)group, 2048);
        this.m_spinner.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_spinner.setMinimum(this.m_property.getMinValue());
        this.m_spinner.setMaximum(this.m_property.getMaxValue());
        this.m_spinner.setSelection(this.m_property.getMaxValue());
        this.m_spinner.setSelection(value);
        GridData spinnerLayoutData = new GridData(1, 2, false, false);
        Point computedSize = this.m_spinner.computeSize(-1, -1);
        spinnerLayoutData.widthHint = computedSize.x;
        this.m_spinner.setLayoutData((Object)spinnerLayoutData);
        this.m_spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IntegerConfigurationEntryWidget.this.m_listener.valueChanged(IntegerConfigurationEntryWidget.this, IntegerConfigurationEntryWidget.this.m_spinner.getSelection());
            }
        });
    }

    public int getValue() {
        return this.m_spinner.getSelection();
    }

    public void setValue(int value) {
        this.m_spinner.setSelection(value);
    }

    public void setEnabled(boolean enabled) {
        this.m_spinner.setEnabled(enabled);
    }

    public static interface IValueListener {
        public void valueChanged(IntegerConfigurationEntryWidget var1, int var2);
    }
}

