/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview.preview;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueElementTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueSourceFileAndLineTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueSourceFileTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptNamedTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptSeverityTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class PreviewIssueRecord {
    private final Severity m_severity;
    private final IIssueId m_issueId;
    private final Element m_affectedElementNode;
    private final int m_line;
    private final String m_description;

    public PreviewIssueRecord(Severity severity, IIssueId issueId, Element affectedElement, String description, int line) {
        assert (severity != null) : "Parameter 'severity' of method 'PreviewIssueRecord' must not be null";
        assert (issueId != null) : "Parameter 'issueId' of method 'PreviewIssueRecord' must not be null";
        assert (affectedElement != null) : "Parameter 'affectedElement' of method 'PreviewIssueRecord' must not be null";
        this.m_severity = severity;
        this.m_issueId = issueId;
        this.m_affectedElementNode = affectedElement;
        this.m_line = line;
        this.m_description = description;
    }

    public Severity getSeverity() {
        return this.m_severity;
    }

    public IIssueId getIssueId() {
        return this.m_issueId;
    }

    public Element getAffectedElement() {
        return this.m_affectedElementNode;
    }

    public int getLine() {
        return this.m_line;
    }

    public String getDescription() {
        return this.m_description;
    }

    public static List<PreviewIssueRecord> convertToList(ScriptNamedTreeNode treeRootNode) {
        assert (treeRootNode != null) : "Parameter 'treeRootNode' of method 'convertToList' must not be null";
        ArrayList<PreviewIssueRecord> result = new ArrayList<PreviewIssueRecord>();
        for (ScriptTreeNode next : treeRootNode.getChildren()) {
            assert (next != null && next instanceof ScriptSeverityTreeNode) : "Unexpected class in method 'convertToList': " + String.valueOf(next);
            ScriptSeverityTreeNode severity = (ScriptSeverityTreeNode)next;
            for (ScriptTreeNode nextIssueId : severity.getChildren()) {
                assert (nextIssueId != null && nextIssueId instanceof ScriptIssueTreeNode) : "Unexpected class in method 'convertToList': " + String.valueOf(nextIssueId);
                ScriptIssueTreeNode issueId = (ScriptIssueTreeNode)nextIssueId;
                for (ScriptTreeNode nextIssue : issueId.getChildren()) {
                    List subNodes = nextIssue.getChildren();
                    if (subNodes.size() > 0) {
                        for (ScriptTreeNode nextSubNode : subNodes) {
                            result.add(PreviewIssueRecord.convertToPreviewIssue(severity.getSeverity(), (IIssueId)issueId.getIssueId(), nextSubNode));
                        }
                        continue;
                    }
                    result.add(PreviewIssueRecord.convertToPreviewIssue(severity.getSeverity(), (IIssueId)issueId.getIssueId(), nextIssue));
                }
            }
        }
        Collections.sort(result, new Comparator<PreviewIssueRecord>(){

            @Override
            public final int compare(PreviewIssueRecord r1, PreviewIssueRecord r2) {
                int idCompare = r1.getIssueId().getPresentationName().compareTo(r2.getIssueId().getPresentationName());
                if (idCompare != 0) {
                    return idCompare;
                }
                int severityCompare = r1.getSeverity().compareTo((Enum)r2.getSeverity());
                if (severityCompare != 0) {
                    return severityCompare;
                }
                int elementCompare = r1.getAffectedElement().getPresentationName(false).compareTo(r2.getAffectedElement().getPresentationName(false));
                if (elementCompare != 0) {
                    return elementCompare;
                }
                return Integer.compare(r1.getLine(), r2.getLine());
            }
        });
        return result;
    }

    private static PreviewIssueRecord convertToPreviewIssue(Severity severity, IIssueId id, ScriptTreeNode node) {
        assert (severity != null) : "Parameter 'severity' of method 'convertToPreviewIssue' must not be null";
        assert (id != null) : "Parameter 'id' of method 'convertToPreviewIssue' must not be null";
        assert (node != null) : "Parameter 'node' of method 'convertToPreviewIssue' must not be null";
        if (node instanceof ScriptIssueElementTreeNode) {
            ScriptIssueElementTreeNode issue = (ScriptIssueElementTreeNode)node;
            return new PreviewIssueRecord(severity, id, issue.getElement(), issue.getDescription(), issue.getElement().getLineNumber());
        }
        if (node instanceof ScriptIssueSourceFileAndLineTreeNode) {
            ScriptIssueSourceFileAndLineTreeNode issue = (ScriptIssueSourceFileAndLineTreeNode)node;
            return new PreviewIssueRecord(severity, id, (Element)issue.getElement(), issue.getDescription(), issue.getLine());
        }
        if (node instanceof ScriptIssueSourceFileTreeNode) {
            ScriptIssueSourceFileTreeNode issue = (ScriptIssueSourceFileTreeNode)node;
            return new PreviewIssueRecord(severity, id, (Element)issue.getElement(), issue.getDescription(), issue.getLine());
        }
        return null;
    }
}

