/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.script.CreateGroovyScriptCommand;
import com.hello2morrow.sonargraph.core.command.system.script.ModifyGroovyScriptConfigurationCommand;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.common.StandardCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ScriptWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public final class ScriptWizard
extends NonLazySonargraphWizard {
    private final DirectoryPath m_inDirectory;
    private final GroovyScript m_toBeEdited;
    private final ScriptContent.Builder m_builder;
    private ScriptWizardPage m_page;

    public ScriptWizard(DirectoryPath directoryPath) {
        super("New Script File In '" + (directoryPath != null ? directoryPath.getPresentationName(false) : "") + "'");
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'ScriptWizard' must not be null";
        this.m_inDirectory = directoryPath;
        this.m_toBeEdited = null;
        this.m_builder = new ScriptContent.Builder();
    }

    public ScriptWizard(GroovyScript toBeEdited) {
        super("Edit Script File");
        assert (toBeEdited != null) : "Parameter 'toBeEdited' of method 'NewGroovyScriptWizard' must not be null";
        this.m_toBeEdited = toBeEdited;
        this.m_inDirectory = (DirectoryPath)toBeEdited.getParent(DirectoryPath.class, new Class[0]);
        assert (this.m_inDirectory != null) : "Parameter 'm_selectedDirectory' of method 'ScriptWizard' must not be null";
        this.m_builder = new ScriptContent.Builder(toBeEdited.getScriptContent());
    }

    public int getPreferredWidth() {
        return 900;
    }

    public int getPreferredHeight() {
        return 500;
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        IGroovyProvider groovyProvider = (IGroovyProvider)provider.getSoftwareSystem().getExtension(IGroovyProvider.class);
        this.m_page = new ScriptWizardPage(groovyProvider, this.m_builder, "Specify name and description and manage parameter definitions", "Name:", groovyProvider.getAvailableLanguages(), groovyProvider.getScriptNameValidator(this.m_inDirectory), this.m_toBeEdited != null ? groovyProvider.getNameForEdit(this.m_toBeEdited) : "");
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean canFinish() {
        if (super.canFinish()) {
            if (this.m_toBeEdited == null) {
                return true;
            }
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No system available";
            return ((IGroovyProvider)provider.getSoftwareSystem().getExtension(IGroovyProvider.class)).hasScriptConfigurationChanged(this.m_toBeEdited, this.m_page.getElementName(), this.m_builder.build());
        }
        return false;
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            if (this.m_toBeEdited != null) {
                ModifyGroovyScriptConfigurationCommand modifyCommand = new ModifyGroovyScriptConfigurationCommand(provider, (ModifyGroovyScriptConfigurationCommand.IModifyGroovyScriptConfigurationInteraction)new ModifyInteraction());
                UserInterfaceAdapter.getInstance().run((Command)modifyCommand);
            } else {
                final CreateGroovyScriptCommand createCommand = new CreateGroovyScriptCommand(provider, (CreateGroovyScriptCommand.ICreateGroovyScriptInteraction)new CreateInteraction());
                UserInterfaceAdapter.getInstance().run((Command)createCommand, new CommandResultConsumer(){

                    public void consume(CommandException exception) {
                        super.consume(exception);
                        if (exception == null) {
                            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                                @Override
                                public void run() {
                                    ShowInViewSelectionAdapter.showInView((IEclipseContext)WorkbenchRegistry.getInstance().getEclipseContext(), (EPartService)WorkbenchRegistry.getInstance().getPartService(), (IViewId)ViewId.SCRIPT_VIEW, (String)createCommand.getGroovyScript().getFileId(), Collections.emptyList(), Collections.singletonList(createCommand.getGroovyScript()), (boolean)false);
                                }
                            });
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    final class CreateInteraction
    extends StandardCommandInteraction
    implements CreateGroovyScriptCommand.ICreateGroovyScriptInteraction {
        CreateInteraction() {
        }

        public boolean collect(CreateGroovyScriptCommand.CreateGroovyScriptData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            data.setName(ScriptWizard.this.m_page.getElementName());
            data.setScriptContent(ScriptWizard.this.m_builder.build());
            data.setBaseDirectory(ScriptWizard.this.m_inDirectory);
            return true;
        }

        public void processCreateGroovyScriptResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    final class ModifyInteraction
    extends StandardCommandInteraction
    implements ModifyGroovyScriptConfigurationCommand.IModifyGroovyScriptConfigurationInteraction {
        ModifyInteraction() {
        }

        public boolean collect(ModifyGroovyScriptConfigurationCommand.ModifyGroovyScriptConfigurationData data) {
            data.setName(ScriptWizard.this.m_page.getElementName());
            data.setScript(ScriptWizard.this.m_toBeEdited);
            data.setScriptContent(ScriptWizard.this.m_builder.build());
            return true;
        }

        public boolean confirmSaveOnEdit() {
            return UserInterfaceAdapter.getInstance().question("The script file has changes and will be saved immediately to a new file." + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR + "Do you want to proceed?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public void process(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'process' must not be null";
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

