/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.model.script.ScriptMetricValueTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ScriptTreeNodeContentProvider;
import java.util.Arrays;
import java.util.Comparator;

public class ScriptMetricNodeContentProvider
extends ScriptTreeNodeContentProvider {
    private int m_sortOrder = 1024;
    private Column m_sortColumn = Column.VALUE;

    @Override
    public Object[] getChildren(Object element) {
        Object[] result = super.getChildren(element);
        if (this.m_sortColumn == Column.VALUE) {
            Arrays.sort(result, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    ScriptMetricValueTreeNode n1 = (ScriptMetricValueTreeNode)o1;
                    ScriptMetricValueTreeNode n2 = (ScriptMetricValueTreeNode)o2;
                    int result = Double.compare(n1.getValue().doubleValue(), n2.getValue().doubleValue());
                    return ScriptMetricNodeContentProvider.this.m_sortOrder == 1024 ? result * -1 : result;
                }
            });
        } else {
            Arrays.sort(result, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    ScriptMetricValueTreeNode n1 = (ScriptMetricValueTreeNode)o1;
                    ScriptMetricValueTreeNode n2 = (ScriptMetricValueTreeNode)o2;
                    int result = n1.getName().compareTo(n2.getName());
                    return ScriptMetricNodeContentProvider.this.m_sortOrder == 1024 ? result * -1 : result;
                }
            });
        }
        return result;
    }

    public void applySorting(Column column, int order) {
        assert (column != null) : "Parameter 'column' of method 'applySorting' must not be null";
        assert (order == 128 || order == 1024) : "Parameter 'order' of method 'applySorting' must either be SWT.UP or SWT.DOWN, but was " + order;
        this.m_sortColumn = column;
        this.m_sortOrder = order;
    }

    public static enum Column {
        LABEL,
        VALUE;

    }
}

