/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.script.CreateScriptDirectoryCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;

public final class ScriptDirectoryWizard
extends NonLazySonargraphWizard {
    private final ISoftwareSystemProvider m_provider;
    private final DirectoryPath m_selectedDirectory;
    private NameAndDescriptionWizardPage m_page;

    public ScriptDirectoryWizard(DirectoryPath directoryPath) {
        super("New Script Directory");
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'ScriptDirectoryWizard' must not be null";
        this.m_provider = WorkbenchRegistry.getInstance().getProvider();
        this.m_selectedDirectory = directoryPath;
    }

    public void addPages() {
        assert (this.m_provider.hasSoftwareSystem()) : "No system available";
        this.m_page = new NameAndDescriptionWizardPage("PAGE_1", "Specify the directory name", "Directory Name:", CreateScriptDirectoryCommand.getDirectoryNameValidator((ISoftwareSystemProvider)this.m_provider, (DirectoryPath)this.m_selectedDirectory), "", null);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            final String directoryName = this.m_page.getElementName();
            assert (directoryName != null && directoryName.length() > 0) : "'subdirectoryFile' of method 'internalExecute' must not be empty";
            CreateScriptDirectoryCommand.IInteraction interaction = new CreateScriptDirectoryCommand.IInteraction(){

                public INavigationState getNavigationState() {
                    return ViewNavigationManager.getInstance().getCurrentNavigationState();
                }

                public void processCreateGroovyDirectoryResult(OperationResult result) {
                    UserInterfaceAdapter.getInstance().process(result);
                }

                public boolean collect(CreateScriptDirectoryCommand.GroovyDirectoryData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setDirectoryName(directoryName);
                    data.setParentDirectory(ScriptDirectoryWizard.this.m_selectedDirectory);
                    return true;
                }
            };
            ISoftwareSystemProvider softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
            CreateScriptDirectoryCommand cmd = new CreateScriptDirectoryCommand(softwareSystemProvider, interaction);
            UserInterfaceAdapter.getInstance().run((Command)cmd);
            return true;
        }
        return false;
    }
}

